/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.core.preferences;

import com.sap.netweaver.ep.core.preferences.Server;
import com.sap.netweaver.ep.ui.EnterprisePortalPlugin;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;

public class ServerConfig {
    private static Vector mm_configList = new Vector();
    private static Vector mm_previousConfigList = new Vector();
    private static String mm_defaultServerAlias;
    private static String SERVERS_DIR;
    private static String mm_path;
    public static final String P_ALIAS = "ALIAS";
    public static final String P_HOST = "HOST";
    public static final String P_PORT = "PORT";
    public static final String P_LOGIN = "LOGIN";
    public static final String P_DEFAULT = "DEFAULT";
    public static final String P_DESCRIPTION = "DESCRIPTION";
    private static Server mm_lastConfig;

    public static Vector loadServerList() {
        mm_previousConfigList = mm_configList;
        String[] preferenceNames = ServerConfig.getConfigNames();
        if (preferenceNames == null || preferenceNames.length == 0) {
            return null;
        }
        mm_configList = new Vector();
        int i = 0;
        while (i < preferenceNames.length) {
            try {
                FileInputStream fis = new FileInputStream(mm_path + SERVERS_DIR + preferenceNames[i]);
                Preferences pref = new Preferences();
                pref.load((InputStream)fis);
                Server config = new Server(pref.getString(P_ALIAS), pref.getString(P_HOST), Integer.parseInt(pref.getString(P_PORT)), pref.getString(P_LOGIN), pref.getString(P_DESCRIPTION), pref.getBoolean(P_DEFAULT));
                if (pref.getBoolean(P_DEFAULT)) {
                    mm_defaultServerAlias = pref.getString(P_ALIAS);
                }
                int j = 0;
                while (j < mm_previousConfigList.size()) {
                    Server os = (Server)mm_previousConfigList.get(j);
                    if (os.equals(config)) {
                        config.setPasswd(os.getPassword());
                    }
                    ++j;
                }
                mm_configList.addElement(config);
                fis.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                SapPortalPluginsLogger.logError((Object)e, "Get Preference from a server failed with name: " + preferenceNames[i]);
            }
            catch (IOException e) {
                e.printStackTrace();
                SapPortalPluginsLogger.logError((Object)e, "Input Stream failed to close whren reading filename: " + preferenceNames[i]);
            }
            ++i;
        }
        return mm_configList;
    }

    public static void saveConfiguration(Vector serverList) {
        mm_configList = serverList;
        ServerConfig.cleanServers();
        int i = 0;
        while (i < serverList.size()) {
            Server s = (Server)serverList.elementAt(i);
            if (s.isDefault()) {
                mm_defaultServerAlias = s.getAlias();
            }
            ServerConfig.saveServerToDisk(s);
            ++i;
        }
    }

    public static void saveConfiguration() {
        int i = 0;
        while (i < mm_configList.size()) {
            ServerConfig.saveServerToDisk((Server)mm_configList.elementAt(i));
            ++i;
        }
    }

    public static Vector getServerList() {
        return mm_configList;
    }

    public static Vector getPreviousServerList() {
        return mm_previousConfigList;
    }

    public static Server getServer(String alias) {
        int i = 0;
        while (i < mm_configList.size()) {
            Server currentServer = (Server)mm_configList.elementAt(i);
            if (currentServer.getAlias().equals(alias)) {
                return currentServer;
            }
            ++i;
        }
        return null;
    }

    public static void setDefaultConfig(String alias) {
        Server defaultConfig = ServerConfig.getServer(alias);
        if (defaultConfig != null) {
            if (ServerConfig.getServer(mm_defaultServerAlias) != null) {
                ServerConfig.getServer(mm_defaultServerAlias).setDefault(false);
            }
            mm_defaultServerAlias = alias;
            defaultConfig.setDefault(true);
        }
    }

    public static Server getDefaultConfig() {
        int i = 0;
        while (i < mm_configList.size()) {
            Server currentServer = (Server)mm_configList.elementAt(i);
            if (currentServer.isDefault()) {
                return currentServer;
            }
            ++i;
        }
        return null;
    }

    public static Server getLastConfig() {
        return mm_lastConfig;
    }

    public static void setLastConfig(String alias) {
        Server srv = ServerConfig.getServer(alias);
        if (srv != null) {
            mm_lastConfig = srv;
        }
    }

    public static void addServer(Server srv) {
        mm_configList.addElement(srv);
    }

    public static int indexOfDefaultConfig() {
        return mm_configList.indexOf(ServerConfig.getDefaultConfig());
    }

    public static void setServerList(Vector v) {
        mm_configList = v;
    }

    private static String[] getConfigNames() {
        File dir = new File(mm_path + SERVERS_DIR);
        if (!dir.exists() && dir.canWrite()) {
            try {
                dir.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                SapPortalPluginsLogger.logError((Object)e, "Error creating servers config directory");
            }
        } else if (dir.isDirectory()) {
            return dir.list();
        }
        return null;
    }

    private static void saveServerToDisk(Server server) {
        Preferences pref = new Preferences();
        try {
            pref.setValue(P_ALIAS, server.getAlias());
            pref.setValue(P_HOST, server.getHost());
            pref.setValue(P_PORT, server.getPort());
            pref.setValue(P_LOGIN, server.getLogin());
            pref.setValue(P_DESCRIPTION, server.getDescription());
            pref.setValue(P_DEFAULT, server.isDefault());
            File pathFile = new File(mm_path + SERVERS_DIR + server.getAlias());
            if (!pathFile.exists()) {
                pathFile.getParentFile().mkdirs();
                pathFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(mm_path + SERVERS_DIR + server.getAlias());
            pref.store((OutputStream)fos, null);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            SapPortalPluginsLogger.logError((Object)e, "Unable to save server configuration file : " + server.getAlias());
        }
        catch (IOException e) {
            SapPortalPluginsLogger.logError((Object)e, "Unable to save server configuration file : " + server.getAlias());
            e.printStackTrace();
        }
    }

    private static void cleanServers() {
        String[] listServersOnDisk = ServerConfig.getConfigNames();
        if (listServersOnDisk == null) {
            return;
        }
        int i = 0;
        while (i < listServersOnDisk.length) {
            File f = new File(mm_path + SERVERS_DIR + listServersOnDisk[i]);
            f.delete();
            ++i;
        }
    }

    static {
        SERVERS_DIR = "servers/";
        mm_path = EnterprisePortalPlugin.getDefault().getStateLocation().toFile().getPath() + File.separator;
    }
}

