/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.wsdlImpl.extensions.soap;

import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.QNameUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPHeaderSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPHeader;

    public void marshall(Class parentType, javax.wsdl.QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPHeader soapHeader = (SOAPHeader)extension;
        if (soapHeader != null) {
            String tagName = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"header", (Definition)def);
            pw.print("        <" + tagName);
            DOMUtils.printQualifiedAttribute((String)"message", (QName)soapHeader.getMessage(), (Definition)def, (PrintWriter)pw);
            DOMUtils.printAttribute((String)"part", (String)soapHeader.getPart(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"use", (String)soapHeader.getUse(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"encodingStyle", (String)ToolKit.getNMTokens(soapHeader.getEncodingStyles()), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"namespace", (String)soapHeader.getNamespaceURI(), (PrintWriter)pw);
            Boolean required = soapHeader.getRequired();
            if (required != null) {
                DOMUtils.printQualifiedAttribute((QName)ISOAPParamConstants.Q_ATTR_REQUIRED, (String)required.toString(), (Definition)def, (PrintWriter)pw);
            }
            pw.println('>');
            SOAPHeaderSerializer.printSoapHeaderFaults(soapHeader.getSOAPHeaderFaults(), def, pw);
            pw.println("        </" + tagName + '>');
        }
    }

    private static void printSoapHeaderFaults(List soapHeaderFaults, Definition def, PrintWriter pw) throws WSDLException {
        if (soapHeaderFaults != null) {
            String tagName = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"headerfault", (Definition)def);
            Iterator soapHeaderFaultIterator = soapHeaderFaults.iterator();
            while (soapHeaderFaultIterator.hasNext()) {
                SOAPHeaderFault soapHeaderFault = (SOAPHeaderFault)soapHeaderFaultIterator.next();
                if (soapHeaderFault == null) continue;
                pw.print("          <" + tagName);
                DOMUtils.printQualifiedAttribute((String)"message", (QName)soapHeaderFault.getMessage(), (Definition)def, (PrintWriter)pw);
                DOMUtils.printAttribute((String)"part", (String)soapHeaderFault.getPart(), (PrintWriter)pw);
                DOMUtils.printAttribute((String)"use", (String)soapHeaderFault.getUse(), (PrintWriter)pw);
                DOMUtils.printAttribute((String)"encodingStyle", (String)ToolKit.getNMTokens(soapHeaderFault.getEncodingStyles()), (PrintWriter)pw);
                DOMUtils.printAttribute((String)"namespace", (String)soapHeaderFault.getNamespaceURI(), (PrintWriter)pw);
                Boolean required = soapHeaderFault.getRequired();
                if (required != null) {
                    DOMUtils.printQualifiedAttribute((QName)ISOAPParamConstants.Q_ATTR_REQUIRED, (String)required.toString(), (Definition)def, (PrintWriter)pw);
                }
                pw.println("/>");
            }
        }
    }

    public ExtensibilityElement unmarshall(Class parentType, javax.wsdl.QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPHeader soapHeader = (SOAPHeader)extReg.createExtension(parentType, elementType);
        javax.wsdl.QName message = DOMUtils.getQualifiedAttributeValue((Element)el, (String)"message", (String)"Header", (boolean)false).getWsdlQName();
        String part = DOMUtils.getAttribute((Element)el, (String)"part");
        String use = DOMUtils.getAttribute((Element)el, (String)"use");
        String encStyleStr = DOMUtils.getAttribute((Element)el, (String)"encodingStyle");
        String namespaceURI = DOMUtils.getAttribute((Element)el, (String)"namespace");
        String requiredStr = DOMUtils.getAttributeNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (message != null) {
            soapHeader.setMessage(new QName(message));
        }
        if (part != null) {
            soapHeader.setPart(part);
        }
        if (use != null) {
            soapHeader.setUse(use);
        }
        if (encStyleStr != null) {
            soapHeader.setEncodingStyles(ToolKit.parseNMTokens(encStyleStr));
        }
        if (namespaceURI != null) {
            soapHeader.setNamespaceURI(namespaceURI);
        }
        if (requiredStr != null) {
            soapHeader.setRequired(Boolean.valueOf(requiredStr));
        }
        Element tempEl = DOMUtils.getFirstChildElement((Element)el);
        while (tempEl != null) {
            if (QNameUtils.matches((QName)ISOAPParamConstants.Q_ELEM_SOAP_HEADER_FAULT, (Node)tempEl)) {
                soapHeader.addSOAPHeaderFault(SOAPHeaderSerializer.parseSoapHeaderFault(class$javax$wsdl$extensions$soap$SOAPHeader == null ? SOAPHeaderSerializer.class$("javax.wsdl.extensions.soap.SOAPHeader") : class$javax$wsdl$extensions$soap$SOAPHeader, ISOAPParamConstants.Q_ELEM_SOAP_HEADER_FAULT.getWsdlQName(), tempEl, extReg));
            } else {
                DOMUtils.throwWSDLException((Element)tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
        return soapHeader;
    }

    private static SOAPHeaderFault parseSoapHeaderFault(Class parentType, javax.wsdl.QName elementType, Element el, ExtensionRegistry extReg) throws WSDLException {
        SOAPHeaderFault soapHeaderFault = (SOAPHeaderFault)extReg.createExtension(parentType, elementType);
        javax.wsdl.QName message = DOMUtils.getQualifiedAttributeValue((Element)el, (String)"message", (String)"Header", (boolean)false).getWsdlQName();
        String part = DOMUtils.getAttribute((Element)el, (String)"part");
        String use = DOMUtils.getAttribute((Element)el, (String)"use");
        String encStyleStr = DOMUtils.getAttribute((Element)el, (String)"encodingStyle");
        String namespaceURI = DOMUtils.getAttribute((Element)el, (String)"namespace");
        String requiredStr = DOMUtils.getAttributeNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (message != null) {
            soapHeaderFault.setMessage(new QName(message));
        }
        if (part != null) {
            soapHeaderFault.setPart(part);
        }
        if (use != null) {
            soapHeaderFault.setUse(use);
        }
        if (encStyleStr != null) {
            soapHeaderFault.setEncodingStyles(ToolKit.parseNMTokens(encStyleStr));
        }
        if (namespaceURI != null) {
            soapHeaderFault.setNamespaceURI(namespaceURI);
        }
        if (requiredStr != null) {
            soapHeaderFault.setRequired(Boolean.valueOf(requiredStr));
        }
        return soapHeaderFault;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

