/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.wsdlImpl.extensions.soap;

import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPFault;
import org.w3c.dom.Element;

public class SOAPFaultSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public void marshall(Class parentType, javax.wsdl.QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPFault soapFault = (SOAPFault)extension;
        if (soapFault != null) {
            String tagName = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"fault", (Definition)def);
            pw.print("        <" + tagName);
            DOMUtils.printAttribute((String)"name", (String)soapFault.getName(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"use", (String)soapFault.getUse(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"encodingStyle", (String)ToolKit.getNMTokens(soapFault.getEncodingStyles()), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"namespace", (String)soapFault.getNamespaceURI(), (PrintWriter)pw);
            Boolean required = soapFault.getRequired();
            if (required != null) {
                DOMUtils.printQualifiedAttribute((QName)ISOAPParamConstants.Q_ATTR_REQUIRED, (String)required.toString(), (Definition)def, (PrintWriter)pw);
            }
            pw.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class parentType, javax.wsdl.QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPFault soapFault = (SOAPFault)extReg.createExtension(parentType, elementType);
        String name = DOMUtils.getAttribute((Element)el, (String)"name");
        String use = DOMUtils.getAttribute((Element)el, (String)"use");
        String encStyleStr = DOMUtils.getAttribute((Element)el, (String)"encodingStyle");
        String namespaceURI = DOMUtils.getAttribute((Element)el, (String)"namespace");
        String requiredStr = DOMUtils.getAttributeNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (name != null) {
            soapFault.setName(name);
        }
        if (use != null) {
            soapFault.setUse(use);
        }
        if (encStyleStr != null) {
            soapFault.setEncodingStyles(ToolKit.parseNMTokens(encStyleStr));
        }
        if (namespaceURI != null) {
            soapFault.setNamespaceURI(namespaceURI);
        }
        if (requiredStr != null) {
            soapFault.setRequired(Boolean.valueOf(requiredStr));
        }
        return soapFault;
    }
}

