/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.wsdl;

import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.mapping.InitMapping;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLValueEncoder;
import com.sapportals.portal.prt.service.soap.wsdl.CustomSerializer;
import com.sapportals.portal.prt.service.soap.wsdl.InformationReport;
import com.sapportals.portal.prt.service.soap.wsdl.JavaToWsdl;
import com.sapportals.portal.prt.service.soap.wsdl.ObjectSchema;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;
import com.sapportals.portal.prt.service.soap.wsdlImpl.xml.WSDLReaderImpl;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GenerateProxy {
    private InputStream mm_inWsdl = null;
    private Class mm_interface_proxy = null;
    private String mm_nameInterface = null;
    private String mm_namePackage = null;
    private String mm_nameService = null;
    private PrintWriter mm_out = null;
    private String mm_path = null;
    private String mm_urlwsdl = null;
    private HashMap mm_customsSerializers = null;
    private Definition mm_def = null;

    public GenerateProxy(String namePackage, String path, String nameService, String nameInterface, String urlwsdl) {
        this.mm_nameService = this.clearName(nameService);
        this.mm_urlwsdl = urlwsdl;
        this.mm_namePackage = namePackage;
        this.mm_nameInterface = nameInterface;
        this.mm_path = path;
        InitMapping.getInstanceInit(this.getClass().getResourceAsStream("/types/soapTypes.xml"));
    }

    public GenerateProxy(String namePackage, String path, String nameService, String nameInterface, String urlwsdl, HashMap cs) {
        this.mm_nameService = this.clearName(nameService);
        this.mm_urlwsdl = urlwsdl;
        this.mm_namePackage = namePackage;
        this.mm_nameInterface = nameInterface;
        this.mm_path = path;
        this.mm_customsSerializers = cs;
        InitMapping.getInstanceInit(this.getClass().getResourceAsStream("/types/soapTypes.xml"));
    }

    private String clearName(String name) {
        if (name.indexOf("I") >= 0) {
            String newname = null;
            newname = name.substring(0, name.indexOf("I"));
            newname = newname + name.substring(name.indexOf("I") + 1, name.length());
            return newname;
        }
        return name;
    }

    public GenerateProxy(String namePackage, String path, String nameService, Class interface_proxy, String urlwsdl, HashMap cs) {
        this.mm_nameService = this.clearName(nameService);
        this.mm_urlwsdl = urlwsdl;
        this.mm_interface_proxy = interface_proxy;
        this.mm_namePackage = namePackage;
        this.mm_nameInterface = this.mm_interface_proxy.getName();
        this.mm_path = path;
        this.mm_customsSerializers = cs;
        InitMapping.getInstanceInit(this.getClass().getResourceAsStream("/types/soapTypes.xml"));
    }

    public static void main(String[] args) {
        try {
            GenerateProxy gproxy = new GenerateProxy("com.sap.portal.prt.webservice", "c:/", "TestWebService", "ITestWebService", "http://localhost:8080/simple/finalwsdl.wsdl");
            gproxy.writeProxy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeProxy() throws Exception {
        try {
            this.initStreams();
            this.mm_def = new WSDLReaderImpl(null).readWSDL(this.mm_urlwsdl, this.mm_inWsdl);
            if (this.mm_namePackage != null && this.mm_namePackage.length() > 0) {
                this.mm_out.println("package " + this.mm_namePackage + ";");
            }
            this.writeImport(this.mm_out);
            this.writeClass(this.mm_out);
            this.writeConstants(this.mm_out);
            this.writeFields(this.mm_out, this.mm_def);
            this.writeTemplatePRTService(this.mm_out);
            this.writeMethods(this.mm_out, this.mm_def);
            this.mm_out.println("}");
            Object var3_1 = null;
            if (this.mm_out != null) {
                this.mm_out.close();
            }
            if (this.mm_inWsdl == null) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (this.mm_out != null) {
                this.mm_out.close();
            }
            if (this.mm_inWsdl == null) throw throwable;
            this.mm_inWsdl.close();
            throw throwable;
        }
        this.mm_inWsdl.close();
    }

    private ObjectSchema getTypeJava(javax.wsdl.QName qwsdl, Types types) {
        ObjectSchema objSch = null;
        SOAPRegistry namep = SOAPRegistry.getInstance();
        QName qname = new QName(qwsdl.getNamespaceURI(), qwsdl.getLocalPart());
        if (qname.getLocalPart().indexOf("ArrayOf") >= 0) {
            objSch = this.getTypeJavaArray(qwsdl, types);
            return objSch;
        }
        Class type = null;
        int i = 0;
        while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length && type == null) {
            type = namep.getJavaType(qname, ISOAPParamConstants.NS_URIS_SCHEMAS[i]);
            ++i;
        }
        if (type != null) {
            objSch = new ObjectSchema(XMLValueEncoder.cleanNameClass(type, (boolean)true), false, qname, null);
            if (!ToolKit.isSimpleSoapEncodingType(type)) {
                objSch = new ObjectSchema(XMLValueEncoder.cleanNameClass((Class)type, (boolean)true), true, qname, null);
            }
        }
        if (objSch == null) {
            String n = this.foundClassFromCS(qname.getLocalPart());
            if (n == null) {
                JavaToWsdl.REPORT_GENERATION.add(new InformationReport("Error during the VPS generation, the type " + qname.getLocalPart() + " not supported ! ", null, 1));
            }
            objSch = new ObjectSchema(n, true, qname, null);
        }
        return objSch;
    }

    private String foundClassFromCS(String nameClass) {
        if (this.mm_customsSerializers != null) {
            Iterator iter = this.mm_customsSerializers.values().iterator();
            while (iter.hasNext()) {
                CustomSerializer item = (CustomSerializer)iter.next();
                if (!item.getLocalpart().equals(nameClass)) continue;
                return item.getJavaType().getName();
            }
        }
        return null;
    }

    private ObjectSchema getTypeJavaArray(javax.wsdl.QName qwsdl, Types types) {
        if (types != null) {
            List l = types.getExtensibilityElements();
            String type = null;
            int i = 0;
            while (i < l.size()) {
                Element schema = ((UnknownExtensibilityElement)l.get(i)).getElement();
                if (schema.getNodeName().equals("schema")) {
                    NodeList list = schema.getElementsByTagName("complexType");
                    int j = 0;
                    while (j < list.getLength()) {
                        NodeList listattr;
                        Element nodeattr;
                        Element node = (Element)list.item(j);
                        String name = DOMUtils.getAttribute((Element)node, (String)"name");
                        if (name != null && name.equals(qwsdl.getLocalPart()) && (type = DOMUtils.getAttribute((Element)(nodeattr = (Element)(listattr = node.getElementsByTagName("attribute")).item(0)), (String)"wsdl:arrayType")) != null) {
                            String prefix = type.substring(0, type.indexOf(":"));
                            String uri = this.mm_def.getNamespace(prefix);
                            javax.wsdl.QName qnameType = new javax.wsdl.QName(uri, type.substring(type.indexOf(":") + 1, type.indexOf("[")));
                            String typeOfArray = this.getTypeJava(qnameType, types).getType() + "[]";
                            return new ObjectSchema(typeOfArray, true, new QName(qnameType), null);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private Message foundRequestMessage(Object[] objs, String nameResponse) {
        String nameRequest = nameResponse.substring(0, nameResponse.indexOf("Response")) + "Request";
        nameRequest = nameRequest + nameResponse.substring(nameResponse.indexOf("Response") + "Response".length(), nameResponse.length());
        int i = 0;
        while (i < objs.length) {
            Message msg = (Message)objs[i];
            String nameMethod = msg.getQName().getLocalPart();
            if (nameRequest.equals(nameMethod)) {
                return msg;
            }
            ++i;
        }
        return null;
    }

    private void initStreams() throws Exception {
        URL inWsdl = new URL(this.mm_urlwsdl);
        this.mm_out = new PrintWriter(new FileWriter(this.mm_path + this.mm_nameService + ".java"));
        if (inWsdl == null || inWsdl.openStream() == null) {
            throw new Exception("Error : the InputStrean URL(" + inWsdl + ") is null or not content.");
        }
        this.mm_inWsdl = inWsdl.openStream();
    }

    private boolean removeMethodsOfInterface(Method[] listMethods, ObjectSchema preturn, Hashtable params, Vector keyOrdered, String nameMethod) {
        if (listMethods != null) {
            int i = 0;
            while (i < listMethods.length) {
                if (listMethods[i] != null && nameMethod.equals(listMethods[i].getName()) && XMLValueEncoder.cleanNameClass(listMethods[i].getReturnType(), (boolean)false).indexOf(preturn.getType()) >= 0) {
                    boolean match = true;
                    Class<?>[] cparams = listMethods[i].getParameterTypes();
                    int j = 0;
                    while (j < cparams.length) {
                        ObjectSchema type = null;
                        if (params.size() > j) {
                            type = (ObjectSchema)params.get(keyOrdered.get(j));
                        }
                        String np = XMLValueEncoder.cleanNameClass(cparams[j], (boolean)false);
                        if (type == null || np.indexOf(type.getType()) == -1) {
                            match = false;
                            break;
                        }
                        ++j;
                    }
                    if (match) {
                        listMethods[i] = null;
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private void writeClass(PrintWriter out) throws IOException {
        out.println();
        out.println("/**");
        out.println(" * Title: " + this.mm_nameService + ".java");
        out.println(" * Description: Virtual Portal Service of " + this.mm_nameService + " Service.");
        out.println(" * This file was generated automatically by the SAP PORTAL ECLIPSE PLUGINS,");
        out.println(" * not to modify manually.");
        out.println(" * Plugin version: " + JavaToWsdl.VERSION_ECLIPSEPLUGIN);
        out.println(" * @author SAP Portal EP6.0");
        out.println(" * @version " + new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z").format(new Date()));
        out.println(" */");
        out.println();
        out.print("public class " + this.mm_nameService);
        if (this.mm_nameInterface != null) {
            out.print(" implements " + this.mm_nameInterface);
        }
        out.println(" {");
        out.flush();
    }

    private void writeConstants(PrintWriter out) throws IOException {
        out.println();
        out.print("\tprivate static final String KEY_WEBSERVICE = ");
        out.println("\"" + this.mm_nameService + "\";");
        out.flush();
    }

    private void writeFields(PrintWriter out, Definition wsdl) throws IOException {
        String namespace = wsdl.getTargetNamespace();
        out.println();
        out.println("\tprivate String mm_nameService = " + this.mm_nameInterface + ".KEY;");
        out.println("\tprivate String mm_namespaceURI =\"" + namespace + "\";");
        out.println("\tprivate IPRTSOAPCall mm_proxy = null;");
        out.println("\tprivate IServiceContext mm_serviceContext;");
        out.println("\tprivate ISOAPService mm_soapService = null;");
        out.println("\tprivate String mm_basedUrl = null;");
        out.flush();
    }

    private void writeImport(PrintWriter out) throws IOException {
        out.println();
        out.println("import java.io.File;");
        out.println("import java.io.FileInputStream;");
        out.println("import java.util.Properties;");
        out.println("import com.sapportals.portal.prt.service.IServiceConfiguration;");
        out.println("import com.sapportals.portal.prt.service.IServiceContext;");
        out.println("import com.sapportals.portal.prt.resource.IResource;");
        out.println("import com.sapportals.portal.prt.service.soap.IPRTSOAPCall;");
        out.println("import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;");
        out.println("import com.sapportals.portal.prt.service.soap.ISOAPService;");
        out.println("import com.sapportals.portal.prt.service.soap.SOAPParameter;");
        out.println("import com.sapportals.portal.prt.service.soap.exception.PRTFault;");
        out.println("import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;");
        out.println("import com.sapportals.portal.prt.service.soap.types.AnyURI;");
        out.println("import com.sapportals.portal.prt.service.soap.types.Base64;");
        out.println("import com.sapportals.portal.prt.service.soap.types.Hex;");
        out.println("import com.sapportals.portal.prt.service.soap.types.NormalizedString;");
        out.println("import com.sapportals.portal.prt.service.soap.types.XMLData;");
        out.println("import com.sapportals.portal.prt.service.soap.types.AnyURI;");
        out.println("import com.sapportals.portal.prt.service.soap.types.QName;");
        out.println("import com.sapportals.portal.prt.service.soap.util.XMLAttributeHandler;");
        out.println("import com.sapportals.portal.prt.service.IServiceConfiguration;");
        out.println("import com.sapportals.portal.prt.service.IServiceContext;");
        out.println("import java.util.*;");
        out.println("import java.math.BigDecimal;");
        out.flush();
    }

    private void writeMethod(PrintWriter out, String nameMethod, ObjectSchema typeReturn, Hashtable params, Vector keyOrdered) {
        ObjectSchema type;
        String key;
        out.println();
        int nbParams = params.size();
        out.println("\tpublic " + typeReturn.getType() + " " + nameMethod + " ( ");
        int nbParamsByLine = 4;
        int nbCurrentParamsbyLine = 0;
        out.print("\t\t");
        Enumeration enumeration = keyOrdered.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            type = (ObjectSchema)params.get(key);
            out.print(type.getType() + " item" + i);
            if (i != nbParams - 1) {
                out.print(", ");
            }
            if (nbCurrentParamsbyLine >= nbParamsByLine) {
                out.println("\t\t");
            } else {
                ++nbCurrentParamsbyLine;
            }
            ++i;
        }
        out.println(") {");
        out.println("\t\ttry {");
        out.println("\t\t    XMLAttributeHandler params = new XMLAttributeHandler();");
        enumeration = keyOrdered.elements();
        i = 0;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            out.print("\t\t    params.addAttribute(\"" + key + "\", new SOAPParameter(null,");
            type = (ObjectSchema)params.get(key);
            if (type.isObject()) {
                out.println(type.getType() + ".class,item" + i + "));");
            } else {
                out.println(type.getType() + ".class," + ToolKit.writeWrapForPrimitive(type, "item" + i) + "));");
            }
            ++i;
        }
        out.println();
        if (typeReturn.isObject()) {
            out.println("\t\t    " + typeReturn.getType() + " result = (" + typeReturn.getType() + ")mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null);");
        } else {
            out.println(this.writeCastForPrimitive(typeReturn, nameMethod));
        }
        out.println();
        if (typeReturn.getType().indexOf("void") == -1) {
            out.println("\t\t    return result;");
        }
        out.println("\t\t} catch (Exception soapex) {");
        out.println();
        out.println("\t\t    if ( soapex instanceof PRTFault)");
        out.println("\t\t       throw (PRTFault)soapex;");
        out.println("\t\t    else");
        out.println("\t\t       throw new PRTFaultInternalError(this,soapex);");
        out.println("\t\t}");
        out.println("\t }");
        out.flush();
    }

    private String writeCastForPrimitive(ObjectSchema type, String nameMethod) {
        if (type != null && type.getType().indexOf("long") != -1) {
            return "\t\t    " + type.getType() + " result = ((Long)mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("boolean") != -1) {
            return "\t\t    " + type.getType() + " result = ((Boolean)mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("byte") != -1) {
            return "\t\t    " + type.getType() + " result = ((Byte)mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("double") != -1) {
            return "\t\t    " + type.getType() + " result = ((Double)mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("float") != -1) {
            return "\t\t    " + type.getType() + " result = ((Float)mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("int") != -1) {
            return "\t\t    " + type.getType() + " result = ((Integer)mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("short") != -1) {
            return "\t\t    " + type.getType() + " result = ((Short)mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null))." + type.getType() + "Value();";
        }
        if (type != null && type.getType().indexOf("String") != -1) {
            return "\t\t    " + type.getType() + " result = (String) mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null);";
        }
        if (type != null && type.getType().indexOf("void") != -1) {
            return "\t\t   mm_proxy.invokeMethod(\"" + nameMethod + "\", params,null);";
        }
        return "";
    }

    private void writeMethodUnsupported(PrintWriter out, String nameMethod, String name) {
        out.println();
        out.println("\t/** Unsupported method, don't use this method !!! **/");
        String signature = null;
        String ret = "\t\tthrow new UnsupportedOperationException(\"this method is not implemented\");";
        StringTokenizer ps = new StringTokenizer(nameMethod, " ");
        int token = 0;
        int nbTokens = ps.countTokens();
        while (token < nbTokens) {
            if (token == 0) {
                signature = "\t" + (String)ps.nextElement() + " ";
            }
            if (token == 1) {
                ps.nextElement();
            }
            if (token == 2) {
                signature = signature + (String)ps.nextElement() + " ";
            }
            if (token == 3) {
                signature = signature + name;
                String params = (String)ps.nextElement();
                params = params.substring(params.indexOf("(") + 1, params.length() - 1);
                StringTokenizer psp = new StringTokenizer(params, ",");
                params = "";
                int index_params = 0;
                while (psp.hasMoreElements()) {
                    params = params + (String)psp.nextElement() + " item" + index_params++ + ",";
                }
                signature = index_params == 0 ? signature + "( )" : signature + "(" + params.substring(0, params.length() - 1) + ") ";
            }
            ++token;
        }
        out.println(signature + "{\n");
        out.println(ret);
        out.println("\t}");
        out.flush();
    }

    private void writeMethods(PrintWriter out, Definition wsdl) throws IOException {
        Map listmessages = wsdl.getMessages();
        Collection values = listmessages.values();
        Object[] objs = values.toArray();
        Method[] listMethods = null;
        if (this.mm_interface_proxy != null) {
            listMethods = this.mm_interface_proxy.getDeclaredMethods();
        }
        int i = 0;
        while (i < objs.length) {
            Message msg = (Message)objs[i];
            String nameMethod = msg.getQName().getLocalPart();
            if (nameMethod.indexOf("Response") >= 0) {
                nameMethod = nameMethod.substring(0, nameMethod.indexOf("Response"));
                Part partReturn = msg.getPart("response");
                ObjectSchema ret = null;
                if (partReturn == null) {
                    Iterator iter2 = msg.getParts().keySet().iterator();
                    while (iter2.hasNext() && partReturn == null) {
                        String nameRet = (String)iter2.next();
                        partReturn = msg.getPart(nameRet);
                    }
                }
                if ((ret = partReturn == null ? new ObjectSchema("void", false, null, null) : this.getTypeJava(partReturn.getTypeName(), wsdl.getTypes())) != null) {
                    Vector<String> keyOrdered = new Vector<String>();
                    Hashtable<String, ObjectSchema> params = new Hashtable<String, ObjectSchema>();
                    int nb = 0;
                    Part partParams = null;
                    Message request = this.foundRequestMessage(objs, msg.getQName().getLocalPart());
                    boolean error = false;
                    List parts = request.getOrderedParts(null);
                    if (parts != null) {
                        Iterator iter = parts.iterator();
                        while (iter.hasNext()) {
                            partParams = (Part)iter.next();
                            ObjectSchema ptype = this.getTypeJava(partParams.getTypeName(), wsdl.getTypes());
                            if (ptype == null) {
                                error = true;
                                break;
                            }
                            params.put(partParams.getName(), ptype);
                            keyOrdered.add(partParams.getName());
                            ++nb;
                        }
                    } else {
                        error = true;
                    }
                    if (!error) {
                        this.writeMethod(out, nameMethod, ret, params, keyOrdered);
                        if (this.mm_interface_proxy != null) {
                            this.removeMethodsOfInterface(listMethods, ret, params, keyOrdered, nameMethod);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.mm_interface_proxy != null) {
            int i2 = 0;
            while (i2 < listMethods.length) {
                if (listMethods[i2] != null) {
                    this.writeMethodUnsupported(out, listMethods[i2].toString(), listMethods[i2].getName());
                }
                ++i2;
            }
        }
    }

    private void writeTemplatePRTService(PrintWriter out) throws IOException {
        out.println();
        out.println("\tpublic IServiceContext getContext() {\n\t\treturn mm_serviceContext;\n\t}");
        out.println();
        out.println("\tpublic String getKey() {\n\treturn " + this.mm_nameInterface + ".KEY;\n\t}");
        out.println();
        out.println("\tpublic void afterInit() {");
        out.println("\t\tmm_soapService = (ISOAPService)mm_serviceContext.getService(ISOAPService.KEY);");
        out.println("\t\t//read properties of Proxy\n\t\tboolean readFail = false;\n\t\ttry {");
        out.println("\t\t\tFile fileprops = new File(mm_serviceContext.getPrivateServicePath()+File.separator+ISOAPParamConstants.SOAP_NAME_DIR+File.separator+File.separator+getKey()+\"Proxy.properties\");");
        out.println("\t\t\t    if (fileprops.exists()) {");
        out.println("\t\t\t        //read the properties file");
        out.println("\t\t\t        Properties props = new Properties();");
        out.println("\t\t\t       props.load(new FileInputStream(fileprops));");
        out.println("\t\t\t       mm_basedUrl = props.getProperty(\"baseURL\");");
        out.println("\t\t\t       if (mm_basedUrl == null)");
        out.println("\t\t\t            readFail = true;");
        out.println("\t\t\t       props.clear();");
        out.println("\t\t\t    }else {");
        out.println("\t\t\t        readFail = true;");
        out.println("\t\t\t    }");
        out.println("\t\t}catch (Exception ex){");
        out.println("\t\t    ex.printStackTrace();");
        out.println("\t\t    readFail = true;");
        out.println("\t\t} finally {");
        out.println("\t\t    if (readFail) {");
        out.println("\t\t       //read the default properties of SoapService");
        out.println("\t\t        mm_basedUrl = mm_soapService.getDefaultBaseURL_PRToutside();");
        out.println("\t\t       System.out.println(\"File properties not found! start default config (\"+mm_basedUrl+\").\");");
        out.println("\t\t   }\n\t\t}");
        out.println("\t\tmm_proxy = mm_soapService.getSOAPCallInstance(mm_basedUrl, mm_nameService, mm_namespaceURI);");
        out.println("\t}");
        out.println();
        out.println("\tpublic void configure(IServiceConfiguration configuration) {\n\t}");
        out.println();
        out.println("\tpublic void destroy() {\n\t}");
        out.println();
        out.println("\tpublic void init(IServiceContext serviceContext) {\n\t\tmm_serviceContext = serviceContext;\n\t}");
        out.println();
        out.println("\tpublic void release() {\n\t}");
        out.flush();
    }
}

