/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.webserviceconfig.impl;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfigVersion;
import com.sapportals.portal.prt.service.soap.webserviceconfig.PortalSOAPConfigFactory;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.descriptionImpl.PortalWebServiceImpl;
import com.sapportals.portal.prt.service.soap.webserviceconfig.impl.PortalSOAPConfigVersionImpl;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOM2Writer;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortalSOAPConfigImpl
implements IPortalSOAPConfig {
    private Document mm_DOMSOAPConfig = null;
    private Element mm_portalwebservicesNode = null;
    private String mm_applicationName = null;
    private IPortalSOAPConfigVersion mm_version = null;
    private Vector mm_listPortalWebservices = null;

    public PortalSOAPConfigImpl(Document dom, String application_name) {
        this.mm_DOMSOAPConfig = dom;
        this.mm_applicationName = application_name;
        this.mm_listPortalWebservices = new Vector();
        this.initializeASOAPConfigDocument();
    }

    public PortalSOAPConfigImpl(Document dom) throws IllegalStateException {
        this.mm_DOMSOAPConfig = dom;
        this.mm_listPortalWebservices = new Vector();
        this.reconstructSOAPConfigDocument();
    }

    public IPortalWebService getPortalWebService(String name) {
        if (this.mm_listPortalWebservices == null) {
            return null;
        }
        Enumeration enumeration = this.mm_listPortalWebservices.elements();
        while (enumeration.hasMoreElements()) {
            IPortalWebService item = (IPortalWebService)enumeration.nextElement();
            if (item.getName() == null || !item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public Vector getPortalWebServices() {
        return this.mm_listPortalWebservices;
    }

    public IPortalWebService createPortalWebService(String name) {
        PortalWebServiceImpl pwebservice = new PortalWebServiceImpl(name);
        Enumeration enumeration = this.mm_listPortalWebservices.elements();
        while (enumeration.hasMoreElements()) {
            IPortalWebService element = (IPortalWebService)enumeration.nextElement();
            if (!element.getName().equals(name)) continue;
            this.mm_listPortalWebservices.remove(element);
            break;
        }
        this.mm_listPortalWebservices.add(pwebservice);
        return pwebservice;
    }

    public void save(OutputStream output) throws IOException {
        if (this.mm_DOMSOAPConfig == null) {
            throw new IOException("The content of this Portal Webservice SOAP Config is empty");
        }
        try {
            if (this.mm_listPortalWebservices != null) {
                Enumeration enumeration = this.mm_listPortalWebservices.elements();
                while (enumeration.hasMoreElements()) {
                    PortalWebServiceImpl item = (PortalWebServiceImpl)enumeration.nextElement();
                    item.serializeObject(this.mm_portalwebservicesNode);
                }
            }
            output.write(DOM2Writer.nodeToString((Node)this.mm_DOMSOAPConfig).getBytes());
            output.flush();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    private void initializeASOAPConfigDocument() {
        this.mm_DOMSOAPConfig.appendChild(this.mm_DOMSOAPConfig.createComment("Portal WebService Configuration File."));
        this.mm_DOMSOAPConfig.appendChild(this.mm_DOMSOAPConfig.createComment("Note: File generated automaticaly, don't modify this file."));
        this.mm_portalwebservicesNode = this.mm_DOMSOAPConfig.createElement("portal-webservices");
        this.mm_portalwebservicesNode.setAttribute("version", PortalSOAPConfigFactory.SOAP_CONFIG_VERSION.toString());
        this.mm_portalwebservicesNode.setAttribute("application-name", this.mm_applicationName);
        this.mm_DOMSOAPConfig.appendChild(this.mm_portalwebservicesNode);
    }

    private void reconstructSOAPConfigDocument() throws IllegalStateException {
        NodeList list;
        if (this.mm_DOMSOAPConfig != null && (list = this.mm_DOMSOAPConfig.getElementsByTagName("portal-webservices")).getLength() == 1) {
            this.mm_portalwebservicesNode = (Element)list.item(0);
            this.mm_applicationName = DOMUtils.getAttribute((Element)this.mm_portalwebservicesNode, (String)"application-name");
            if (this.mm_applicationName == null) {
                throw new IllegalStateException("Document not valid: " + this.mm_portalwebservicesNode.getLocalName() + " -> PORTAL_SOAP_CONFIG_APPNAME_ATTR not found.");
            }
            String version = DOMUtils.getAttribute((Element)this.mm_portalwebservicesNode, (String)"version");
            this.mm_version = new PortalSOAPConfigVersionImpl(version);
            if (!PortalSOAPConfigFactory.SOAP_CONFIG_VERSION.isCompatible(version)) {
                throw new IllegalStateException("SOAP CONFIG File: Version incompatible with the soap runtime.");
            }
            list = this.mm_portalwebservicesNode.getElementsByTagName("portal-webservice");
            int i = 0;
            while (i < list.getLength()) {
                Element webserviceNode = (Element)list.item(i);
                String name = DOMUtils.getAttribute((Element)webserviceNode, (String)"name");
                if (name == null) {
                    throw new IllegalStateException("Document not valid: " + webserviceNode.getLocalName() + " -> PORTAL_SOAP_CONFIG_NAME_ATTR not found.");
                }
                PortalWebServiceImpl webservice = new PortalWebServiceImpl(name);
                webservice.deserializeObject(webserviceNode);
                this.mm_listPortalWebservices.add(webservice);
                ++i;
            }
        }
        try {
            this.mm_DOMSOAPConfig = new DocumentBuilderFactoryImpl().newDocumentBuilder().newDocument();
            this.initializeASOAPConfigDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Cannot create a DOM empty");
        }
    }

    public IPortalSOAPConfigVersion getVersion() {
        return this.mm_version;
    }
}

