/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.util;

import com.sapportals.config.event.ConfigEvent;
import com.sapportals.config.event.IConfigEventListener;
import com.sapportals.config.event.IConfigEventService;
import com.sapportals.config.fwk.Configuration;
import com.sapportals.config.fwk.IConfigClientContext;
import com.sapportals.config.fwk.IConfigManager;
import com.sapportals.config.fwk.IConfigPlugin;
import com.sapportals.config.fwk.IConfigurable;
import com.sapportals.config.fwk.IConfigurationAccess;
import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.soap.util.IConfigurationSOAPService;

public class ConfigSOAPService
implements IConfigurationSOAPService,
IConfigEventListener {
    private static final String LISTENER_ID = "com.sapportals.portal.prt.service.soap.util.ConfigSOAPService";
    public static final String ROOT_PLUGIN = "/portal/com.sapportals.portal.prt.service.soap";
    public static final String ROOT_PLUGIN_CONFIG = "/portal/com.sapportals.portal.prt.service.soap/config";
    private static final String CO_SERVICE = "service_config";
    private static ConfigSOAPService mm_config = null;
    private IConfigurable mm_configurable = null;

    private ConfigSOAPService() {
        this.removeListener();
        this.addListener();
        this.updateConf();
    }

    public static ConfigSOAPService getInstance() {
        if (mm_config == null) {
            mm_config = new ConfigSOAPService();
        }
        return mm_config;
    }

    public static void destroy() {
        mm_config = null;
    }

    public boolean readPropertieBoolean(String propertie) throws Exception {
        if (this.mm_configurable == null) {
            return false;
        }
        return Boolean.valueOf(this.mm_configurable.getPropertyValue(propertie));
    }

    public String readPropertie(String propertie) throws Exception {
        if (this.mm_configurable == null) {
            return null;
        }
        return this.mm_configurable.getPropertyValue(propertie);
    }

    public String getConfigListenerId() {
        return LISTENER_ID;
    }

    public void configEvent(ConfigEvent event) {
        if (event.getType() == ConfigEvent.CONFIGURABLE_UPDATED) {
            this.updateConf();
        }
    }

    private void updateConf() {
        try {
            IConfigurationAccess configurationService = Configuration.getInstance();
            IConfigManager configManager = configurationService.getConfigManager(IConfigClientContext.createContext());
            IConfigPlugin plugin = configManager.getConfigPlugin(ROOT_PLUGIN_CONFIG);
            this.mm_configurable = plugin.getConfigurable(CO_SERVICE);
            if (this.mm_configurable == null) {
                throw new NullPointerException("unable to get configurable");
            }
        }
        catch (Exception e) {
            this.error(e, "unable to update configuration");
        }
    }

    private void addListener() {
        String[] domains = new String[]{ROOT_PLUGIN};
        try {
            IConfigurationAccess configurationService = Configuration.getInstance();
            IConfigEventService eventService = configurationService.getConfigEventServiceInstance();
            eventService.addConfigEventListener((IConfigEventListener)this, domains);
        }
        catch (Exception e) {
            this.error(e, "unable to add listener.");
        }
    }

    private void removeListener() {
        try {
            IConfigurationAccess configurationService = Configuration.getInstance();
            IConfigEventService eventService = configurationService.getConfigEventServiceInstance();
            eventService.removeConfigEventListener((IConfigEventListener)this);
        }
        catch (Exception e) {
            this.error(e, "unable to remove listener:");
        }
    }

    private void error(Exception e, String message) {
        ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
        if (logger != null && logger.isActive()) {
            logger.info((Object)this, (Throwable)e, "SOAP Service Configuration problem: " + message);
        }
    }
}

