/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.security;

import com.sapportals.portal.prt.core.service.ServiceManager;
import com.sapportals.portal.prt.service.IServiceContext;
import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPService;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSecurity;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.security.ISOAPSecurityManager;
import com.sapportals.portal.prt.service.soap.security.PRTSOAPSecuredMessage;
import com.sapportals.portal.prt.service.soap.types.Base64;
import com.sapportals.portal.prt.service.soap.util.IConfigurationSOAPService;
import com.sapportals.portal.prt.session.IUserContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;

public class SOAPSecurityManager
implements ISOAPSecurityManager {
    private Base64 mm_certificate = null;
    private Base64 mm_digestValue = null;
    private Base64 mm_signature = null;
    private String mm_digestMethodAlgorithmNamespace = null;
    private IServiceContext mm_serviceContext = null;
    private ISOAPService mm_soapserviceRef = null;
    private IConfigurationSOAPService mm_config = null;

    public SOAPSecurityManager(ISOAPService soapservice) throws SOAPServiceException {
        try {
            this.mm_soapserviceRef = soapservice;
            this.mm_serviceContext = this.mm_soapserviceRef.getContext();
            this.init();
        }
        catch (SOAPServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PRTFaultSecurity((Object)this, e);
        }
    }

    private void init() throws Exception {
        this.mm_certificate = new Base64("Certificate".getBytes());
        this.mm_digestValue = new Base64("digestValue".getBytes());
        this.mm_signature = new Base64("Signature".getBytes());
        this.mm_digestMethodAlgorithmNamespace = "http://www.sapportals.com/SAP/WebServices#Security";
        this.mm_config = this.mm_soapserviceRef.getConfigurationSOAPService();
    }

    public Base64 getCertificate() {
        return this.mm_certificate;
    }

    public Base64 getDigestValue() {
        return this.mm_digestValue;
    }

    public Base64 getSignature() {
        return this.mm_signature;
    }

    public String getDigestMethodAlgorithmNamespace() {
        return this.mm_digestMethodAlgorithmNamespace;
    }

    public boolean getEncryptDataEnable() {
        try {
            return this.mm_config.readPropertieBoolean("security.encryptData");
        }
        catch (Exception ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "GetEncryptDataEnable Method failed", ex);
            }
            return false;
        }
    }

    public boolean getSignatureEnable() {
        try {
            return this.mm_config.readPropertieBoolean("security.signature");
        }
        catch (Exception ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "GetSignatureEnable Method failed", ex);
            }
            return false;
        }
    }

    public boolean getAuthorizationEnable() {
        try {
            return this.mm_config.readPropertieBoolean("security.authorization");
        }
        catch (Exception ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "GetAuthorizationEnable Method failed", ex);
            }
            return false;
        }
    }

    public String getActor() {
        try {
            return this.mm_config.readPropertie("security.actor");
        }
        catch (Exception ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "GetActor Method failed", ex);
            }
            return null;
        }
    }

    public String getMustUnderstand() {
        return this.getSecurityEnable() ? "1" : "0";
    }

    public void securedResponse(HttpServletResponse response) throws SOAPServiceException {
        if (this.getSecurityEnable()) {
            // empty if block
        }
    }

    public boolean isAuthorizedRequest(HttpServletRequest request) throws SOAPServiceException {
        if (this.getSecurityEnable()) {
            return true;
        }
        return true;
    }

    public SOAPMessage createSecuredSOAPMessage(SOAPMessage msg, ISOAPMessageContext context) throws SOAPServiceException {
        if (this.getSecurityEnable()) {
            return new PRTSOAPSecuredMessage(msg, this, context).getPRTSOAPSecurisedMessage();
        }
        return msg;
    }

    public SOAPMessage getSOAPMessageWithoutSecurity(SOAPMessage msg) throws SOAPServiceException {
        return new PRTSOAPSecuredMessage().unmarshall(msg, this);
    }

    public boolean verifySign(Base64 sign) throws SOAPServiceException {
        return true;
    }

    public boolean verifyCert(Base64 cert) throws SOAPServiceException {
        return true;
    }

    public boolean getSecurityEnable() {
        try {
            return this.mm_config.readPropertieBoolean("security");
        }
        catch (Exception ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "GetSecurityEnable Method failed", ex);
            }
            return false;
        }
    }

    public boolean isAuthorizedUserForService(IUserContext userCtxt, String servicename) throws SOAPServiceException {
        try {
            ServiceManager.getInstance().get(servicename, (Object)userCtxt);
            return true;
        }
        catch (Exception ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "User is not authorized to access to the Portal Service " + servicename, ex);
            }
            throw new SOAPServiceException((Throwable)ex);
        }
    }
}

