/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.security;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.security.IPRTSOAPSignedInfo;
import com.sapportals.portal.prt.service.soap.security.PRTSOAPSecurityElement;
import com.sapportals.portal.prt.service.soap.types.Base64;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class PRTSOAPSignedInfo
extends PRTSOAPSecurityElement
implements IPRTSOAPSignedInfo {
    private Base64 mm_digestValue = null;
    private String mm_digestMethodAlgorithmNamespace = null;

    public PRTSOAPSignedInfo(SOAPElement signedInfo) {
        Iterator iter1 = signedInfo.getChildElements();
        while (iter1.hasNext()) {
            SOAPElement child = (SOAPElement)iter1.next();
            if (!child.getElementName().getLocalName().equals("Reference")) continue;
            Iterator iter2 = child.getChildElements();
            while (iter2.hasNext()) {
                SOAPElement item = (SOAPElement)iter2.next();
                if (item.getElementName().getLocalName().equals("DigestMethod")) {
                    this.mm_digestMethodAlgorithmNamespace = item.getValue();
                }
                if (!item.getElementName().getLocalName().equals("DigestValue")) continue;
                String digValue = new String(new Base64(item.getValue().getBytes()).decode());
                this.mm_digestValue = new Base64(digValue.getBytes());
            }
        }
    }

    public PRTSOAPSignedInfo(String actor, String mustUnderstand, Base64 digestValue, String digestMethodAlgorithmNamespace) {
        super(actor, mustUnderstand);
        this.mm_digestValue = digestValue;
        this.mm_digestMethodAlgorithmNamespace = digestMethodAlgorithmNamespace;
    }

    public void marshall(SOAPElement signatureElement, SOAPEnvelope envelope, ISOAPMessageContext context) {
        block2: {
            try {
                SOAPElement signedInfo = signatureElement.addChildElement("SignedInfo", "ds", "http://www.w3.org/2000/02/xmldsig#");
                signedInfo.addChildElement("CanonicalizationMethod", "ds", "http://www.w3.org/2000/02/xmldsig#");
                SOAPElement signatureMethod = signedInfo.addChildElement("SignatureMethod", "ds", "http://www.w3.org/2000/02/xmldsig#");
                signatureMethod.addAttribute(envelope.createName("Algorithm"), this.mm_digestMethodAlgorithmNamespace);
                SOAPElement reference = signedInfo.addChildElement("Reference", "ds", "http://www.w3.org/2000/02/xmldsig#");
                reference.addAttribute(envelope.createName("URI"), "#Body");
                reference.addChildElement("Transforms", "ds", "http://www.w3.org/2000/02/xmldsig#");
                SOAPElement digestMethod = reference.addChildElement("DigestMethod", "ds", "http://www.w3.org/2000/02/xmldsig#");
                digestMethod.addAttribute(envelope.createName("Algorithm"), this.mm_digestMethodAlgorithmNamespace);
                SOAPElement digestValue = reference.addChildElement("DigestValue", "ds", "http://www.w3.org/2000/02/xmldsig#");
                digestValue.addTextNode(new String(this.mm_digestValue.encode()));
            }
            catch (SOAPException soapex) {
                SOAPLogger logger = SOAPLogger.getInstance();
                if (logger == null) break block2;
                logger.writeInfo(this, "marshall Method failed", (Exception)((Object)soapex));
            }
        }
    }

    public Base64 getDigestValue() {
        return this.mm_digestValue;
    }

    public void setDigestValue(Base64 p_mm_digestValue) {
        this.mm_digestValue = p_mm_digestValue;
    }

    public String getDigestMethodAlgorithmNamespace() {
        return this.mm_digestMethodAlgorithmNamespace;
    }

    public void setDigestMethodAlgorithmNamespace(String p_mm_digestMethodAlgorithmNamespace) {
        this.mm_digestMethodAlgorithmNamespace = p_mm_digestMethodAlgorithmNamespace;
    }
}

