/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.processor;

import com.sapportals.portal.prt.dispatcher.IDispatcherContext;
import com.sapportals.portal.prt.service.IService;
import com.sapportals.portal.prt.service.IServiceContext;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBody;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPEnvelope;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPResponse;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPBodyElement;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPResponse;
import com.sapportals.portal.prt.service.soap.exception.PRTFault;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultDataEnconding;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSecurity;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.processor.IMethodsAuthorizedProcessor;
import com.sapportals.portal.prt.service.soap.processor.ISOAPServiceProcessor;
import com.sapportals.portal.prt.service.soap.processor.MethodContainer;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLAttributeHandler;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceParameter;
import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import com.sapportals.portal.prt.util.SmartBuffer;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.soap.SOAPException;

public class InvokerProcessor {
    private static InvokerProcessor mm_instance = null;
    static /* synthetic */ Class class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor;
    static /* synthetic */ Class class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor;

    public static InvokerProcessor getInstance() {
        if (mm_instance == null) {
            mm_instance = new InvokerProcessor();
        }
        return mm_instance;
    }

    public IPRTSOAPResponse invokePortalSOAPProcessor(String serviceName, IPRTSOAPMessage message, IServiceContext serviceContext, IMethodsAuthorizedProcessor methodsAuthorized, IDispatcherContext disCxt, ISOAPServiceProcessor processor) throws SOAPServiceException {
        MethodContainer container = null;
        try {
            IPRTSOAPBody body = message.getEnveloppe().getBody();
            IService theService = serviceContext.getService(serviceName);
            PRTSOAPResponse soapResponse = new PRTSOAPResponse((PRTSOAPMessage)message);
            soapResponse.setServiceInstance(theService);
            Enumeration enumeration = body.getListOfBodyElements().keys();
            Hashtable listBodyElements = body.getListOfBodyElements();
            String methodName = null;
            PRTSOAPBodyElement bodyElement = null;
            XMLAttributeHandler handler = null;
            if (!message.getEnveloppe().getMainContext().isDocumentStyleEncoding()) {
                while (enumeration.hasMoreElements()) {
                    methodName = (String)enumeration.nextElement();
                    bodyElement = (PRTSOAPBodyElement)listBodyElements.get(methodName);
                    handler = bodyElement.getAttributeHandler();
                    container = this.extractMethodFromXML(serviceName, theService, methodName, handler);
                }
            } else {
                if (!listBodyElements.isEmpty()) {
                    String key = (String)enumeration.nextElement();
                    bodyElement = (PRTSOAPBodyElement)listBodyElements.get(key);
                    handler = bodyElement.getAttributeHandler();
                } else {
                    bodyElement = (PRTSOAPBodyElement)body.generateEmptyPRTSOAPBodyElementEntry();
                }
                container = this.extractMethodFromXML(serviceName, theService, methodName, handler, message.getEnveloppe());
                methodName = container.getWebserviceMethod_config().getName();
            }
            this.generateCallOnPortalService(disCxt, message, methodsAuthorized, processor, container, handler, theService, methodName, bodyElement);
            return soapResponse;
        }
        catch (PRTFault ex) {
            SOAPLogger.getInstance().writeInfo(class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPAbstractProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor, this.dumpError("invokePortalSOAPProcessor", serviceName, message, processor, container, ex.toString()));
            throw ex;
        }
        catch (Throwable e) {
            SOAPLogger.getInstance().writeInfo(class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPAbstractProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor, this.dumpError("invokePortalSOAPProcessor", serviceName, message, processor, container, e.toString()));
            throw new PRTFaultInternalError((Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPAbstractProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor).getName(), e);
        }
    }

    private void generateCallOnPortalService(IDispatcherContext disCxt, IPRTSOAPMessage message, IMethodsAuthorizedProcessor methodsAuthorized, ISOAPServiceProcessor processor, MethodContainer container, XMLAttributeHandler handler, IService theService, String methodName, PRTSOAPBodyElement bodyElement) throws Exception {
        Class[] portalServiceParamsClass = null;
        Object[] portalServiceParams = null;
        Method method = null;
        if (container == null) {
            portalServiceParamsClass = this.getPortalServiceParamsClass(handler);
            portalServiceParams = this.getPortalServiceParams(handler);
            method = theService.getClass().getMethod(methodName, portalServiceParamsClass);
            container = new MethodContainer();
            container.setClassParam(portalServiceParamsClass);
            container.setParams(portalServiceParams);
            container.setMethod(method);
        }
        if (container.getMethod() == null) {
            throw new SOAPServiceException("Method not found");
        }
        message.getEnveloppe().getMainContext().setMethodContainer(container);
        boolean isOk = methodsAuthorized.isMethodAuthorized(container.getMethod().toString(), theService, methodName, container.getClassParam());
        if (!isOk) {
            throw new PRTFaultSecurity("Call to Method " + container.getMethod().toString() + " is not authorized by the service provider", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPAbstractProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPAbstractProcessor).getName(), new Exception("Method access denied : Call to Method " + container.getMethod().toString() + " is not authorized by the service provider"));
        }
        Object response = processor.invokeWebServiceMethod(disCxt, theService, container.getMethod(), container.getClassParam(), container.getParams());
        Class<?> typeResponse = container.getMethod().getReturnType();
        bodyElement.setResponse(response, typeResponse);
    }

    private Class[] getPortalServiceParamsClass(XMLAttributeHandler handler) {
        if (handler == null) {
            return null;
        }
        int size = handler.getSize();
        Class[] classArray = new Class[size];
        Enumeration nameparams = handler.getKeyOrdered().elements();
        int i = 0;
        while (nameparams.hasMoreElements()) {
            Object item = nameparams.nextElement();
            SOAPParameter param = handler.getAttributeValue((String)item);
            classArray[i] = param.getType();
            ++i;
        }
        return classArray;
    }

    private Object[] getPortalServiceParams(XMLAttributeHandler handler) {
        if (handler == null) {
            return null;
        }
        int size = handler.getSize();
        Object[] params = new Object[size];
        Enumeration nameparams = handler.getKeyOrdered().elements();
        int i = 0;
        while (nameparams.hasMoreElements()) {
            Object item = nameparams.nextElement();
            SOAPParameter param = handler.getAttributeValue((String)item);
            params[i] = param.getValue();
            ++i;
        }
        return params;
    }

    public MethodContainer extractMethodFromXML(String serviceName, IService theService, String methodName, XMLAttributeHandler handler) {
        return this.extractMethodFromXML(serviceName, theService, methodName, handler, null);
    }

    private String dumpError(String methodProcess, String serviceName, IPRTSOAPMessage message, ISOAPServiceProcessor processor, MethodContainer container, String cause) {
        RecyclableStringBuffer buffer = new RecyclableStringBuffer(128);
        SmartBuffer out = buffer.getBuffer();
        out.append("\r\n|SOAP Message Processing Error_____________________________________#START");
        out.append("|\r\n");
        out.append("|An error has been encountered during the invoke on the WebService Processor in the method\r\n");
        out.append("|\r\n");
        out.append("|> " + methodProcess);
        out.append("\r\n|\r\n");
        out.append("|Name of Portal Service invoked: ");
        out.append((serviceName != null ? serviceName : "") + "\r\n");
        out.append("|\r\n");
        if (container == null || container.getWebserviceMethod_config() == null) {
            out.append("|Method Container from the SOAPConfig.xml: null\r\n");
        } else {
            out.append("|Method Container from the SOAPConfig.xml: " + container.getWebserviceMethod_config().getName());
            out.append("\r\n    |>  Number of Parameters: " + container.getWebserviceMethod_config().getNumberOfParameters());
            out.append("\r\n    |>  Java signature: " + container.getWebserviceMethod_config().getJavaSignature());
            out.append("\r\n    |>  SOAP Action: " + container.getWebserviceMethod_config().getSOAPAction());
            out.append("\r\n    |>  Style: " + container.getWebserviceMethod_config().getStyleEnconding());
        }
        out.append("|\r\n");
        out.append("|#CAUSE# " + (cause != null ? cause : ""));
        out.append("\r\n|\r\n");
        out.append("|Name of WebService Processor invoked");
        out.append(processor != null ? processor.getName() : "");
        out.append("\r\n|\r\n");
        try {
            out.append("|SOAP Message received :\r\n");
            out.append(message != null ? message.getSoapMessage().getSOAPPart().getEnvelope().toString() : null);
        }
        catch (SOAPException e) {
            out.append("|SOAP Message received : N.C\r\n");
        }
        out.append("\r\n");
        out.append("_____________________________________________________________________#END");
        return buffer.toString();
    }

    private MethodContainer extractMethodFromXML(String serviceName, IService theService, String methodName, XMLAttributeHandler handler, IPRTSOAPEnvelope envelope) {
        IPortalSOAPConfig config = SOAPRegistry.getInstance().getSpecializedRegistry(serviceName).getSOAPConfig();
        if (config == null) {
            return null;
        }
        IPortalWebService service = config.getPortalWebService(serviceName);
        int sizeCaller = handler != null ? handler.getSize() : 0;
        if (envelope != null && envelope.getMainContext() != null && envelope.getMainContext().isDocumentStyleEncoding()) {
            IPortalWebServiceMethod method;
            String soapaction = envelope.getMainContext().getSOAPAction();
            if (soapaction == null) {
                throw new PRTFaultDataEnconding((Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new IllegalArgumentException("No SOAP Action include in the soap request."));
            }
            Vector listMethod = service.getPortalWebServiceMethodBySOAPAction(soapaction);
            if (listMethod == null || listMethod.size() == 0) {
                throw new PRTFaultDataEnconding((Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new IllegalArgumentException("The SOAP Action " + soapaction + " include in the soap request not corresponding to the Portal service method."));
            }
            if (listMethod.size() == 1) {
                method = (IPortalWebServiceMethod)listMethod.get(0);
            } else {
                String parameter = handler == null || handler.getKeyOrdered() == null || handler.getKeyOrdered().size() == 0 ? null : (String)handler.getKeyOrdered().get(0);
                method = ToolKit.findDocumentMethodByParameters(listMethod, parameter);
                if (method == null) {
                    if (parameter == null) {
                        parameter = "no";
                    }
                    throw new PRTFaultSerializator("Ambiguous method signature. Didn't succeed in find method with " + parameter + " parameter", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new IllegalArgumentException());
                }
            }
            if (sizeCaller > method.getNumberOfParameters()) {
                throw new PRTFaultSerializator("Ambiguous method signature, two much parameters", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new IllegalArgumentException());
            }
            return this.initializeMethodContainer(method, handler, method.getName(), theService);
        }
        Method method = null;
        MethodContainer container = new MethodContainer();
        Class[] portalServiceParamsClass = this.getPortalServiceParamsClass(handler);
        container.setClassParam(portalServiceParamsClass);
        Vector listMethod = service.getPortalWebServiceMethod(methodName);
        if (listMethod == null) {
            throw new PRTFaultSerializator("Method with name " + methodName + " is not defined in wsdl file", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new NoSuchMethodException());
        }
        try {
            method = theService.getClass().getMethod(methodName, portalServiceParamsClass);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            Enumeration enumeration = listMethod.elements();
            while (enumeration.hasMoreElements()) {
                IPortalWebServiceMethod element = (IPortalWebServiceMethod)enumeration.nextElement();
                if (element.getNumberOfParameters() == 0 && sizeCaller == 0) {
                    container.setMethod(method);
                    container.setWebserviceMethod_config(element);
                    container.setParams(this.getPortalServiceParams(handler));
                    return container;
                }
                if (element.getNumberOfParameters() != sizeCaller) continue;
                Enumeration listParam = element.getPortalWebServiceParameters();
                boolean isValidParam = true;
                while (listParam.hasMoreElements()) {
                    IPortalWebServiceParameter param = (IPortalWebServiceParameter)listParam.nextElement();
                    String paramName = param.getName();
                    if (handler != null && handler.getAttribute(paramName) != null) {
                        isValidParam = true;
                        continue;
                    }
                    isValidParam = false;
                    break;
                }
                if (!isValidParam) {
                    if (enumeration.hasMoreElements()) continue;
                    throw new PRTFaultSerializator("Wrong parameter name, not compliant with wsdl definition", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new IllegalArgumentException());
                }
                container.setMethod(method);
                container.setWebserviceMethod_config(element);
                container.setParams(this.getPortalServiceParams(handler));
                return container;
            }
        } else {
            Enumeration enumeration = listMethod.elements();
            IPortalWebServiceMethod validatedMethod = null;
            block4: while (enumeration.hasMoreElements()) {
                IPortalWebServiceMethod themethod = (IPortalWebServiceMethod)enumeration.nextElement();
                if (handler == null) continue;
                Enumeration enumParam = handler.getAttributesName();
                while (enumParam.hasMoreElements()) {
                    SOAPParameter param;
                    Class classParam;
                    String element = (String)enumParam.nextElement();
                    if (!themethod.isPresent(element, classParam = (param = handler.getAttributeValue(element)).getType())) continue;
                    validatedMethod = themethod;
                    continue block4;
                }
            }
            if (validatedMethod == null) {
                if (listMethod.size() > 1) {
                    throw new PRTFaultSerializator("Ambiguous method signature, can not determine method to call", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new NoSuchMethodException());
                }
                validatedMethod = (IPortalWebServiceMethod)listMethod.get(0);
            }
            if (validatedMethod != null) {
                if (sizeCaller > validatedMethod.getNumberOfParameters()) {
                    throw new PRTFaultSerializator("Ambiguous method signature, two much parameters", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new IllegalArgumentException());
                }
                return this.initializeMethodContainer(validatedMethod, handler, methodName, theService);
            }
        }
        return null;
    }

    private MethodContainer initializeMethodContainer(IPortalWebServiceMethod validatedMethod, XMLAttributeHandler handler, String methodName, IService theService) {
        ClassLoader loader = theService.getClass().getClassLoader();
        MethodContainer guessContainer = new MethodContainer();
        int nbParameters = validatedMethod.getNumberOfParameters();
        Class[] classArray = new Class[nbParameters];
        Object[] objectArray = new Object[nbParameters];
        int i = 0;
        while (i < nbParameters) {
            IPortalWebServiceParameter param = validatedMethod.getPortalWebServiceParameter(i);
            String paramS = param.getDefaultJavaType();
            String paramName = param.getName();
            SOAPParameter soapParam = null;
            if (handler != null) {
                soapParam = handler.getAttributeValue(paramName);
            }
            if (soapParam == null && param.getNameElement() != null) {
                soapParam = handler.getAttributeValue(param.getNameElement());
            }
            if (soapParam == null) {
                if (!param.isNillable()) {
                    throw new PRTFaultSerializator("Parameters " + paramName + " of method " + methodName + " is null, this value is not authorized by the WSDL Definition", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new IllegalArgumentException());
                }
                objectArray[i] = null;
            } else {
                objectArray[i] = soapParam.getValue();
            }
            try {
                Class<Object> classDef = null;
                classDef = ToolKit.isSimpleType(paramS) ? ToolKit.returnClassSimpleType(paramS) : (paramS.indexOf("[") != -1 ? soapParam.getType() : Class.forName(paramS, true, loader));
                classArray[i] = classDef;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        guessContainer.setClassParam(classArray);
        guessContainer.setParams(objectArray);
        try {
            Method theMethod = theService.getClass().getMethod(methodName, classArray);
            if (theMethod != null) {
                guessContainer.setMethod(theMethod);
                guessContainer.setWebserviceMethod_config(validatedMethod);
                return guessContainer;
            }
        }
        catch (NoSuchMethodException e) {
            throw new PRTFaultSerializator("The method " + methodName + " not found on the Portal Service" + theService.getClass() + ".", (Object)(class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor == null ? (class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor = InvokerProcessor.class$("com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor")) : class$com$sapportals$portal$prt$service$soap$processor$SOAPPortalServiceProcessor), (Exception)new IllegalArgumentException("The method " + methodName + " not found on the Portal Service" + theService.getClass() + "."));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

