/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.mapping;

import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.FactoryFinder;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.QNameFinder;
import com.sapportals.portal.prt.service.soap.util.QNameURI;
import com.sapportals.portal.prt.service.soap.util.QNameURIFinder;
import com.sapportals.portal.prt.service.soap.util.SerializerFinder;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.PortalSOAPConfigFactory;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceSerializer;
import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import com.sapportals.portal.prt.util.StringBufferPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.soap.SOAPException;

public class SpecializedRegistry
implements ISpecializedRegistry {
    private static final String KEY_DELIMITER = "class ";
    private static final String KEY_DELIMITERI = "interface ";
    private Hashtable mm_listSerializer = new Hashtable();
    private Hashtable mm_listDeserializer = new Hashtable();
    private Hashtable mm_listXml2Java = new Hashtable();
    private Hashtable mm_listJava2Xml = new Hashtable();
    private Hashtable mm_listJava2Namespace = new Hashtable();
    private FactoryFinder mm_factoryFinder = null;
    private ClassLoader mm_registryClassloader = null;
    private IPortalSOAPConfig mm_soapConfig = null;
    private final String SLASH = File.separator;
    private RecyclableStringBuffer mm_bufferGenerateKey = new RecyclableStringBuffer();

    public Class loadClassInRegistry(String classname) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classname, true, this.mm_registryClassloader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public SOAPDeserializer getDeserializer(QName qname, String encodingStyleURI) {
        SOAPDeserializer des = null;
        String key = this.generateKeyForElementType(encodingStyleURI, qname);
        des = (SOAPDeserializer)this.mm_listDeserializer.get(key);
        if (des != null) {
            return des;
        }
        if (encodingStyleURI == null) {
            key = this.generateKeyForElementType("http://schemas.xmlsoap.org/soap/encoding/", qname);
            des = (SOAPDeserializer)this.mm_listDeserializer.get(key);
            if (des != null) {
                return des;
            }
            key = this.generateKeyForElementType("http://www.w3.org/2001/XMLSchema", qname);
            des = (SOAPDeserializer)this.mm_listDeserializer.get(key);
            if (des != null) {
                return des;
            }
        }
        if ((des = SOAPRegistry.getInstance().getDeserializer(qname, encodingStyleURI)) == null && encodingStyleURI == null) {
            des = SOAPRegistry.getInstance().getDeserializer(qname, "http://schemas.xmlsoap.org/soap/encoding/");
        }
        return des;
    }

    public SOAPSerializer getSerializer(Class type, String encodingStyleURI) {
        if (type.isArray()) {
            return SOAPRegistry.getInstance().getSerializer(type, "http://schemas.xmlsoap.org/soap/encoding/");
        }
        SOAPSerializer ser = null;
        String key = this.generateKeyForJavaClass(encodingStyleURI, type);
        ser = (SOAPSerializer)this.mm_listSerializer.get(key);
        if (ser != null) {
            return ser;
        }
        if (encodingStyleURI == null) {
            key = this.generateKeyForJavaClass("http://schemas.xmlsoap.org/soap/encoding/", type);
            ser = (SOAPSerializer)this.mm_listSerializer.get(key);
            if (ser != null) {
                return ser;
            }
            key = this.generateKeyForJavaClass("http://www.w3.org/2001/XMLSchema", type);
            ser = (SOAPSerializer)this.mm_listSerializer.get(key);
            if (ser != null) {
                return ser;
            }
        }
        if (ser == null && (ser = SerializerFinder.foundSerializerForObject(this, encodingStyleURI, type)) != null) {
            return ser;
        }
        String key_forced = this.foundElementTypeOnlyThisRegistry(type);
        if (key_forced != null && (ser = (SOAPSerializer)this.mm_listSerializer.get(key_forced)) != null) {
            return ser;
        }
        ser = SOAPRegistry.getInstance().getSerializer(type, encodingStyleURI);
        if (ser == null && encodingStyleURI == null) {
            ser = SOAPRegistry.getInstance().getSerializer(type, "http://schemas.xmlsoap.org/soap/encoding/");
        }
        return ser;
    }

    public SOAPSerializer getSerializerWihoutInheritance(Class type, String encodingStyleURI) {
        SOAPSerializer ser = null;
        String key = this.generateKeyForJavaClass(encodingStyleURI, type);
        ser = (SOAPSerializer)this.mm_listSerializer.get(key);
        if (ser != null) {
            return ser;
        }
        String key_forced = this.foundElementTypeOnlyThisRegistry(type);
        if (key_forced != null) {
            ser = (SOAPSerializer)this.mm_listSerializer.get(key_forced);
            return ser;
        }
        ser = SOAPRegistry.getInstance().getSerializer(type, encodingStyleURI);
        return ser;
    }

    public QName getElementType(Class type, String encodingStyleURI) {
        QNameURI quri;
        QName qname = null;
        String key = this.generateKeyForElementType(encodingStyleURI, type);
        qname = (QName)this.mm_listJava2Xml.get(key);
        if (qname != null) {
            return qname;
        }
        if (this.mm_soapConfig != null) {
            if (this.mm_soapConfig.getVersion().getMajorVersion() == 1 && (qname = SOAPRegistry.getInstance().getElementType(type, "http://www.w3.org/2001/XMLSchema")) != null) {
                return qname;
            }
            if (qname == null) {
                key = null;
                Enumeration enumeration = this.mm_listJava2Xml.keys();
                while (enumeration.hasMoreElements()) {
                    String keyToFind = (String)enumeration.nextElement();
                    String keyExtract = keyToFind.substring(keyToFind.lastIndexOf(KEY_DELIMITER) + KEY_DELIMITER.length(), keyToFind.length());
                    if (keyExtract.equals(type.getName())) {
                        key = keyToFind;
                        break;
                    }
                    String keyExtractI = keyToFind.substring(keyToFind.lastIndexOf(KEY_DELIMITERI) + KEY_DELIMITERI.length(), keyToFind.length());
                    if (!keyExtractI.equals(type.getName())) continue;
                    key = keyToFind;
                    break;
                }
                if (key != null) {
                    qname = (QName)this.mm_listJava2Xml.get(key);
                }
            }
            if (qname != null) {
                return qname;
            }
        }
        if ((qname = SOAPRegistry.getInstance().getElementType(type, encodingStyleURI)) == null) {
            qname = QNameFinder.foundQNameForObject(this, encodingStyleURI, type);
        }
        if (qname == null && (quri = this.getElementType(type)) != null) {
            qname = quri.getQName();
        }
        return qname;
    }

    public String foundElementTypeOnlyThisRegistry(Class type) {
        if (type != null && type.isArray()) {
            return this.generateKeyForJavaClass(SOAPRegistry.getInstance().getArrayQName().getNamespaceURI(), SOAPRegistry.getInstance().getArrayQName().getLocalPart());
        }
        String ns = (String)this.mm_listJava2Namespace.get(type.getName());
        if (ns != null) {
            return this.generateKeyForJavaClass(ns, type);
        }
        return null;
    }

    public String getDefaultNamespace(Class type) {
        if (type != null && type.isArray()) {
            return SOAPRegistry.getInstance().getArrayQName().getNamespaceURI();
        }
        String ns = (String)this.mm_listJava2Namespace.get(type.getName());
        if (ns != null) {
            return ns;
        }
        return SOAPRegistry.getInstance().getDefaultNamespace(type);
    }

    public QNameURI getElementType(Class type) {
        if (type != null && type.isArray()) {
            return new QNameURI(SOAPRegistry.getInstance().getArrayQName(), "SOAP-ENC");
        }
        String key = null;
        QName qname = null;
        String tns = this.getDefaultNamespace(type);
        if (tns != null && (qname = (QName)this.mm_listJava2Xml.get(key = this.generateKeyForJavaClass(tns, type))) != null) {
            return new QNameURI(qname, tns);
        }
        QNameURI qnameuri = SOAPRegistry.getInstance().getElementType(type);
        if (qnameuri == null) {
            qnameuri = QNameURIFinder.foundQNameForObject(this, type);
        }
        return qnameuri;
    }

    public QName getElementTypeWithouInheritance(Class type, String encodingStyleURI) {
        QName qname = null;
        String key = this.generateKeyForJavaClass(encodingStyleURI, type);
        qname = (QName)this.mm_listJava2Xml.get(key);
        if (qname != null) {
            return qname;
        }
        qname = SOAPRegistry.getInstance().getElementType(type, encodingStyleURI);
        return qname;
    }

    public QNameURI getElementTypeWithouInheritance(Class type) {
        if (type != null && type.isArray()) {
            return new QNameURI(SOAPRegistry.getInstance().getArrayQName(), "SOAP-ENC");
        }
        String key = null;
        QName qname = null;
        int i = 0;
        while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length) {
            key = this.generateKeyForJavaClass(ISOAPParamConstants.NS_URIS_SCHEMAS[i], type);
            qname = (QName)this.mm_listJava2Xml.get(key);
            if (qname != null && !qname.getNamespaceURI().equals("http://www.w3.org/1999/XMLSchema") && !qname.getNamespaceURI().equals("http://www.w3.org/2000/10/XMLSchema")) {
                return new QNameURI(qname, ISOAPParamConstants.NS_URIS_SCHEMAS[i]);
            }
            ++i;
        }
        QNameURI qnameuri = SOAPRegistry.getInstance().getElementType(type);
        return qnameuri;
    }

    public Class getJavaType(QName qname, String encodingStyleURI) {
        Class javaType = null;
        String key = this.generateKeyForElementType(encodingStyleURI, qname);
        javaType = (Class)this.mm_listXml2Java.get(key);
        if (javaType != null) {
            return javaType;
        }
        javaType = SOAPRegistry.getInstance().getJavaType(qname, encodingStyleURI);
        if (javaType == null) {
            int i = 0;
            while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length) {
                key = this.generateKeyForElementType(ISOAPParamConstants.NS_URIS_SCHEMAS[i], qname);
                javaType = (Class)this.mm_listXml2Java.get(key);
                if (javaType != null) break;
                ++i;
            }
        }
        return javaType;
    }

    public Object createIntance(Class clazz) {
        try {
            if (this.mm_factoryFinder != null) {
                return this.mm_factoryFinder.getInstance(clazz, this.mm_registryClassloader);
            }
            return null;
        }
        catch (SOAPException ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "CreateIntance Method failed", (Exception)((Object)ex));
            }
            return null;
        }
    }

    private final String generateKeyForJavaClass(String namespace, Object type) {
        if (type == null) {
            return "";
        }
        RecyclableStringBuffer recyclable = StringBufferPool.getInstance().get(255);
        recyclable.getBuffer().append(namespace);
        recyclable.getBuffer().append(type.toString());
        String key = recyclable.toString();
        StringBufferPool.getInstance().release(recyclable);
        return key;
    }

    private final String generateKeyForElementType(String namespace, Object type) {
        if (type == null) {
            return "";
        }
        return type.toString();
    }

    private void init(String serviceName, String pathForService, ClassLoader loader) throws Exception {
        this.mm_registryClassloader = loader;
        String pathForProps = null;
        if (pathForService != null) {
            pathForProps = pathForService + this.SLASH + "soap" + this.SLASH + "serializers.properties";
            Properties serializer = new Properties();
            try {
                FileInputStream is = new FileInputStream(pathForProps);
                if (is != null) {
                    serializer.load(is);
                    ((InputStream)is).close();
                }
            }
            catch (FileNotFoundException e) {
                serializer = null;
            }
            catch (IOException e) {
                serializer = null;
            }
            if (serializer != null) {
                this.initSerializers(serializer);
            }
            String pathForMappInt = pathForService + this.SLASH + "soap" + this.SLASH + "mappingInterfaces.properties";
            this.mm_factoryFinder = this.createFactory(pathForMappInt);
        }
    }

    public void initXMLBased(String serviceName, String pathForService, ClassLoader loader) throws Exception {
        this.mm_registryClassloader = loader;
        String pathForXMLConfig = null;
        if (pathForService != null) {
            pathForXMLConfig = pathForService + this.SLASH + "soap" + this.SLASH + "soapconfig.xml";
            try {
                FileInputStream is = new FileInputStream(pathForXMLConfig);
                if (is != null) {
                    this.mm_soapConfig = PortalSOAPConfigFactory.getInstance().getSOAPConfigInstance(is);
                    ((InputStream)is).close();
                }
            }
            catch (FileNotFoundException e) {
                this.init(serviceName, pathForService, loader);
            }
            catch (IOException e) {
                this.init(serviceName, pathForService, loader);
            }
            if (this.mm_soapConfig != null) {
                this.initSerializersXML(serviceName);
                this.mm_factoryFinder = this.createFactoryXML(this.mm_soapConfig, serviceName);
            }
        }
    }

    private FactoryFinder createFactoryXML(IPortalSOAPConfig mm_soapConfig, String serviceName) {
        if (mm_soapConfig.getPortalWebService(serviceName) != null) {
            IPortalWebService webservice = mm_soapConfig.getPortalWebService(serviceName);
            return new FactoryFinder(webservice);
        }
        return null;
    }

    private FactoryFinder createFactory(String path) {
        Properties mappingInterface = new Properties();
        try {
            FileInputStream is = new FileInputStream(path);
            if (is != null) {
                mappingInterface.load(is);
                ((InputStream)is).close();
            }
        }
        catch (FileNotFoundException e) {
            mappingInterface = null;
        }
        catch (IOException e) {
            mappingInterface = null;
        }
        return new FactoryFinder(mappingInterface);
    }

    private void initSerializers(Properties prop) throws Exception {
        Enumeration enumeration = ((Hashtable)prop).elements();
        while (enumeration.hasMoreElements()) {
            String item = (String)enumeration.nextElement();
            StringTokenizer tokenizer = new StringTokenizer(item, ";");
            while (tokenizer.hasMoreElements()) {
                Class<?> type = null;
                Object serial = null;
                String token = tokenizer.nextToken();
                try {
                    type = Class.forName(token, true, this.mm_registryClassloader);
                }
                catch (Exception ex) {
                    SOAPLogger logger = SOAPLogger.getInstance();
                    if (logger != null) {
                        logger.writeInfo(this, "initSerializers Method failed", ex);
                    }
                    throw ex;
                }
                String namespace = tokenizer.nextToken();
                String localpart = tokenizer.nextToken();
                QName qname = new QName(namespace, localpart);
                String className = tokenizer.nextToken();
                try {
                    Class<?> theClass = Class.forName(className, true, this.mm_registryClassloader);
                    serial = theClass.newInstance();
                }
                catch (Exception ex) {
                    SOAPLogger logger = SOAPLogger.getInstance();
                    if (logger != null) {
                        logger.writeInfo(this, "InitSerializers Method failed", ex);
                    }
                    throw ex;
                }
                this.addMappings("http://schemas.xmlsoap.org/soap/encoding/", type, qname, serial, serial);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initSerializersXML(String serviceName) throws Exception {
        portalService = this.mm_soapConfig.getPortalWebService(serviceName);
        if (portalService == null) {
            throw new PRTFaultInternalError("Not able to initialize Web Service configuration for service " + serviceName, (Object)portalService, (Exception)new IllegalStateException("Not able to initialize Web Service configuration for service " + serviceName));
        }
        enum = portalService.getAllPortalWebServiceSerializers();
        if (enum != null) ** GOTO lbl32
        throw new PRTFaultInternalError("Not able to initialize Web Service properties for service " + serviceName, (Object)portalService, (Exception)new IllegalStateException());
lbl-1000:
        // 1 sources

        {
            serial = (IPortalWebServiceSerializer)enum.nextElement();
            type = null;
            serializer = null;
            try {
                type = Class.forName(serial.getJavatype(), true, this.mm_registryClassloader);
            }
            catch (Exception ex) {
                logger = SOAPLogger.getInstance();
                if (logger != null) {
                    logger.writeInfo(this, "initSerializersXML Method failed", ex);
                }
                throw ex;
            }
            namespace = serial.getNamespace();
            localpart = serial.getLocalpart();
            qname = new QName(namespace, localpart);
            className = serial.getSerializer();
            try {
                theClass = Class.forName(className, true, this.mm_registryClassloader);
                serializer = theClass.newInstance();
            }
            catch (Exception ex) {
                logger = SOAPLogger.getInstance();
                if (logger != null) {
                    logger.writeInfo(this, "InitSerializers Method failed", ex);
                }
                throw ex;
            }
            this.addMappings(namespace, type, qname, serializer, serializer);
lbl32:
            // 2 sources

            ** while (enum.hasMoreElements())
        }
lbl33:
        // 1 sources

    }

    private void addMappings(String URI2, Class javaType, QName name, SOAPDeserializer deserializer, SOAPSerializer serializer) {
        String keyForXml = this.generateKeyForElementType(URI2, name);
        String keyForJava = this.generateKeyForJavaClass(URI2, javaType);
        if (deserializer != null) {
            this.mm_listDeserializer.put(keyForXml, deserializer);
        }
        if (serializer != null) {
            this.mm_listSerializer.put(keyForJava, serializer);
        }
        if (name != null && javaType != null) {
            this.mm_listJava2Xml.put(keyForJava, name);
            this.mm_listXml2Java.put(keyForXml, javaType);
            this.mm_listJava2Namespace.put(javaType.getName(), URI2);
        }
    }

    public boolean isPrimitive(Class aClass) {
        return SOAPRegistry.getInstance().isPrimitive(aClass);
    }

    public Hashtable getListSerializers() {
        return this.mm_listSerializer;
    }

    public Hashtable getListUnSerializers() {
        return this.mm_listDeserializer;
    }

    public Hashtable getListJavaTypes() {
        return this.mm_listXml2Java;
    }

    public Hashtable getListQName() {
        return this.mm_listJava2Xml;
    }

    public ClassLoader getRegistryClassLoader() {
        return this.mm_registryClassloader;
    }

    public IPortalSOAPConfig getSOAPConfig() {
        return this.mm_soapConfig;
    }
}

