/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.mapping;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InitMapping {
    private static final String PREFIX_ERROR_MSG = "For Soap type ";
    private static InitMapping mm_instance = null;
    private final String SLASH = File.separator;

    private InitMapping() {
    }

    public static InitMapping getInstance() {
        if (mm_instance == null) {
            mm_instance = new InitMapping();
        }
        return mm_instance;
    }

    public static void destroy() {
        mm_instance = null;
    }

    public static InitMapping getInstanceInit(InputStream in) {
        if (mm_instance == null) {
            mm_instance = new InitMapping();
            mm_instance.initializeAllMappingsForWSDL(in);
        }
        return mm_instance;
    }

    public void initializeAllMappingsForWSDL(InputStream in) {
        this.initMappingFromXmlFile(in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getValueFromTagName(Element typeElement, String tagName) throws IllegalArgumentException {
        NodeList childs = typeElement.getElementsByTagName(tagName);
        String res = null;
        if (childs.getLength() != 1) throw new IllegalArgumentException();
        Node node = childs.item(0);
        if (node.getNodeType() != 1) throw new IllegalArgumentException();
        Element property = (Element)node;
        if (!property.hasChildNodes()) throw new IllegalArgumentException();
        return property.getFirstChild().getNodeValue();
    }

    private void initMappingFromXmlFile(InputStream in) {
        block37: {
            String[] data = new String[6];
            try {
                DocumentBuilder docBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
                Document doc = docBuilder.parse(in);
                Element root = doc.getDocumentElement();
                NodeList list = root.getElementsByTagName("datatype");
                int i = 0;
                while (i < list.getLength()) {
                    Object deser;
                    Object ser;
                    Class<Object> typeClass;
                    block36: {
                        ILogger logger;
                        ILogger logger2;
                        block35: {
                            ILogger logger3;
                            block34: {
                                block33: {
                                    Element typeElement = (Element)list.item(i);
                                    try {
                                        String tagName = "type";
                                        data[1] = this.getValueFromTagName(typeElement, tagName);
                                        tagName = "namespaceuri";
                                        data[2] = this.getValueFromTagName(typeElement, tagName);
                                        tagName = "localpartname";
                                        data[3] = this.getValueFromTagName(typeElement, tagName);
                                        tagName = "deserializer";
                                        data[4] = this.getValueFromTagName(typeElement, tagName);
                                        tagName = "serializer";
                                        data[5] = this.getValueFromTagName(typeElement, tagName);
                                    }
                                    catch (IllegalArgumentException iae) {
                                        iae.printStackTrace();
                                        ILogger logger4 = PortalRuntime.getLogger((String)"SOAPLogger");
                                        if (logger4 == null || !logger4.isActive()) break block33;
                                        logger4.warning((Throwable)iae, this.getClass().getName() + "Cannot extract properties for Soap type " + data[1] + "Checks its definition");
                                    }
                                }
                                typeClass = null;
                                try {
                                    if (ToolKit.isSimpleType(data[1])) {
                                        typeClass = ToolKit.returnClassSimpleType(data[1]);
                                        if (typeClass == null) {
                                            throw new IllegalArgumentException();
                                        }
                                    } else {
                                        typeClass = data[1].equals("null") ? null : Class.forName(data[1]);
                                    }
                                }
                                catch (IllegalArgumentException iae) {
                                    iae.printStackTrace();
                                    ILogger logger5 = PortalRuntime.getLogger((String)"SOAPLogger");
                                    if (logger5 != null && logger5.isActive()) {
                                        logger5.warning((Throwable)iae, this.getClass().getName() + "Class for Soap type " + data[1] + "supposed to be primitive but is not");
                                    }
                                }
                                catch (ClassNotFoundException cnfe) {
                                    cnfe.printStackTrace();
                                    logger3 = PortalRuntime.getLogger((String)"SOAPLogger");
                                    if (logger3 == null || !logger3.isActive()) break block34;
                                    logger3.warning((Throwable)cnfe, this.getClass().getName() + "Class for Soap type " + data[1] + "not found");
                                }
                            }
                            ser = null;
                            try {
                                ser = data[5].equals("null") ? null : Class.forName(data[5], true, this.getClass().getClassLoader()).newInstance();
                            }
                            catch (ClassNotFoundException cnfe) {
                                cnfe.printStackTrace();
                                logger3 = PortalRuntime.getLogger((String)"SOAPLogger");
                                if (logger3 != null && logger3.isActive()) {
                                    logger3.warning((Throwable)cnfe, this.getClass().getName() + "Serializer for Soap type " + data[1] + "not found");
                                }
                            }
                            catch (IllegalAccessException iae) {
                                iae.printStackTrace();
                                logger2 = PortalRuntime.getLogger((String)"SOAPLogger");
                                if (logger2 != null && logger2.isActive()) {
                                    logger2.warning((Throwable)iae, this.getClass().getName() + PREFIX_ERROR_MSG + data[1] + ": the class or its nullary constructor is not accessible");
                                }
                            }
                            catch (InstantiationException ie) {
                                ie.printStackTrace();
                                logger = PortalRuntime.getLogger((String)"SOAPLogger");
                                if (logger == null || !logger.isActive()) break block35;
                                logger.warning((Throwable)ie, this.getClass().getName() + PREFIX_ERROR_MSG + data[1] + ": instantiation fails");
                            }
                        }
                        deser = null;
                        try {
                            deser = data[4].equals("null") ? null : Class.forName(data[4], true, this.getClass().getClassLoader()).newInstance();
                        }
                        catch (ClassNotFoundException cnfe) {
                            cnfe.printStackTrace();
                            logger2 = PortalRuntime.getLogger((String)"SOAPLogger");
                            if (logger2 != null && logger2.isActive()) {
                                logger2.warning((Throwable)cnfe, this.getClass().getName() + "Deserializer for Soap type " + data[1] + "not found");
                            }
                        }
                        catch (IllegalAccessException iae) {
                            iae.printStackTrace();
                            logger = PortalRuntime.getLogger((String)"SOAPLogger");
                            if (logger != null && logger.isActive()) {
                                logger.warning((Throwable)iae, this.getClass().getName() + PREFIX_ERROR_MSG + data[1] + ": the class or its nullary constructor is not accessible");
                            }
                        }
                        catch (InstantiationException ie) {
                            ie.printStackTrace();
                            ILogger logger6 = PortalRuntime.getLogger((String)"SOAPLogger");
                            if (logger6 == null || !logger6.isActive()) break block36;
                            logger6.warning((Throwable)ie, this.getClass().getName() + PREFIX_ERROR_MSG + data[1] + ": instantiation fails");
                        }
                    }
                    QName qName = new QName(data[2], data[3]);
                    SOAPRegistry.getInstance().addMappings(data[2], typeClass, qName, (SOAPDeserializer)deser, (SOAPSerializer)ser);
                    if (data[3].equals("Array")) {
                        SOAPRegistry.getInstance().setArrayQName(qName);
                        SOAPRegistry.getInstance().setArraySerializer((SOAPSerializer)ser);
                    }
                    ++i;
                }
            }
            catch (FactoryConfigurationError fce) {
                fce.printStackTrace();
                System.out.println("implementation is not available or cannot be instantiated");
                ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                if (logger != null && logger.isActive()) {
                    logger.warning((Throwable)fce, "implementation is not available or cannot be instantiated");
                }
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
                System.out.println("DocumentBuilder cannot be created which satisfies the configuration requested");
                ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                if (logger != null && logger.isActive()) {
                    logger.warning((Throwable)pce, "DocumentBuilder cannot be created which satisfies the configuration requested");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.out.println("IO error occur");
                ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                if (logger != null && logger.isActive()) {
                    logger.warning((Throwable)ioe, "IO error occur");
                }
            }
            catch (SAXException se) {
                se.printStackTrace();
                System.out.println("Parse  errors occur");
                ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                if (logger != null && logger.isActive()) {
                    logger.warning((Throwable)se, "Parse  errors occur");
                }
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                System.out.println("Input stream is null");
                ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                if (logger == null || !logger.isActive()) break block37;
                logger.warning((Throwable)iae, "Input stream is null");
            }
        }
    }

    public static void main(String[] args) {
        try {
            InitMapping.getInstance().initMappingFromXmlFile(new FileInputStream("C:\\_ep60\\com.sapportals.portal.portal_runtime\\dev\\applications\\soap\\dist\\PORTAL-INF\\types\\soapTypes2.xml"));
            Class<?> serClass = Class.forName("com.sapportals.portal.prt.service.soap.encoding.GDaySerializer");
            Object serial = serClass.newInstance();
            System.out.println("ser:" + serial.toString());
            Class<?> deserClass = Class.forName("com.sapportals.portal.prt.service.soap.decoding.GDayDeserializer");
            Object deserial = deserClass.newInstance();
            System.out.println("deser:" + deserial.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("EXCEPTION: file soapTypes.xml");
        }
    }
}

