/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.encoding;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultDataEnconding;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.XMLValueEncoder;
import com.sapportals.portal.prt.service.soap.wsdl.ITypes;
import java.util.Locale;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import org.w3c.dom.Element;

public class LocaleSerializer
implements SOAPSerializer {
    public static final String[] LOCALE_ATTRIBUTE = new String[]{"language", "country", "variant"};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Locale;

    public void marshall(String inScopeEncStyle, Class elementType, SOAPEnvelope envelope, SOAPElement parentElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context) throws SOAPServiceException {
        if (XMLValueEncoder.testNillableInDocument((Object)objectToSerialize, (ISOAPMessageContext)context, (Class)elementType)) {
            return;
        }
        try {
            ISpecializedRegistry reg = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName());
            QName nameLocale = reg.getElementType(elementType).getQName();
            String prefix = context.getPrefixForNamespace(nameLocale.getNamespaceURI());
            if (prefix == null) {
                prefix = context.addNamespaceDeclaration(nameLocale.getNamespaceURI());
            }
            SOAPElement responseElementRoot = XMLValueEncoder.addSOAPElement((SOAPEnvelope)envelope, (SOAPElement)parentElement, (String)nameParam, (String)"xsi", (String)"type", (String)XMLValueEncoder.constructValueforType((String)nameLocale.getNamespaceURI(), (String)nameLocale.getLocalPart(), (ISOAPMessageContext)context), null, (ISOAPMessageContext)context);
            if (objectToSerialize == null && XMLValueEncoder.isNullable((Class)elementType)) {
                XMLValueEncoder.AddNullAttribute((SOAPEnvelope)envelope, (SOAPElement)responseElementRoot, (ISOAPMessageContext)context);
                return;
            }
            Locale locale = (Locale)objectToSerialize;
            String[] values = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
            int nbAttributes = locale.getVariant().equals("") ? LOCALE_ATTRIBUTE.length - 1 : LOCALE_ATTRIBUTE.length;
            int i = 0;
            while (i < nbAttributes) {
                String targetnamespace;
                if (values[i] == null) {
                    throw new PRTFaultSerializator("The null values for Locale attributes is not correct: value for field " + LOCALE_ATTRIBUTE[i] + "is null", (Object)this, new Exception("The null values for Locale attributes is not correct"));
                }
                Class itemType = class$java$lang$String == null ? LocaleSerializer.class$("java.lang.String") : class$java$lang$String;
                SOAPSerializer ser = reg.getSerializer(itemType, targetnamespace = reg.getDefaultNamespace(itemType));
                if (ser == null) {
                    throw new PRTFaultSerializator("The Serializer for " + itemType + " not found or not supported by the soap service!.", (Object)this, new Exception("Serializer not found or not supported"));
                }
                ser.marshall(targetnamespace, itemType, envelope, responseElementRoot, (Object)values[i], LOCALE_ATTRIBUTE[i], context);
                ++i;
            }
        }
        catch (Exception ex) {
            throw new PRTFaultDataEnconding((Object)this, ex);
        }
    }

    public boolean writeSchema(ITypes type) throws Exception {
        Element complexType = type.createElementNS("", "complexType");
        complexType.setAttribute("name", "Locale");
        Element seq = type.createElementNS("", "sequence");
        complexType.appendChild(seq);
        Element element1 = type.createElementNS("", "element");
        element1.setAttribute("name", LOCALE_ATTRIBUTE[0]);
        element1.setAttribute("type", "xsd:string");
        element1.setAttribute("nillable", "false");
        seq.appendChild(element1);
        Element element2 = type.createElementNS("", "element");
        element2.setAttribute("name", LOCALE_ATTRIBUTE[1]);
        element2.setAttribute("type", "xsd:string");
        element2.setAttribute("nillable", "false");
        seq.appendChild(element2);
        Element element3 = type.createElementNS("", "element");
        element3.setAttribute("name", LOCALE_ATTRIBUTE[2]);
        element3.setAttribute("type", "xsd:string");
        element2.setAttribute("nillable", "false");
        seq.appendChild(element3);
        String prefix = type.getPrefixForNameSpace(ISOAPParamConstants.mapQName.getNamespaceURI());
        prefix = prefix == null ? "" : prefix + ":";
        Element el = type.createElement("Locale", prefix + "Locale", XMLValueEncoder.isNullable((Class)(class$java$util$Locale == null ? (class$java$util$Locale = LocaleSerializer.class$("java.util.Locale")) : class$java$util$Locale)), type.getDocFragment());
        type.writeSchemaElement(new QName("http://prt.java.soap/schemas", "Locale"), el);
        el.getParentNode().appendChild(complexType);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

