/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.encoding;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultDataEnconding;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLValueEncoder;
import com.sapportals.portal.prt.service.soap.wsdl.ITypes;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import org.w3c.dom.Element;

public class EnumerationSerializer
implements SOAPSerializer {
    private static final String ENUMERATION_NAME = "Enumeration";
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$util$Vector;

    public void marshall(String inScopeEncStyle, Class elementType, SOAPEnvelope envelope, SOAPElement parentElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context) throws SOAPServiceException {
        if (XMLValueEncoder.testNillableInDocument((Object)objectToSerialize, (ISOAPMessageContext)context, (Class)elementType)) {
            return;
        }
        try {
            QName nameEnumeration = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getElementType(class$java$util$Enumeration == null ? (class$java$util$Enumeration = EnumerationSerializer.class$("java.util.Enumeration")) : class$java$util$Enumeration).getQName();
            String prefix = context.getPrefixForNamespace(nameEnumeration.getNamespaceURI());
            if (prefix == null) {
                prefix = context.addNamespaceDeclaration(nameEnumeration.getNamespaceURI());
            }
            SOAPElement responseElementRoot = XMLValueEncoder.addSOAPElement((SOAPEnvelope)envelope, (SOAPElement)parentElement, (String)nameParam, (String)"xsi", (String)"type", (String)XMLValueEncoder.constructValueforType((String)nameEnumeration.getNamespaceURI(), (String)nameEnumeration.getLocalPart(), (ISOAPMessageContext)context), null, (ISOAPMessageContext)context);
            if (objectToSerialize == null) {
                if (XMLValueEncoder.isNullable((Class)elementType)) {
                    XMLValueEncoder.AddNullAttribute((SOAPEnvelope)envelope, (SOAPElement)responseElementRoot, (ISOAPMessageContext)context);
                }
                return;
            }
            Enumeration enumeration = (Enumeration)objectToSerialize;
            Vector copyEnum = ToolKit.createVector(enumeration);
            SOAPElement responseElement = ToolKit.createArrayRootElement(envelope, context, responseElementRoot, copyEnum.size());
            enumeration = copyEnum.elements();
            while (enumeration.hasMoreElements()) {
                String targetnamespace;
                Object item = enumeration.nextElement();
                if (item == null) continue;
                Class itemType = ToolKit.returnPrimitive(item.getClass());
                ISpecializedRegistry reg = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName());
                SOAPSerializer ser = reg.getSerializer(itemType, targetnamespace = reg.getDefaultNamespace(itemType));
                if (ser == null) {
                    throw new PRTFaultSerializator("The Serializer for " + itemType + " not found or not supported by the soap service!.", (Object)this, new Exception("Serializer not found or not supported"));
                }
                ser.marshall(targetnamespace, itemType, envelope, responseElement, item, "item", context);
            }
        }
        catch (Exception ex) {
            throw new PRTFaultDataEnconding((Object)this, ex);
        }
    }

    public boolean writeSchema(ITypes type) throws Exception {
        Element complexType = type.createElementNS("", "complexType");
        complexType.setAttribute("name", ENUMERATION_NAME);
        Element seq = type.createElementNS("", "sequence");
        complexType.appendChild(seq);
        Element element = type.createElementNS("", "element");
        element.setAttribute("name", "item");
        element.setAttribute("type", "xsd:anyType");
        element.setAttribute("maxOccurs", "unbounded");
        seq.appendChild(element);
        String prefix = type.getPrefixForNameSpace(ISOAPParamConstants.mapQName.getNamespaceURI());
        prefix = prefix == null ? "" : prefix + ":";
        Element el = type.createElement(ENUMERATION_NAME, prefix + ENUMERATION_NAME, XMLValueEncoder.isNullable((Class)(class$java$util$Vector == null ? (class$java$util$Vector = EnumerationSerializer.class$("java.util.Vector")) : class$java$util$Vector)), type.getDocFragment());
        type.writeSchemaElement(new QName("http://prt.java.soap/schemas", ENUMERATION_NAME), el);
        el.getParentNode().appendChild(complexType);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

