/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.encoding;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultDataEnconding;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.types.Entity;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.XMLValueEncoder;
import com.sapportals.portal.prt.service.soap.wsdl.ITypes;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;

public class EntitySerializer
implements SOAPSerializer {
    public void marshall(String inScopeEncStyle, Class elementType, SOAPEnvelope envelope, SOAPElement parentElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context) throws SOAPServiceException {
        if (XMLValueEncoder.testNillableInDocument((Object)objectToSerialize, (ISOAPMessageContext)context, (Class)elementType)) {
            return;
        }
        try {
            QName name = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getElementType(elementType).getQName();
            if (context.isEncodedAsAttribute()) {
                if (objectToSerialize != null) {
                    Entity en = (Entity)objectToSerialize;
                    parentElement.addAttribute(envelope.createName(nameParam), en.getRepresentation());
                }
            } else {
                SOAPElement element = XMLValueEncoder.addSOAPElement((SOAPEnvelope)envelope, (SOAPElement)parentElement, (String)nameParam, (String)"xsi", (String)"type", (String)XMLValueEncoder.constructValueforType((String)name.getNamespaceURI(), (String)name.getLocalPart(), (ISOAPMessageContext)context), (Object)objectToSerialize, (ISOAPMessageContext)context);
                if (objectToSerialize == null) {
                    if (XMLValueEncoder.isNullable((Class)elementType)) {
                        XMLValueEncoder.AddNullAttribute((SOAPEnvelope)envelope, (SOAPElement)element, (ISOAPMessageContext)context);
                    }
                } else {
                    Entity en = (Entity)objectToSerialize;
                    element.addTextNode(en.getRepresentation());
                }
            }
        }
        catch (Exception ex) {
            throw new PRTFaultDataEnconding((Object)this, ex);
        }
    }

    public boolean writeSchema(ITypes type) throws Exception {
        return true;
    }
}

