/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.element;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.SOAPMessageContext;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBody;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBodyElement;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPBodyElement;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPEnvelope;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultEnvelopeVersion;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.processor.MethodContainer;
import com.sapportals.portal.prt.service.soap.util.IMessageDescriptor;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class PRTSOAPBody
implements IPRTSOAPBody {
    private ISOAPMessageContext mm_context = null;
    private PRTSOAPEnvelope mm_envelope = null;
    private SOAPBody mm_soapBody = null;
    private Hashtable mm_listOfBodyElement = new Hashtable();
    private String mm_specificNamespaceURI = null;

    public PRTSOAPBody(PRTSOAPEnvelope env, SOAPBody body) {
        this.mm_envelope = env;
        this.mm_soapBody = body;
        this.init();
    }

    public PRTSOAPBody(IMessageDescriptor descriptor, SOAPMessageContext parentContext) {
        this.mm_context = new SOAPMessageContext(descriptor.getNamespaceURI(), (ISOAPMessageContext)parentContext);
        this.generatePRTBodyElements(descriptor);
    }

    private void init() throws SOAPServiceException {
        try {
            Object obj;
            if (this.mm_context == null) {
                this.mm_context = new SOAPMessageContext((SOAPElement)this.mm_soapBody, this.mm_envelope.getMainContext());
            }
            Iterator it = this.mm_soapBody.getChildElements();
            Vector<SOAPBodyElement> vector = new Vector<SOAPBodyElement>();
            while (it.hasNext()) {
                obj = it.next();
                boolean isValue = true;
                if (!(obj instanceof SOAPBodyElement)) continue;
                SOAPBodyElement bodyElement = (SOAPBodyElement)obj;
                Name idName = this.mm_envelope.getEnvelope().createName("id");
                isValue = true;
                if (bodyElement.getAttributeValue(idName) != null && bodyElement.getAttributeValue(idName).length() > 0 && !bodyElement.getAttributeValue(idName).trim().equals("")) {
                    this.mm_context.addMultirefValues(bodyElement);
                    isValue = false;
                }
                if (!isValue) continue;
                vector.add(bodyElement);
            }
            it = ((AbstractList)vector).iterator();
            while (it.hasNext()) {
                obj = it.next();
                if (!(obj instanceof SOAPBodyElement)) continue;
                SOAPBodyElement bodyElement = (SOAPBodyElement)obj;
                PRTSOAPBodyElement prtBodyElement = new PRTSOAPBodyElement(bodyElement, this.mm_context);
                this.mm_listOfBodyElement.put(prtBodyElement.getName(), prtBodyElement);
                if (this.mm_specificNamespaceURI != null) continue;
                this.mm_specificNamespaceURI = prtBodyElement.getNamespaceURI();
            }
        }
        catch (SOAPServiceException e) {
            throw e;
        }
        catch (SOAPException e) {
            throw new PRTFaultEnvelopeVersion((Object)this, (Exception)((Object)e));
        }
    }

    public ISOAPMessageContext getContext() {
        return this.mm_context;
    }

    public Hashtable getListOfBodyElements() {
        return this.mm_listOfBodyElement;
    }

    public String getMainNamespaceURI() {
        return this.mm_specificNamespaceURI;
    }

    public void marshall(SOAPEnvelope envelope) throws SOAPServiceException {
        try {
            SOAPBody body = envelope.getBody();
            this.mm_context.addNamespaceDeclarationInElement((SOAPElement)body);
            this.generateBody(body);
            if (!(this.mm_context.isDocumentStyleEncoding() || this.mm_context.getEncodingStyleNotDelegate() == null || this.mm_context.isLitteralStyleEncodingAsked() != null && this.mm_context.isLitteralStyleEncodingAsked().equals("true"))) {
                body.setEncodingStyle(this.mm_context.getEncodingStyleNotDelegate());
            }
            Enumeration enumeration = this.mm_listOfBodyElement.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                PRTSOAPBodyElement bodyElement = (PRTSOAPBodyElement)this.mm_listOfBodyElement.get(key);
                if (this.mm_context.getMethodContainer() == null) {
                    IPortalWebServiceMethod method = ToolKit.getportalWebServicemethod(this.mm_context.getServiceDescriptor().getServiceName(), key, bodyElement.getAttributeHandler());
                    if (method == null) {
                        throw new PRTFaultSerializator((Object)this, (Exception)new IllegalArgumentException("The Method Container " + key + " is empty."));
                    }
                    MethodContainer mcontainer = new MethodContainer();
                    mcontainer.setWebserviceMethod_config(method);
                    this.mm_context.setMethodContainer(mcontainer);
                }
                bodyElement.marshall(envelope, body);
                if (!this.mm_context.isDocumentStyleEncoding() || !this.mm_context.isResponse()) {
                    continue;
                }
                break;
            }
        }
        catch (SOAPServiceException ex) {
            throw ex;
        }
        catch (SOAPException e) {
            throw new PRTFaultSerializator((Object)this, (Exception)((Object)e));
        }
    }

    private SOAPBody generateBody(SOAPBody spBody) throws SOAPServiceException {
        try {
            Enumeration enumeration = this.mm_context.getPrefixes();
            while (enumeration.hasMoreElements()) {
                String item = (String)enumeration.nextElement();
                spBody.addNamespaceDeclaration(item, this.mm_context.getNamespaceFromPrefix(item));
            }
            return spBody;
        }
        catch (SOAPServiceException ex) {
            throw ex;
        }
        catch (SOAPException e) {
            throw new PRTFaultSerializator((Object)this, (Exception)((Object)e));
        }
    }

    private void generatePRTBodyElements(IMessageDescriptor descriptor) {
        if (this.mm_listOfBodyElement == null) {
            this.mm_listOfBodyElement = new Hashtable();
        }
        PRTSOAPBodyElement bodyElement = new PRTSOAPBodyElement(this.mm_context, descriptor.getNamespaceURI(), descriptor.getNameBodyElements(), descriptor.getElements());
        this.mm_listOfBodyElement.put(bodyElement.getName(), bodyElement);
    }

    public IPRTSOAPBodyElement generateEmptyPRTSOAPBodyElementEntry() {
        if (this.mm_listOfBodyElement == null) {
            this.mm_listOfBodyElement = new Hashtable();
        }
        PRTSOAPBodyElement bodyElement = new PRTSOAPBodyElement(this.mm_context);
        this.mm_listOfBodyElement.put("DOCLittelralResponse", bodyElement);
        return bodyElement;
    }
}

