/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.decoding;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.SOAPMessageContext;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.XMLValueExtractor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPElement;

public class MapDeserializer
implements SOAPDeserializer {
    static /* synthetic */ Class class$java$util$Map;

    public SOAPParameter unmarshall(String inScopeEncStyle, QName elementType, SOAPElement element, ISOAPMessageContext context) {
        if (XMLValueExtractor.isValueNull((SOAPElement)element)) {
            return new SOAPParameter(elementType, class$java$util$Map == null ? (class$java$util$Map = MapDeserializer.class$("java.util.Map")) : class$java$util$Map, null);
        }
        Map map = this.processHashParams(element.getChildElements(), context);
        SOAPParameter parameter = new SOAPParameter(elementType, class$java$util$Map == null ? (class$java$util$Map = MapDeserializer.class$("java.util.Map")) : class$java$util$Map, (Object)map);
        return parameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map processHashParams(Iterator aChildIterator, ISOAPMessageContext context) {
        SOAPDeserializer deser;
        QName qname;
        SOAPMessageContext contextElement;
        SOAPElement element;
        Object item;
        Hashtable<Object, Object> aHash = new Hashtable<Object, Object>();
        if (aChildIterator == null) {
            return null;
        }
        SOAPParameter tabKeys = null;
        SOAPParameter tabValues = null;
        while (aChildIterator.hasNext()) {
            item = aChildIterator.next();
            if (!(item instanceof SOAPElement)) continue;
            element = XMLValueExtractor.getSOAPElementFromRef((SOAPElement)((SOAPElement)item), (ISOAPMessageContext)context);
            contextElement = new SOAPMessageContext(element, context);
            if (XMLValueExtractor.isValueNull((SOAPElement)element)) break;
            qname = XMLValueExtractor.getQNameForElement((SOAPElement)element, (ISOAPMessageContext)contextElement);
            deser = SOAPRegistry.getInstance().getSpecializedRegistry(contextElement.getServiceDescriptor().getServiceName()).getDeserializer(qname, contextElement.getEncodingStyle());
            if (deser == null) {
                throw new PRTFaultSerializator("The Deserializer for " + qname.getLocalPart() + " not found or not supported by the soap service!.", (Object)this, new Exception("Deserializer not found or not supported"));
            }
            tabKeys = deser.unmarshall(context.getEncodingStyle(), qname, element, (ISOAPMessageContext)contextElement);
            break;
        }
        while (aChildIterator.hasNext()) {
            item = aChildIterator.next();
            if (!(item instanceof SOAPElement)) continue;
            element = XMLValueExtractor.getSOAPElementFromRef((SOAPElement)((SOAPElement)item), (ISOAPMessageContext)context);
            contextElement = new SOAPMessageContext(element, context);
            if (XMLValueExtractor.isValueNull((SOAPElement)element)) break;
            qname = XMLValueExtractor.getQNameForElement((SOAPElement)element, (ISOAPMessageContext)contextElement);
            deser = SOAPRegistry.getInstance().getSpecializedRegistry(contextElement.getServiceDescriptor().getServiceName()).getDeserializer(qname, contextElement.getEncodingStyle());
            if (deser == null) {
                throw new PRTFaultSerializator("The Deserializer for " + qname.getLocalPart() + " not found or not supported by the soap service!.", (Object)this, new Exception("Deserializer not found or not supported"));
            }
            tabValues = deser.unmarshall(context.getEncodingStyle(), qname, element, (ISOAPMessageContext)contextElement);
            break;
        }
        if (tabKeys == null && tabValues == null) {
            return null;
        }
        if (tabKeys == null || tabValues == null) throw new PRTFaultSerializator("MAP Deserializer: one of two array is null", tabKeys, new Exception("Map format is not good! (one of two array is null)"));
        if (tabKeys.getArrayContainedClasses().length != tabValues.getArrayContainedClasses().length) throw new PRTFaultSerializator("MAP Deserializer: the length of the two array is not equals", tabKeys, new Exception("Map format is not good (the length of the two array is not equals)!"));
        Object[] keys = (Object[])tabKeys.getValue();
        Object[] values = (Object[])tabValues.getValue();
        int i = 0;
        while (i < keys.length) {
            aHash.put(keys[i], values[i]);
            ++i;
        }
        return aHash;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

