/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.decoding;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.ParamsProcessor;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.decoding.Array2DDeserializer;
import com.sapportals.portal.prt.service.soap.decoding.ArrayDeserializerHandler;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.QNameURI;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLValueExtractor;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceParameter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Node;

public class ArrayDeserializer
implements SOAPDeserializer {
    private final int SIMPLEDIMENSION = 0;
    private final int MULTIDIMENSION = 1;
    private final int ARRAYOFARRAY = 2;
    private final int UNDETERMINED = 4;
    private String mm_arrayTypeAndSizeExtracted = null;
    static /* synthetic */ Class class$java$lang$Object;

    private int determinetypeArray(String arrayTypeAndSize, String arrayTypeLocalPart) {
        int leftBracketIndex = arrayTypeAndSize.lastIndexOf(91);
        int rightBracketIndex = arrayTypeAndSize.lastIndexOf(93);
        if (leftBracketIndex == -1 || rightBracketIndex == -1 || rightBracketIndex < leftBracketIndex) {
            throw new PRTFaultSerializator("Malformed arrayTypeValue '" + arrayTypeLocalPart + "'.", (Object)this, (Exception)new IllegalArgumentException("Malformed arrayTypeValue '" + arrayTypeLocalPart + "'."));
        }
        int firstBracket = arrayTypeAndSize.indexOf(91);
        int lastBracket = arrayTypeAndSize.lastIndexOf(91);
        if (lastBracket != firstBracket) {
            return 2;
        }
        String lengthStr = arrayTypeAndSize.substring(leftBracketIndex + 1, rightBracketIndex);
        if (lengthStr.indexOf(44) != -1) {
            return 1;
        }
        return 0;
    }

    private ArrayDeserializerHandler getNewArray(String inScopeEncStyle, SOAPElement arrayElement, ISOAPMessageContext context, QNameURI arrayType) throws SOAPServiceException {
        int nbChilds;
        String arrayTypeNamespaceURI = arrayType.getQName().getNamespaceURI();
        String arrayTypeLocalPart = arrayType.getQName().getLocalPart();
        String arrayTypeAndSize = null;
        boolean arrayOffSet = false;
        if (context.isDocumentStyleEncoding() && context.isArrayList()) {
            String nameChildren = context.getArrayChildsName();
            int count = 0;
            if (nameChildren != null) {
                Iterator iterChilds = arrayElement.getChildElements();
                while (iterChilds.hasNext()) {
                    Node node = (Node)iterChilds.next();
                    if (node.getNodeType() != 1 || !((SOAPElement)node).getElementName().getLocalName().equals(nameChildren)) continue;
                    ++count;
                }
                String prefix = context.getPrefixForNamespace(arrayTypeNamespaceURI);
                arrayTypeAndSize = prefix + ":" + arrayTypeLocalPart + "[" + count + "]";
            }
        }
        if (arrayTypeAndSize == null) {
            Iterator iter = arrayElement.getAllAttributes();
            while (iter.hasNext()) {
                Name item = (Name)iter.next();
                if (!item.getLocalName().equals("arrayType")) continue;
                arrayTypeAndSize = arrayElement.getAttributeValue(item);
                break;
            }
        }
        if (arrayTypeAndSize == null && arrayTypeLocalPart.indexOf("Array") == -1 && (nbChilds = ToolKit.countItem(arrayElement.getChildElements())) > 0) {
            String prefix = context.getPrefixForNamespace(arrayTypeNamespaceURI);
            arrayTypeAndSize = prefix + ":" + arrayTypeLocalPart + "[" + nbChilds + "]";
        }
        if (arrayTypeAndSize == null && context.getMethodContainer() != null) {
            if (!arrayType.getQName().equals((Object)ISOAPParamConstants.SOAP_ARRAY)) {
                String prefix = context.getPrefixForNamespace(arrayType.getQName().getNamespaceURI());
                arrayTypeAndSize = prefix + ":" + arrayType.getQName().getLocalPart() + "[" + ToolKit.countItem(arrayElement.getChildElements()) + "]";
            } else if (context.getMethodContainer().getWebserviceMethod_config() != null) {
                IPortalWebServiceMethod method = context.getMethodContainer().getWebserviceMethod_config();
                IPortalWebServiceParameter param = null;
                if (context.isResponse()) {
                    param = method.getReturnPortalWebServiceParameter();
                    if (context.isDocumentStyleEncoding()) {
                        if (!param.getNameElement().equals(arrayElement.getElementName().getLocalName())) {
                            param = null;
                        }
                    } else {
                        param = method.foundParameter(arrayElement.getElementName().getLocalName());
                    }
                } else {
                    param = method.foundParameter(arrayElement.getElementName().getLocalName());
                }
                if (param != null && param.getEnconding().equals("literal")) {
                    String javatype_ = param.getDefaultJavaType();
                    try {
                        ISpecializedRegistry registry = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName());
                        if (registry != null) {
                            QNameURI qn;
                            String javatype_clean = javatype_.substring(0, javatype_.indexOf("["));
                            Class ctype = registry.loadClassInRegistry(javatype_clean);
                            if (ctype == null) {
                                ctype = ToolKit.returnClassSimpleType(javatype_clean);
                            }
                            if ((qn = registry.getElementType(ctype)) != null) {
                                String prefix = context.getPrefixForNamespace(qn.getQName().getNamespaceURI());
                                arrayTypeAndSize = prefix + ":" + qn.getQName().getLocalPart() + "[" + ToolKit.countItem(arrayElement.getChildElements()) + "]";
                            }
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        if (arrayTypeAndSize == null) {
            throw new PRTFaultSerializator("Array Size not found.", (Object)this, (Exception)new IllegalArgumentException("Array Size not found."));
        }
        this.mm_arrayTypeAndSizeExtracted = arrayTypeAndSize;
        int type = this.determinetypeArray(arrayTypeAndSize, arrayTypeLocalPart);
        switch (type) {
            case 0: {
                return this.getNewArraySimple(arrayTypeAndSize, arrayTypeNamespaceURI, arrayTypeLocalPart, inScopeEncStyle, arrayElement, context);
            }
            case 1: {
                return this.getNewArrayMulti(arrayTypeAndSize, arrayTypeNamespaceURI, arrayTypeLocalPart, inScopeEncStyle, arrayElement, context);
            }
            case 2: {
                return this.getNewArrayOfArray(context, arrayElement, arrayTypeAndSize, arrayType.getQName(), inScopeEncStyle);
            }
        }
        return null;
    }

    public SOAPParameter unmarshall(String inScopeEncStyle, QName elementType, SOAPElement element, ISOAPMessageContext context) {
        QNameURI arrayType = XMLValueExtractor.getQNameURIForElement((SOAPElement)element, (ISOAPMessageContext)context, (boolean)true);
        if (arrayType == null) {
            arrayType = new QNameURI(elementType, inScopeEncStyle);
        }
        if (arrayType == null) {
            throw new PRTFaultSerializator("The Deserializer for the type of Childs Array is unknown!.", (Object)this, new Exception("The Deserializer for the type of Childs Array is unknown!."));
        }
        ArrayDeserializerHandler arrayHandler = this.getNewArray(inScopeEncStyle, element, context, arrayType);
        if (XMLValueExtractor.isValueNull((SOAPElement)element)) {
            return new SOAPParameter(arrayType.getQName(), arrayHandler.getType(), null);
        }
        return this.getSOAPParameterFromArray(inScopeEncStyle, element, context, arrayType, this.mm_arrayTypeAndSizeExtracted, arrayHandler);
    }

    private int countParams(Iterator iter) {
        int count = 0;
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof SOAPElement)) continue;
            ++count;
        }
        return count;
    }

    private boolean processArrayParams(Iterator params, ArrayDeserializerHandler arrayHandler, ISOAPMessageContext context, QNameURI type) {
        if (params == null) {
            return false;
        }
        if (arrayHandler.isArray2D()) {
            int raws = arrayHandler.getRaws();
            int columns = arrayHandler.getColumns();
            int i = 0;
            while (i < raws) {
                Object columnsArray = null;
                int j = 0;
                while (j < columns) {
                    Object obj = params.next();
                    if (obj instanceof SOAPElement) {
                        SOAPElement element = (SOAPElement)obj;
                        QNameURI name = null;
                        SOAPElement param_ = XMLValueExtractor.getSOAPElementFromRef((SOAPElement)element, (ISOAPMessageContext)context);
                        name = XMLValueExtractor.getQNameURIForElement((SOAPElement)param_, (ISOAPMessageContext)context);
                        if (name == null) {
                            name = type;
                        }
                        SOAPParameter parameter = ParamsProcessor.getInstance().getSOAPParameter(param_, name, context);
                        if (j == 0) {
                            columnsArray = Array.newInstance(parameter.getType(), raws);
                        }
                        Array.set(columnsArray, j, parameter.getValue());
                        arrayHandler.getClasses()[i + j] = parameter.getType();
                    }
                    ++j;
                }
                Array.set(arrayHandler.getArray(), i, columnsArray);
                ++i;
            }
            return true;
        }
        int i = arrayHandler.getOffset();
        while (params.hasNext()) {
            Object obj = params.next();
            if (!(obj instanceof SOAPElement)) continue;
            SOAPElement element = (SOAPElement)obj;
            SOAPElement param_ = XMLValueExtractor.getSOAPElementFromRef((SOAPElement)element, (ISOAPMessageContext)context);
            QNameURI name = null;
            name = XMLValueExtractor.getQNameURIForElement((SOAPElement)param_, (ISOAPMessageContext)context);
            if (name == null) {
                name = type;
            }
            SOAPParameter parameter = ParamsProcessor.getInstance().getSOAPParameter(param_, name, context);
            Array.set(arrayHandler.getArray(), i, parameter.getValue());
            arrayHandler.getClasses()[i] = parameter.getType();
            ++i;
        }
        return true;
    }

    private ArrayDeserializerHandler getNewArraySimple(String arrayTypeAndSize, String arrayTypeNamespaceURI, String arrayTypeLocalPart, String inScopeEncStyle, SOAPElement arrayElement, ISOAPMessageContext context) {
        boolean arrayOffSet = false;
        int leftBracketIndex = arrayTypeAndSize.lastIndexOf(91);
        int rightBracketIndex = arrayTypeAndSize.lastIndexOf(93);
        String componentTypeName = arrayTypeAndSize.substring(0, leftBracketIndex);
        String prefixItemType = null;
        if (componentTypeName.indexOf(":") >= 0) {
            prefixItemType = componentTypeName.substring(0, componentTypeName.indexOf(":"));
            componentTypeName = componentTypeName.substring(componentTypeName.indexOf(":") + 1);
        }
        QName arrayItemType = null;
        arrayItemType = prefixItemType != null ? new QName(context.getNamespaceFromPrefix(prefixItemType), componentTypeName) : new QName(arrayTypeNamespaceURI, componentTypeName);
        int length = this.countParams(arrayElement.getChildElements());
        String lengthStr = arrayTypeAndSize.substring(leftBracketIndex + 1, rightBracketIndex);
        int offset = this.extractOffSet(arrayElement);
        int totalSize = 0;
        if (lengthStr.length() > 0) {
            int explicitLength = 0;
            explicitLength = Integer.parseInt(lengthStr);
            if (!context.isDocumentStyleEncoding() && !context.isArrayList() && length + offset != explicitLength) {
                throw new PRTFaultSerializator("Explicit array length is not equal to the number of items'" + explicitLength + "!= " + length + "'.", (Object)this, (Exception)new IllegalArgumentException("Explicit array length is not equal to the number of items'" + explicitLength + "!= " + length + "'."));
            }
            totalSize = explicitLength;
        } else {
            totalSize = length + offset;
        }
        Class classType = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getJavaType(arrayItemType, inScopeEncStyle);
        if (classType == null) {
            throw new PRTFaultSerializator("The Array XML Schema of your SOAP Message is not supported !", (Object)this, new Exception("XML Schema not supported"));
        }
        Object theMainArray = Array.newInstance(classType, totalSize);
        Class[] classes = new Class[totalSize];
        ArrayDeserializerHandler handler = new ArrayDeserializerHandler(theMainArray, classes, false, 1, length, offset);
        return handler;
    }

    private ArrayDeserializerHandler getNewArrayMulti(String arrayTypeAndSize, String arrayTypeNamespaceURI, String arrayTypeLocalPart, String inScopeEncStyle, SOAPElement arrayElement, ISOAPMessageContext context) {
        Class classType;
        int leftBracketIndex = arrayTypeAndSize.lastIndexOf(91);
        int rightBracketIndex = arrayTypeAndSize.lastIndexOf(93);
        String componentTypeName = arrayTypeAndSize.substring(0, leftBracketIndex);
        String prefixItemType = null;
        if (componentTypeName.indexOf(":") >= 0) {
            prefixItemType = componentTypeName.substring(0, componentTypeName.indexOf(":"));
            componentTypeName = componentTypeName.substring(componentTypeName.indexOf(":") + 1);
        }
        QName arrayItemType = null;
        arrayItemType = prefixItemType != null ? new QName(context.getNamespaceFromPrefix(prefixItemType), componentTypeName) : new QName(arrayTypeNamespaceURI, componentTypeName);
        int length = this.countParams(arrayElement.getChildElements());
        String lengthStr = arrayTypeAndSize.substring(leftBracketIndex + 1, rightBracketIndex);
        boolean array2D = true;
        int[] arrayDimensions = new int[]{1, 1};
        int raws = 0;
        int columns = 0;
        if (lengthStr.length() > 0) {
            int explicitLength = 0;
            if (lengthStr.indexOf(44) != -1) {
                array2D = true;
                Array2DDeserializer a2dd = new Array2DDeserializer();
                try {
                    explicitLength = a2dd.getTotal(lengthStr);
                    raws = a2dd.getRaws(lengthStr);
                    columns = a2dd.getColumns(lengthStr);
                    arrayDimensions[0] = raws;
                    arrayDimensions[1] = columns;
                }
                catch (SOAPServiceException sse) {
                    throw new SOAPServiceException((Throwable)sse);
                }
            }
        }
        if (inScopeEncStyle.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            inScopeEncStyle = "http://www.w3.org/2001/XMLSchema";
        }
        if ((classType = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getJavaType(arrayItemType, inScopeEncStyle)) == null) {
            throw new PRTFaultSerializator("The Array XML Schema of your SOAP Message is not supported !", (Object)this, new Exception("XML Schema not supported"));
        }
        Object theMainArray = Array.newInstance(classType, arrayDimensions);
        Class[] classes = new Class[length];
        ArrayDeserializerHandler handler = new ArrayDeserializerHandler(theMainArray, classes, array2D, raws, columns, 0);
        return handler;
    }

    private SOAPParameter getSOAPParameterFromArray(String inScopeEncStyle, SOAPElement arrayElement, ISOAPMessageContext context, QNameURI arrayType_, String arrayTypeAndSizeExtracted, ArrayDeserializerHandler handler) throws SOAPServiceException {
        String arrayTypeAndSize = arrayTypeAndSizeExtracted;
        boolean arrayOffSet = false;
        if (arrayTypeAndSize == null) {
            throw new PRTFaultSerializator("Type and Size of the Array not found.", (Object)this, (Exception)new IllegalArgumentException("Type and Size of the Array not found."));
        }
        QNameURI arrayType = null;
        if (arrayType_.getQName().getLocalPart().indexOf("Array") == -1 && !context.isLitteralStyleEncoding()) {
            arrayType = arrayType_;
        } else {
            int leftBracketIndex = arrayTypeAndSize.lastIndexOf(91);
            int rightBracketIndex = arrayTypeAndSize.lastIndexOf(93);
            String componentTypeName = arrayTypeAndSize.substring(0, leftBracketIndex);
            String prefixItemType = null;
            if (componentTypeName.indexOf(":") >= 0) {
                prefixItemType = componentTypeName.substring(0, componentTypeName.indexOf(":"));
                componentTypeName = componentTypeName.substring(componentTypeName.indexOf(":") + 1);
            }
            QName arrayItemType = null;
            arrayItemType = prefixItemType != null ? new QName(context.getNamespaceFromPrefix(prefixItemType), componentTypeName) : new QName(inScopeEncStyle, componentTypeName);
            arrayType = new QNameURI(arrayItemType, arrayItemType.getNamespaceURI());
        }
        String arrayTypeNamespaceURI = arrayType.getQName().getNamespaceURI();
        String arrayTypeLocalPart = arrayType.getQName().getLocalPart();
        int type = this.determinetypeArray(arrayTypeAndSize, arrayTypeLocalPart);
        switch (type) {
            case 0: {
                return this.getSOAPParameterFromSimpleArray(arrayTypeAndSize, arrayTypeNamespaceURI, arrayTypeLocalPart, inScopeEncStyle, arrayElement, context, arrayType, handler);
            }
            case 1: {
                return this.getSOAPParameterFromMatrixArray(arrayTypeAndSize, arrayTypeNamespaceURI, arrayTypeLocalPart, inScopeEncStyle, arrayElement, context, arrayType, handler);
            }
            case 2: {
                return this.getSOAPParameterFromArrayOfArray(context, arrayElement, arrayTypeAndSize, arrayType.getQName(), inScopeEncStyle, handler);
            }
        }
        return null;
    }

    private SOAPParameter getSOAPParameterFromMatrixArray(String arrayTypeAndSize, String arrayTypeNamespaceURI, String arrayTypeLocalPart, String inScopeEncStyle, SOAPElement arrayElement, ISOAPMessageContext context, QNameURI qNameUri, ArrayDeserializerHandler handler) {
        Class classType;
        int leftBracketIndex = arrayTypeAndSize.lastIndexOf(91);
        int rightBracketIndex = arrayTypeAndSize.lastIndexOf(93);
        String componentTypeName = arrayTypeAndSize.substring(0, leftBracketIndex);
        String prefixItemType = null;
        if (componentTypeName.indexOf(":") >= 0) {
            prefixItemType = componentTypeName.substring(0, componentTypeName.indexOf(":"));
            componentTypeName = componentTypeName.substring(componentTypeName.indexOf(":") + 1);
        }
        QName arrayItemType = null;
        arrayItemType = prefixItemType != null ? new QName(context.getNamespaceFromPrefix(prefixItemType), componentTypeName) : new QName(arrayTypeNamespaceURI, componentTypeName);
        int comaPosition = arrayTypeAndSize.indexOf(44);
        if (comaPosition == -1) {
            throw new PRTFaultSerializator("Type and Size Format for the matrix not recognized", (Object)this, new Exception("Type and Size Format for the matrix not recognized"));
        }
        int dimRow = Integer.parseInt(arrayTypeAndSize.substring(comaPosition - 1, comaPosition));
        int dimCol = Integer.parseInt(arrayTypeAndSize.substring(comaPosition + 1, comaPosition + 2));
        int nChilds = this.countParams(arrayElement.getChildElements());
        if (nChilds != dimRow * dimCol) {
            throw new PRTFaultSerializator("Number of elements does not match array dimension", (Object)this, new Exception("Number of elements does not match matrix dimension"));
        }
        if (inScopeEncStyle.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            inScopeEncStyle = "http://www.w3.org/2001/XMLSchema";
        }
        if ((classType = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getJavaType(arrayItemType, inScopeEncStyle)) == null) {
            throw new PRTFaultSerializator("The Array XML Schema of your SOAP Message is not supported !", (Object)this, new Exception("XML Schema not supported"));
        }
        int[] dim = new int[]{dimRow, dimCol};
        Object matrix = Array.newInstance(classType, dim);
        Iterator it = arrayElement.getChildElements();
        int i = 0;
        int j = 0;
        while (it.hasNext()) {
            SOAPDeserializer deser;
            Object obj = it.next();
            if (!(obj instanceof SOAPElement)) continue;
            SOAPElement se = XMLValueExtractor.getSOAPElementFromRef((SOAPElement)((SOAPElement)obj), (ISOAPMessageContext)context);
            QNameURI name = null;
            name = XMLValueExtractor.getQNameURIForElement((SOAPElement)se, (ISOAPMessageContext)context);
            if (name == null) {
                name = qNameUri;
            }
            if ((deser = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getDeserializer(name.getQName(), context.getEncodingStyle())) == null) {
                throw new PRTFaultSerializator("The Deserializer for " + name.getQName().getLocalPart() + " not found or not supported by the soap service!.", (Object)this, new Exception("The Deserializer for " + name.getQName().getLocalPart() + " not found or not supported by the soap service!."));
            }
            SOAPParameter sp = deser.unmarshall(name.getURI(), name.getQName(), XMLValueExtractor.getSOAPElementFromRef((SOAPElement)se, (ISOAPMessageContext)context), context);
            Object item = sp.getValue();
            Object o = Array.get(matrix, i);
            Array.set(o, j, item);
            if (++j != dimCol) continue;
            j = 0;
            ++i;
        }
        SOAPParameter res = new SOAPParameter(qNameUri.getQName(), matrix.getClass(), matrix);
        return res;
    }

    private SOAPParameter getSOAPParameterFromArrayOfArray(ISOAPMessageContext context, SOAPElement element, String arrayTypeLocalPart, QName qName, String inScopeEncStyle, ArrayDeserializerHandler handler) {
        int dimCol = Integer.parseInt(arrayTypeLocalPart.substring(arrayTypeLocalPart.length() - 2, arrayTypeLocalPart.length() - 1));
        ArrayList<Object> listArray = new ArrayList<Object>();
        Iterator it = element.getChildElements();
        Class<?> arrayClass = null;
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof SOAPElement)) continue;
            SOAPElement se = XMLValueExtractor.getSOAPElementFromRef((SOAPElement)((SOAPElement)obj), (ISOAPMessageContext)context);
            QName qname = XMLValueExtractor.getQNameForElement((SOAPElement)se, (ISOAPMessageContext)context);
            SOAPDeserializer deser = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getDeserializer(qname, context.getEncodingStyle());
            if (deser == null) {
                throw new PRTFaultSerializator("The Deserializer for " + qname.getLocalPart() + " not found or not supported by the soap service!.", (Object)this, new Exception("Deserializer not found or not supported"));
            }
            SOAPParameter sp = deser.unmarshall(context.getEncodingStyle(), qname, XMLValueExtractor.getSOAPElementFromRef((SOAPElement)se, (ISOAPMessageContext)context), context);
            Object array = sp.getValue();
            if (arrayClass == null) {
                arrayClass = array.getClass();
            }
            if (!arrayClass.equals(array.getClass())) {
                throw new PRTFaultSerializator("Class for the sub-arrays are different", (Object)this, new Exception("Class for the sub-arrays are different"));
            }
            arrayClass = array.getClass();
            listArray.add(array);
        }
        if (dimCol != listArray.size()) {
            throw new PRTFaultSerializator("Dimension for arrayOfArray does not match sub-arrays", (Object)this, new Exception("Dimension for arrayOfArray does not match sub-arrays"));
        }
        Object arrayOfArray = Array.newInstance(class$java$lang$Object == null ? (class$java$lang$Object = ArrayDeserializer.class$("java.lang.Object")) : class$java$lang$Object, dimCol);
        int i = 0;
        while (i < listArray.size()) {
            Array.set(arrayOfArray, i, listArray.get(i));
            ++i;
        }
        SOAPParameter res = new SOAPParameter(qName, arrayOfArray.getClass(), arrayOfArray);
        return res;
    }

    private SOAPParameter getSOAPParameterFromSimpleArray(String arrayTypeAndSize, String arrayTypeNamespaceURI, String arrayTypeLocalPart, String inScopeEncStyle, SOAPElement arrayElement, ISOAPMessageContext context, QNameURI arrayType, ArrayDeserializerHandler handler) {
        int offset = handler.getOffset();
        int totalSize = handler.getColumns();
        Object array = handler.getArray();
        Class[] arrayContainedClasses = handler.getClasses();
        Iterator params = null;
        params = arrayElement.getChildElements();
        boolean isArrayListBackup = context.isArrayList();
        String nameChildrenItemBackup = context.getArrayChildsName();
        int i = offset;
        while (params.hasNext()) {
            context.setArrayList(isArrayListBackup);
            context.setArrayChildsName(nameChildrenItemBackup);
            Object obj = params.next();
            if (!(obj instanceof SOAPElement)) continue;
            SOAPElement element = (SOAPElement)obj;
            if (context.isDocumentStyleEncoding() && context.isArrayList() && !element.getElementName().getLocalName().equals(context.getArrayChildsName())) continue;
            if (XMLValueExtractor.isValueNull((SOAPElement)element)) {
                Array.set(array, i, null);
            } else {
                SOAPDeserializer deser;
                SOAPElement param_ = XMLValueExtractor.getSOAPElementFromRef((SOAPElement)element, (ISOAPMessageContext)context);
                QNameURI name = null;
                name = XMLValueExtractor.getQNameURIForElement((SOAPElement)param_, (ISOAPMessageContext)context);
                if (name == null) {
                    name = arrayType;
                }
                if ((deser = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getDeserializer(name.getQName(), context.getEncodingStyle())) == null) {
                    throw new PRTFaultSerializator("The Deserializer for " + name.getQName().getLocalPart() + " not found or not supported by the soap service!.", (Object)this, new Exception("The Deserializer for " + name.getQName().getLocalPart() + " not found or not supported by the soap service!."));
                }
                SOAPParameter parameter = null;
                parameter = deser.unmarshall(name.getURI(), name.getQName(), XMLValueExtractor.getSOAPElementFromRef((SOAPElement)element, (ISOAPMessageContext)context), context);
                arrayContainedClasses[i] = parameter.getType();
                Array.set(array, i, parameter.getValue());
            }
            ++i;
        }
        SOAPParameter param = new SOAPParameter(arrayType.getQName(), array.getClass(), array);
        param.setArrayContainedClasses(arrayContainedClasses);
        return param;
    }

    private ArrayDeserializerHandler getNewArrayOfArray(ISOAPMessageContext context, SOAPElement element, String arrayTypeLocalPart, QName qName, String inScopeEncStyle) {
        int dimCol = Integer.parseInt(arrayTypeLocalPart.substring(arrayTypeLocalPart.length() - 2, arrayTypeLocalPart.length() - 1));
        Object arrayClass = null;
        Object theMainArray = Array.newInstance(class$java$lang$Object == null ? (class$java$lang$Object = ArrayDeserializer.class$("java.lang.Object")) : class$java$lang$Object, dimCol);
        Class[] classes = new Class[dimCol];
        ArrayDeserializerHandler handler = new ArrayDeserializerHandler(theMainArray, classes, false, 0, 0, 0);
        return handler;
    }

    private int extractOffSet(SOAPElement arrayElement) {
        int rightBracketIndex;
        int leftBracketIndex;
        String lengthStr;
        String offSetTag = null;
        int offset = 0;
        Iterator iter = arrayElement.getAllAttributes();
        while (iter.hasNext()) {
            Name item = (Name)iter.next();
            if (!item.getLocalName().equals("offset")) continue;
            offSetTag = arrayElement.getAttributeValue(item);
            break;
        }
        if (offSetTag != null && (lengthStr = offSetTag.substring((leftBracketIndex = offSetTag.lastIndexOf(91)) + 1, rightBracketIndex = offSetTag.lastIndexOf(93))).length() > 0) {
            offset = Integer.parseInt(lengthStr);
        }
        return offset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

