/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.admin;

import com.sapportals.portal.prt.component.AbstractPortalComponent;
import com.sapportals.portal.prt.component.IPortalComponentRequest;
import com.sapportals.portal.prt.component.IPortalComponentResponse;
import com.sapportals.portal.prt.component.IPortalComponentURI;
import com.sapportals.portal.prt.deployment.DeploymentManager;
import com.sapportals.portal.prt.deployment.descriptor.IApplication;
import com.sapportals.portal.prt.deployment.descriptor.IConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IServiceList;
import com.sapportals.portal.prt.event.IPortalRequestEvent;
import com.sapportals.portal.prt.event.IPortalRequestEventData;
import com.sapportals.portal.prt.pom.NodeMode;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.IService;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.SOAPServiceManager;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.log.ISOAPLogger;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.QNameURI;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceSerializer;
import com.sapportals.portal.prt.util.StringUtils;
import com.sapportals.portal.prt.util.html.HtmlButtonInput;
import com.sapportals.portal.prt.util.html.HtmlCell;
import com.sapportals.portal.prt.util.html.HtmlForm;
import com.sapportals.portal.prt.util.html.HtmlRow;
import com.sapportals.portal.prt.util.html.HtmlTable;
import com.sapportals.portal.prt.util.html.HtmlTextInput;
import com.sapportals.portal.prt.util.html.IHtmlOutputable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class SOAPAdmin
extends AbstractPortalComponent {
    String mm_centralConfig = "CentralConfig";
    String mm_listService = "ListService";
    String mm_logService = "LogService";
    String mm_configService = "ConfigService";
    String mm_configSerializer = "ConfigSerializer";
    String mm_configCustomSerializer = "ConfigCustomSerializer";
    String mm_saveConfigService = "SaveConfigService";
    String mm_valueToEdit = "ValueToEdit";
    String mm_editValue = "EditValue";
    String mm_saveValue = "SaveValue";
    String mm_setMainSOAP = "SetMainSOAP";
    boolean saveConfigProcess = false;
    final String EDITNAME = "EDITNAME";
    final String EDITVALUE = "EDITVALUE";

    public void doContent(IPortalComponentRequest request, IPortalComponentResponse response) {
        HtmlTable topContainer = new HtmlTable();
        topContainer.setClass("gSAPinputbutton");
        topContainer.setWidth("100%");
        topContainer.addElement("<tr><td>");
        HtmlRow sepRow = new HtmlRow();
        sepRow.addElement((IHtmlOutputable)new HtmlCell().addElement("&nbsp;<br>"));
        this.addTopButton(request, topContainer);
        this.addCentralConfig(request, topContainer);
        this.addListService(request, topContainer);
        this.addCentralInfo(request, topContainer);
        this.addCustomSerInfo(request, topContainer);
        topContainer.addElement("</td></tr>");
        topContainer.output(response.getWriter());
    }

    private void addCentralInfo(IPortalComponentRequest request, HtmlTable container) {
        String action = (String)request.getNode().getValue("lastAction");
        if (action != null && action.equals(this.mm_configSerializer)) {
            HtmlForm componentForm = new HtmlForm();
            container.addElement((IHtmlOutputable)componentForm);
            HtmlTable listComponentTable = new HtmlTable();
            componentForm.addElement((IHtmlOutputable)listComponentTable);
            listComponentTable.setClass("gsaptable");
            listComponentTable.addElement("<tr class=\"gsaptr\">");
            listComponentTable.addElement("<th class=\"gsapth\" colspan=\"5\"><div align=\"center\">List_Serializers_loaded</div></td>");
            listComponentTable.addElement("</tr>");
            listComponentTable.addElement("<tr class=\"gsaptr\">");
            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>Key URI</b></td>");
            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>LocalPart</b></td>");
            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>URI</b></td>");
            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>Serializer</b></td>");
            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>Dezerializer</b></td>");
            listComponentTable.addElement("</tr>");
            Hashtable listSerializers = SOAPRegistry.getInstance().getListQName();
            Enumeration enumeration = listSerializers.keys();
            Object[] localPartSorted = new String[listSerializers.size()];
            int ind = 0;
            Hashtable<QNameURI, String> listSorted = new Hashtable<QNameURI, String>();
            while (enumeration.hasMoreElements()) {
                String className = (String)enumeration.nextElement();
                QName qname = (QName)listSerializers.get(className);
                localPartSorted[ind++] = qname.getLocalPart();
                listSorted.put(new QNameURI(qname, className), className);
            }
            Arrays.sort(localPartSorted);
            int index = 0;
            while (index < localPartSorted.length) {
                Object key = localPartSorted[index];
                String className = null;
                QName qname = null;
                Enumeration enum1 = listSorted.keys();
                while (enum1.hasMoreElements()) {
                    QNameURI item = (QNameURI)enum1.nextElement();
                    if (!item.getQName().getLocalPart().equals(key)) continue;
                    className = (String)listSorted.remove(item);
                    qname = item.getQName();
                }
                if (qname != null && className != null) {
                    SOAPSerializer serObject;
                    String namespace = qname.getNamespaceURI();
                    SOAPDeserializer derObject = SOAPRegistry.getInstance().getDeserializer(qname, namespace);
                    if (derObject == null) {
                        int i = 0;
                        while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length) {
                            derObject = SOAPRegistry.getInstance().getDeserializer(qname, ISOAPParamConstants.NS_URIS_SCHEMAS[i]);
                            if (derObject != null) {
                                namespace = ISOAPParamConstants.NS_URIS_SCHEMAS[i];
                                i = ISOAPParamConstants.NS_URIS_SCHEMAS.length;
                            }
                            ++i;
                        }
                    }
                    if ((serObject = SOAPRegistry.getInstance().getSerializer(SOAPRegistry.getInstance().getJavaType(qname, qname.getNamespaceURI()), qname.getNamespaceURI())) == null) {
                        int i = 0;
                        while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length) {
                            serObject = SOAPRegistry.getInstance().getSerializer(SOAPRegistry.getInstance().getJavaType(qname, ISOAPParamConstants.NS_URIS_SCHEMAS[i]), ISOAPParamConstants.NS_URIS_SCHEMAS[i]);
                            if (serObject != null) {
                                i = ISOAPParamConstants.NS_URIS_SCHEMAS.length;
                            }
                            ++i;
                        }
                    }
                    String ser = "";
                    if (serObject != null) {
                        ser = serObject.getClass().toString();
                    }
                    String deser = "";
                    if (derObject != null) {
                        deser = derObject.getClass().toString();
                    }
                    this.addLineInTable(listComponentTable, className, qname.getLocalPart(), namespace, ser, deser);
                }
                ++index;
            }
        }
    }

    private void addCustomSerInfo(IPortalComponentRequest request, HtmlTable container) {
        String action = (String)request.getNode().getValue("lastAction");
        if (action != null && action.equals(this.mm_configCustomSerializer)) {
            HtmlTable listComponentTable = new HtmlTable();
            listComponentTable.setWidth("90%");
            IApplication[] listApplication = DeploymentManager.getInstance().getApplications();
            int i = 0;
            while (i < listApplication.length) {
                IApplication application = listApplication[i];
                IServiceList listService = application.getServices();
                int j = 0;
                while (j < listService.getLength()) {
                    com.sapportals.portal.prt.deployment.descriptor.IService iservice = listService.item(j);
                    String nameservice = iservice.getName();
                    IService service = null;
                    ISpecializedRegistry registry = null;
                    try {
                        service = PortalRuntime.getRuntimeResources().getService(iservice.getAlias());
                    }
                    catch (Exception e) {
                        try {
                            service = PortalRuntime.getRuntimeResources().getService(application.getName() + "." + nameservice);
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                    try {
                        registry = SOAPServiceManager.getInstance().getSpecializedRegistry(nameservice, service.getContext());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    registry = SOAPRegistry.getInstance().getSpecializedRegistry(nameservice);
                    if (registry != null) {
                        IPortalSOAPConfig soapConfig = registry.getSOAPConfig();
                        try {
                            IPortalWebService ws = soapConfig.getPortalWebService(nameservice);
                            Enumeration enumeration = ws.getAllPortalWebServiceSerializers();
                            listComponentTable.setClass("gsaptable");
                            listComponentTable.addElement("<tr class=\"gsaptr\">");
                            listComponentTable.addElement("<th class=\"gsapth\" colspan=\"5\"><div align=\"center\">List_Serializers_for_" + nameservice + "</div>");
                            listComponentTable.addElement("</tr>");
                            listComponentTable.addElement("<tr class=\"gsaptr\">");
                            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>Name</b></td>");
                            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>LocalPart</b></td>");
                            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>NameSpace</b></td>");
                            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>Java Type</b></td>");
                            listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>Serializer</b></td>");
                            listComponentTable.addElement("</tr>");
                            while (enumeration.hasMoreElements()) {
                                IPortalWebServiceSerializer key = (IPortalWebServiceSerializer)enumeration.nextElement();
                                listComponentTable.addElement("<tr class=\"gsaptr\"><font size=\"1\">");
                                listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>" + this.splitString(key.getName()) + "</b></td>");
                                listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>" + this.splitString(key.getLocalpart()) + "</b></td>");
                                listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>" + this.splitString(key.getNamespace()) + "</b></td>");
                                listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>" + this.splitString(key.getJavatype()) + "</b></td>");
                                listComponentTable.addElement("<td class=\"gsaptd\" align=\"center\"><b>" + this.splitString(key.getSerializer()) + "</b></td>");
                                listComponentTable.addElement("</font></tr>");
                            }
                            container.addElement((IHtmlOutputable)listComponentTable);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private String splitString(String value) {
        StringBuffer sb = new StringBuffer();
        String car = "<br/>";
        int crIndice = 30;
        int c = 46;
        int taille = value.length();
        int pos = crIndice;
        int deb = 0;
        if (taille > crIndice) {
            String sub;
            while (pos < taille) {
                sub = value.substring(deb, pos);
                int j = sub.lastIndexOf(c);
                if (j == -1) {
                    j = crIndice - 1;
                }
                sb.append(value.substring(deb, j + deb + 1));
                sb.append(car);
                deb += j + 1;
                pos += j + 1;
            }
            sub = value.substring(deb, taille);
            sb.append(sub);
            return sb.toString();
        }
        return value;
    }

    private void addLineInTable(HtmlTable table, String key, String name, String namespace, String ser, String deser) {
        table.addElement("<tr class=\"gsaptr\">");
        table.addElement("<td class=\"gsaptd\">" + key + "</td>");
        table.addElement("<td class=\"gsaptd\">" + name + "</td>");
        table.addElement("<td class=\"gsaptd\">" + namespace + "</td>");
        table.addElement("<td class=\"gsaptd\">" + (ser.indexOf("soap.") != -1 ? ser.substring(ser.indexOf("soap.")) : ser) + "</td>");
        table.addElement("<td class=\"gsaptd\">" + (deser.indexOf("soap.") != -1 ? deser.substring(deser.indexOf("soap.")) : deser) + "</td>");
        table.addElement("</tr>");
    }

    private void addConfigService(IPortalComponentRequest request, HtmlTable container) {
        HtmlForm componentForm = new HtmlForm();
        container.addElement((IHtmlOutputable)componentForm);
        HtmlTable listComponentTable = new HtmlTable();
        componentForm.addElement((IHtmlOutputable)listComponentTable);
        listComponentTable.addElement("<tr class=\"gsaptd\"><td>");
        listComponentTable.addElement("<tr class=\"gsapthead\"><th>");
        listComponentTable.addElement("Config_Service");
        listComponentTable.addElement("</th></tr>");
        listComponentTable.addElement("<tr class=\"gsaptd\">");
    }

    private void addLogService(IPortalComponentRequest request, HtmlTable container) {
        String action = (String)request.getNode().getValue("lastAction");
        if (action != null && action.equals(this.mm_logService)) {
            HtmlForm componentForm = new HtmlForm();
            container.addElement((IHtmlOutputable)componentForm);
            HtmlTable listComponentTable = new HtmlTable();
            componentForm.addElement((IHtmlOutputable)listComponentTable);
            listComponentTable.addElement("<tr class=\"gsaptd\">");
            listComponentTable.addElement("<th class=\"gsapthead\">");
            ISOAPLogger log = SOAPServiceManager.getInstance().getSoaplogger();
            if (log != null) {
                listComponentTable.addElement("Log " + log.getPathFile());
            } else {
                listComponentTable.addElement("</th></tr>");
            }
            listComponentTable.addElement("<tr class=\"gsaptd\"><td>");
            if (log != null) {
                String content = log.getContentLog();
                listComponentTable.addElement(this.createTableLog(content) + "</td></tr>");
            } else {
                listComponentTable.addElement("</td></tr>");
            }
        }
    }

    private HtmlTable createTableLog(String content) {
        HtmlTable listComponentTable = new HtmlTable();
        listComponentTable.setClass("gSAPGroup");
        listComponentTable.setCellSpacing("8");
        listComponentTable.setWidth("100%");
        StringTokenizer parser = new StringTokenizer(content, "*#*");
        listComponentTable.addElement("<tr class=\"gsaptr\">");
        listComponentTable.addElement("<td  class=\"gsaptd\" align=\"center\"><b>Date</b></td>");
        listComponentTable.addElement("<td  class=\"gsaptd\" align=\"center\"><b>Actor</b></td>");
        listComponentTable.addElement("<td  class=\"gsaptd\" align=\"center\"><b>Message</b></td>");
        listComponentTable.addElement("</tr>");
        while (parser.hasMoreTokens()) {
            String lineFull = parser.nextToken();
            listComponentTable.addElement("<tr>");
            if (lineFull.indexOf("]") >= 0) {
                String date = lineFull.substring(0, lineFull.indexOf("]") + 1);
                listComponentTable.addElement("<td class=\"gsaptd\">" + date + "</td>");
            } else {
                listComponentTable.addElement("<td class=\"gsaptd\"></td>");
            }
            if (lineFull.indexOf("from") >= 0) {
                String actor = lineFull.substring(lineFull.indexOf("from") + 4, lineFull.indexOf(":", lineFull.indexOf("from")));
                listComponentTable.addElement("<td class=\"gsaptd\">" + actor + "</td>");
            } else {
                listComponentTable.addElement("<td class=\"gsaptd\"></td>");
            }
            String line = null;
            line = lineFull.indexOf(":") >= 0 ? lineFull.substring(lineFull.indexOf(":", lineFull.indexOf("from")) + 1) : lineFull;
            listComponentTable.addElement("<td  class=\"gsaptd\" align=\"right\">");
            StringTokenizer parserLeftSup = new StringTokenizer(line, "<");
            StringBuffer msgReformated = new StringBuffer();
            while (parserLeftSup.hasMoreTokens()) {
                msgReformated.append(parserLeftSup.nextToken());
                msgReformated.append("&lt;");
            }
            StringTokenizer parserRightSup = new StringTokenizer(msgReformated.toString(), ">");
            msgReformated = new StringBuffer();
            while (parserRightSup.hasMoreTokens()) {
                msgReformated.append(parserRightSup.nextToken());
                msgReformated.append("&gt;");
            }
            listComponentTable.addElement(msgReformated.toString() + "</td>");
            listComponentTable.addElement("</tr>");
        }
        return listComponentTable;
    }

    private void addListService(IPortalComponentRequest request, HtmlTable container) {
        String action = (String)request.getNode().getValue("lastAction");
        if (action != null && action.equals(this.mm_listService)) {
            HtmlForm componentForm = new HtmlForm();
            container.addElement((IHtmlOutputable)componentForm);
            HtmlTable listComponentTable = new HtmlTable();
            componentForm.addElement((IHtmlOutputable)listComponentTable);
            listComponentTable.addElement("<tr class=\"gsaptd\">");
            listComponentTable.addElement("<td class=\"gsapthead\">");
            listComponentTable.addElement("List_Web_Service");
            listComponentTable.addElement("</td><td class=\"gsapthead\" >WebEnable</td><td class=\"gsapthead\">WebProxy</td><td class=\"gsapthead\">WSDL</td></tr>");
            listComponentTable.addElement("<tr class=\"gsaptd\">");
            IApplication[] listApplication = DeploymentManager.getInstance().getApplications();
            int i = 0;
            while (i < listApplication.length) {
                IApplication application = listApplication[i];
                IServiceList listService = application.getServices();
                int j = 0;
                while (j < listService.getLength()) {
                    com.sapportals.portal.prt.deployment.descriptor.IService iservice = listService.item(j);
                    String name = iservice.getName();
                    String alias = iservice.getAlias();
                    String applicationName = application.getName();
                    IConfiguration config = iservice.getConfiguration();
                    String value = config.getPropertyValue("WebEnable");
                    if (value != null && value.equals("true")) {
                        try {
                            IService service = PortalRuntime.getRuntimeResources().getService(alias);
                            String wsdlfile = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), name, "rpc_enc");
                            String wsdlParam = null;
                            if (wsdlfile != null) {
                                wsdlParam = wsdlfile;
                            }
                            this.addLineInTable(listComponentTable, alias, value, config.getPropertyValue("WebProxy"), wsdlParam);
                        }
                        catch (Exception ex) {
                            try {
                                IService service = PortalRuntime.getRuntimeResources().getService(applicationName + "." + name);
                                String wsdlfile = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), name, "rpc_enc");
                                String wsdlParam = null;
                                if (wsdlfile != null) {
                                    wsdlParam = wsdlfile;
                                }
                                this.addLineInTable(listComponentTable, applicationName + "." + name, value, config.getPropertyValue("WebProxy"), wsdlParam);
                            }
                            catch (Exception ex1) {
                                // empty catch block
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void addEditCentralConfig(IPortalComponentRequest request, HtmlTable container) {
        String action = (String)request.getNode().getValue("lastAction");
        if (action != null && action.equals(this.mm_editValue)) {
            HtmlForm componentForm = new HtmlForm();
            container.addElement((IHtmlOutputable)componentForm);
            HtmlTable listComponentTable = new HtmlTable();
            componentForm.addElement((IHtmlOutputable)listComponentTable);
            listComponentTable.addElement("<tr class=\"gsaptd\"><td>");
            listComponentTable.addElement("<tr class=\"gsapthead\"><th>");
            listComponentTable.addElement("Edit_Value");
            listComponentTable.addElement("</th></tr>");
            listComponentTable.addElement("<tr class=\"gsaptd\">");
            HtmlForm logRootForm = new HtmlForm();
            listComponentTable.addElement((IHtmlOutputable)logRootForm);
            String name = (String)request.getNode().getValue(this.mm_valueToEdit);
            listComponentTable.addElement("<td class=\"gsapthead\">");
            listComponentTable.addElement("<input name=\"EDITNAME\" type=\"text\" id=\"" + name + "\" size=\"50\" value=\"" + (name != null ? name : "") + "\">");
            listComponentTable.addElement("</td>");
            Properties prop = SOAPServiceManager.getInstance().getMainSOAPServiceInstance();
            String value = prop.getProperty(name);
            HtmlTextInput input = new HtmlTextInput();
            input.setValue(value);
            input.setSize(value.length());
            input.setName("EDITVALUE");
            listComponentTable.addElement("<td>");
            listComponentTable.addElement((IHtmlOutputable)input);
            listComponentTable.addElement("</td>");
            listComponentTable.addElement("<td>");
            IPortalRequestEventData relData = request.createRequestEventData();
            relData.add("key", name);
            IPortalRequestEvent relEvent = request.createRequestEvent(this.mm_saveValue, relData);
            IPortalComponentURI componentURI = request.createPortalComponentURI();
            componentURI.setPortalRequestEvent(relEvent);
            componentURI.setTargetNode(request.getNode());
            listComponentTable.addElement("&nbsp;");
            listComponentTable.addElement(" (<a href=\"" + componentURI + "\">" + "save" + "</a>)");
            listComponentTable.addElement("</td>");
        }
    }

    private void addCentralConfig(IPortalComponentRequest request, HtmlTable container) {
        String action = (String)request.getNode().getValue("lastAction");
        if (action != null && action.equals(this.mm_centralConfig)) {
            HtmlForm componentForm = new HtmlForm();
            container.addElement((IHtmlOutputable)componentForm);
            HtmlTable listComponentTable = new HtmlTable();
            componentForm.addElement((IHtmlOutputable)listComponentTable);
            listComponentTable.addElement("<tr class=\"gsaptd\"><td>");
            listComponentTable.addElement("<tr class=\"gsapthead\"><th>");
            listComponentTable.addElement("List_Web_Service_Config");
            listComponentTable.addElement("</th></tr>");
            listComponentTable.addElement("<tr class=\"gsaptd\">");
            Properties prop = SOAPServiceManager.getInstance().getMainSOAPServiceInstance();
            Enumeration<?> enumeration = null;
            if (prop != null) {
                enumeration = prop.propertyNames();
            }
            HtmlButtonInput mainPropertiesButton = new HtmlButtonInput();
            IPortalRequestEvent mainPropertiesEvent = request.createRequestEvent(this.mm_setMainSOAP);
            IPortalComponentURI componentURI = request.createPortalComponentURI();
            componentURI.setPortalRequestEvent(mainPropertiesEvent);
            componentURI.setTargetNode(request.getNode());
            mainPropertiesButton.setValue("Set_This_PRT_as_Main");
            mainPropertiesButton.setOnClick("window.navigate('" + componentURI + "');");
            mainPropertiesButton.setClass("gSAPInputButton");
            listComponentTable.addElement((IHtmlOutputable)mainPropertiesButton);
            listComponentTable.addElement("&nbsp");
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    listComponentTable.addElement("<tr>");
                    listComponentTable.addElement("<td class=\"gsapthead\">" + name + "</td>");
                    String value = prop.getProperty(name);
                    listComponentTable.addElement("<td class=\"gsapthead\">" + value + "</td>");
                    listComponentTable.addElement("<td>");
                    IPortalRequestEventData relData = request.createRequestEventData();
                    relData.add("key", name);
                    IPortalRequestEvent relEvent = request.createRequestEvent("EditValue", relData);
                    componentURI = request.createPortalComponentURI();
                    componentURI.setPortalRequestEvent(relEvent);
                    componentURI.setTargetNode(request.getNode());
                    listComponentTable.addElement("&nbsp;");
                    listComponentTable.addElement(" (<a href=\"" + componentURI + "\">" + "edit" + "</a>)");
                    listComponentTable.addElement("</td></tr>");
                }
            }
        }
    }

    private void addLineInTable(HtmlTable table, String header, String value, String webproxy, String wsdlparam) {
        table.addElement("<td class=\"gsapthead\">" + header + "</td>");
        table.addElement("<td class=\"gsapthead\">" + value + "</td>");
        if (webproxy != null) {
            table.addElement("<td class=\"gsapthead\">" + webproxy + "</td>");
        } else {
            table.addElement("<td class=\"gsapthead\"> Not Present</td>");
        }
        if (wsdlparam != null) {
            String link = null;
            link = header.indexOf(":") >= 0 ? "/irj/servlet/prt/soap/" + header.replace(':', '.') + "?wsdl" : "/irj/servlet/prt/soap/" + header + "?wsdl";
            table.addElement("<td class=\"gsapthead\">");
            table.addElement("<a class=\"gSAPAsel:hover\" href=\"" + link + "\" target=\"_blank\">Present</a>");
            table.addElement("</td>");
        } else {
            table.addElement("<td class=\"gsapthead\">Not Present</td>");
        }
        table.addElement("</tr>");
    }

    private void addTopButton(IPortalComponentRequest request, HtmlTable container) {
        HtmlForm componentForm = new HtmlForm();
        container.addElement((IHtmlOutputable)componentForm);
        HtmlTable listComponentTable = new HtmlTable();
        listComponentTable.setClass("gSAPGroup");
        componentForm.addElement((IHtmlOutputable)listComponentTable);
        listComponentTable.setWidth("100%");
        listComponentTable.addElement("<tr> <td> ");
        this.constructButton(request, listComponentTable, this.mm_listService, "List Services");
        this.constructButton(request, listComponentTable, this.mm_configService, "Configuration");
        this.constructButton(request, listComponentTable, this.mm_configSerializer, "List Serializers");
        this.constructButton(request, listComponentTable, this.mm_configCustomSerializer, "List Custom Serializers");
        listComponentTable.addElement("</td></tr>");
        String action = (String)request.getNode().getValue("lastAction");
        if (action != null) {
            listComponentTable.addElement("<tr><td class=\"gSAPTHead\">Previous_action : " + StringUtils.escapeToHTML((String)action) + "</td></tr>");
        }
    }

    private void constructButton(IPortalComponentRequest request, HtmlTable table, String nameAction, String text) {
        HtmlButtonInput propertiesButton = new HtmlButtonInput();
        IPortalRequestEvent propertiesEvent = request.createRequestEvent(nameAction);
        IPortalComponentURI componentURI = request.createPortalComponentURI();
        componentURI.setPortalRequestEvent(propertiesEvent);
        componentURI.setTargetNode(request.getNode());
        propertiesButton.setValue(text);
        propertiesButton.setOnClick("window.navigate('" + componentURI + "');");
        propertiesButton.setClass("gSAPInputButton");
        table.addElement((IHtmlOutputable)propertiesButton);
        table.addElement("&nbsp");
    }

    public void doCentralConfig(IPortalComponentRequest request, IPortalRequestEvent event) {
        request.getNode().putValue("lastAction", (Object)this.mm_centralConfig);
    }

    public void doConfigCustomSerializer(IPortalComponentRequest request, IPortalRequestEvent event) {
        request.getNode().putValue("lastAction", (Object)this.mm_configCustomSerializer);
    }

    public void doListService(IPortalComponentRequest request, IPortalRequestEvent event) {
        request.getNode().putValue("lastAction", (Object)this.mm_listService);
    }

    public void doLogService(IPortalComponentRequest request, IPortalRequestEvent event) {
        request.getNode().putValue("lastAction", (Object)this.mm_logService);
    }

    public void doConfigService(IPortalComponentRequest request, IPortalRequestEvent event) {
        request.getNode().putValue("lastAction", (Object)this.mm_configService);
        this.saveConfigProcess = false;
        request.getNode().setNodeMode(NodeMode.CONFIG_MODE);
    }

    public void doConfigSerializer(IPortalComponentRequest request, IPortalRequestEvent event) {
        request.getNode().putValue("lastAction", (Object)this.mm_configSerializer);
    }

    public void doEditValue(IPortalComponentRequest request, IPortalRequestEvent event) {
        String editParam;
        IPortalRequestEventData data = event.getData();
        if (data != null && (editParam = data.getAttribute("key")) != null) {
            request.getNode().putValue(this.mm_valueToEdit, (Object)editParam);
            request.getNode().putValue("lastAction", (Object)this.mm_editValue);
        }
    }

    public void doSaveValue(IPortalComponentRequest request, IPortalRequestEvent event) {
        IPortalRequestEventData data = event.getData();
        if (data != null) {
            String nameParam = data.getAttribute("EDITNAME");
            String valueParam = data.getAttribute("EDITVALUE");
            if (nameParam != null) {
                request.getNode().putValue("lastAction", (Object)this.mm_centralConfig);
                SOAPServiceManager.getInstance().setCentralValueConfig(nameParam, valueParam);
            }
        }
    }

    public void doSetMainSOAP(IPortalComponentRequest request, IPortalRequestEvent event) {
        request.getNode().putValue("lastAction", (Object)this.mm_centralConfig);
        String url = "http://" + request.getServletRequest().getServerName() + ":" + request.getServletRequest().getServerPort() + "/irj/servlet/prt/soap";
        SOAPServiceManager.getInstance().setCentralValueConfig("mainPRT", url);
    }
}

