/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFault;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.QNameURI;
import com.sapportals.portal.prt.service.soap.util.XMLValueExtractor;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceParameter;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;

public class ParamsProcessor {
    static ParamsProcessor mm_instance = null;

    public static ParamsProcessor getInstance() {
        if (mm_instance == null) {
            mm_instance = new ParamsProcessor();
        }
        return mm_instance;
    }

    public static void destroy() {
        mm_instance = null;
    }

    public boolean checkParam() {
        return true;
    }

    public SOAPParameter getSOAPParameter(SOAPElement element, QNameURI qnameURI, ISOAPMessageContext context) throws SOAPServiceException {
        SOAPParameter param = null;
        SOAPBodyElement multiref = null;
        try {
            Name nameRef = XMLValueExtractor.getNameForReference((SOAPElement)element, (ISOAPMessageContext)context);
            if (nameRef != null) {
                SOAPDeserializer deserial;
                QName qName = null;
                String key = element.getAttributeValue(nameRef);
                int index = key.indexOf("#");
                if (index != -1) {
                    key = key.substring(index + 1);
                }
                multiref = context.getId(key);
                qName = XMLValueExtractor.getQNameForElement((SOAPElement)multiref, (ISOAPMessageContext)context);
                String encodingStyle = multiref.getEncodingStyle();
                if (encodingStyle == null) {
                    encodingStyle = context.getEncodingStyle();
                }
                if (encodingStyle.trim().equals("")) {
                    encodingStyle = context.getEncodingStyle();
                }
                if ((deserial = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getDeserializer(qName, encodingStyle)) == null) {
                    throw new PRTFaultSerializator("The Deserializer for " + qName.getLocalPart() + " not found or not supported by the soap service!.", (Object)this, new Exception("Deserializer not found or not supported"));
                }
                Iterator iter = multiref.getAllAttributes();
                Name type = null;
                while (iter.hasNext()) {
                    Name item = (Name)iter.next();
                    if (item.getLocalName().equals("type")) {
                        type = item;
                        break;
                    }
                    if (!item.getLocalName().equals("arrayType")) continue;
                    type = item;
                }
                param = deserial.unmarshall(type.getURI(), qName, (SOAPElement)multiref, context);
            } else {
                SOAPDeserializer deserial;
                String encodingStyle = element.getEncodingStyle();
                if (encodingStyle == null) {
                    encodingStyle = context.getEncodingStyle();
                }
                if (encodingStyle.trim().equals("")) {
                    encodingStyle = context.getEncodingStyle();
                }
                if (context.isDocumentStyleEncoding()) {
                    encodingStyle = qnameURI.getURI();
                }
                if ((deserial = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getDeserializer(qnameURI.getQName(), encodingStyle)) == null) {
                    encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
                    deserial = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getDeserializer(qnameURI.getQName(), encodingStyle);
                }
                if (deserial == null) {
                    throw new PRTFaultSerializator("The Deserializer for " + qnameURI.getQName().getLocalPart() + " not found or not supported by the soap service!.", (Object)this, new Exception("Deserializer not found or not supported"));
                }
                param = deserial.unmarshall(qnameURI.getURI(), qnameURI.getQName(), element, context);
            }
        }
        catch (PRTFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new PRTFaultSerializator((Object)this, e);
        }
        return param;
    }

    public boolean validateParam(SOAPElement element, Name name) {
        return false;
    }

    public void marshall(Class typeObjectToSerialize, SOAPEnvelope envelope, SOAPElement parentBodyElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context) throws Exception {
        SOAPSerializer ser;
        String targetNamespace = null;
        if (context.isResponse()) {
            try {
                targetNamespace = context.getMethodContainer().getWebserviceMethod_config().getReturnPortalWebServiceParameter().getTargetNamespace();
            }
            catch (Exception e) {
                try {
                    targetNamespace = context.getServiceDescriptor().getContextRequest().getMethodContainer().getWebserviceMethod_config().getReturnPortalWebServiceParameter().getTargetNamespace();
                }
                catch (Exception e1) {}
            }
        } else {
            Enumeration enumeration = context.getMethodContainer().getWebserviceMethod_config().getPortalWebServiceParameters();
            while (enumeration.hasMoreElements()) {
                IPortalWebServiceParameter element = (IPortalWebServiceParameter)enumeration.nextElement();
                if (!element.getName().equals(nameParam)) continue;
                targetNamespace = element.getTargetNamespace();
            }
        }
        if ((ser = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getSerializer(typeObjectToSerialize, targetNamespace)) == null) {
            throw new PRTFaultSerializator("The Serializer for " + typeObjectToSerialize + " not found or not supported by the soap service!.", (Object)this, new Exception("Serializer not found or not supported"));
        }
        if (context.isDocumentStyleEncoding()) {
            QName qname_doc = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getElementType(typeObjectToSerialize, targetNamespace);
            String nameElement = null;
            String tnsElement = null;
            if (context.getMethodContainer() != null && context.getMethodContainer().getWebserviceMethod_config() != null) {
                IPortalWebServiceMethod method_config = context.getMethodContainer().getWebserviceMethod_config();
                if (context.isResponse()) {
                    nameElement = method_config.getReturnPortalWebServiceParameter().getNameElement();
                    tnsElement = method_config.getReturnPortalWebServiceParameter().getTargetNamespaceElement();
                } else {
                    Enumeration enumeration = context.getMethodContainer().getWebserviceMethod_config().getPortalWebServiceParameters();
                    while (enumeration.hasMoreElements()) {
                        IPortalWebServiceParameter element = (IPortalWebServiceParameter)enumeration.nextElement();
                        if (!element.getName().equals(nameParam)) continue;
                        nameElement = element.getNameElement();
                        tnsElement = element.getTargetNamespaceElement();
                    }
                }
            }
            if (nameElement == null) {
                throw new PRTFaultSerializator("The Serializer for " + typeObjectToSerialize + " aborted because the element name was not found in the configuration!.", (Object)this, new Exception("The Serializer for " + typeObjectToSerialize + " aborted because the element name was not found in the configuration!."));
            }
            if (tnsElement == null) {
                throw new PRTFaultSerializator("The Serializer for " + typeObjectToSerialize + " aborted because the tns element was not found in the configuration!.", (Object)this, new Exception("The Serializer for " + typeObjectToSerialize + " aborted because the tns element was not found in the configuration!."));
            }
            context.setTargetNamespaceMethod(tnsElement);
            if (context.isResponse()) {
                ser.marshall(targetNamespace, typeObjectToSerialize, envelope, parentBodyElement, objectToSerialize, nameElement, context);
            } else {
                ser.marshall(targetNamespace, typeObjectToSerialize, envelope, parentBodyElement, objectToSerialize, nameElement, context);
            }
        } else {
            ser.marshall(targetNamespace, typeObjectToSerialize, envelope, parentBodyElement, objectToSerialize, nameParam, context);
        }
    }
}

