/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.soap.IPRTSOAPProxy;
import com.sapportals.portal.prt.service.soap.IPRTSOAPSerializator;
import com.sapportals.portal.prt.service.soap.ISOAPService;
import com.sapportals.portal.prt.service.soap.IServiceDescriptor;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.SOAPServiceManager;
import com.sapportals.portal.prt.service.soap.ServiceDescriptor;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBody;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBodyElement;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.util.IMessageDescriptor;
import com.sapportals.portal.prt.service.soap.util.MessageDescriptor;
import com.sapportals.portal.prt.service.soap.util.XMLAttributeHandler;
import java.util.Hashtable;
import javax.xml.soap.SOAPMessage;

public class PRTSOAPProxy
implements IPRTSOAPProxy {
    String mm_url = null;
    String mm_serviceName = null;
    String mm_namespaceURI = null;
    ISOAPService mm_service = null;
    IPRTSOAPSerializator mm_serializator = null;

    public PRTSOAPProxy(String url, String serviceName, String namespaceURI, ISOAPService soapService) {
        this.mm_service = soapService;
        this.mm_url = url;
        this.mm_serviceName = serviceName;
        this.mm_namespaceURI = namespaceURI;
        this.mm_serializator = this.mm_service.getSerializator();
    }

    public Object invokeMethod(String methodName, XMLAttributeHandler params) {
        MessageDescriptor descriptor = new MessageDescriptor(methodName, params, this.mm_namespaceURI);
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor(this.mm_serviceName, SOAPServiceManager.getInstance().getSpecializedRegistry(this.mm_serviceName, this.mm_service.getContext()));
        SOAPMessage message = this.generateMessage(descriptor, serviceDescriptor);
        IPRTSOAPMessage prtMessage = this.mm_service.call(message, this.mm_url + "/" + this.mm_serviceName, (IServiceDescriptor)serviceDescriptor);
        Object result = null;
        try {
            result = this.translate(prtMessage, methodName);
        }
        catch (Exception ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "Invoke Method failed", ex);
            }
            return null;
        }
        return result;
    }

    private SOAPMessage generateMessage(IMessageDescriptor descriptor, IServiceDescriptor serviceDescriptor) {
        SOAPMessage message = this.mm_serializator.constructSOAPMessage(this.mm_service.getMsgFactory(), descriptor, serviceDescriptor);
        return message;
    }

    private Object translate(IPRTSOAPMessage msg, String namemethod) {
        try {
            XMLAttributeHandler xmlhandler;
            IPRTSOAPBody bdy = msg.getEnveloppe().getBody();
            Hashtable listBody = bdy.getListOfBodyElements();
            IPRTSOAPBodyElement bdyElement = (IPRTSOAPBodyElement)listBody.get(namemethod + "Response");
            if (bdyElement != null && (xmlhandler = bdyElement.getAttributeHandler()) != null) {
                SOAPParameter response = xmlhandler.getAttributeValue("response");
                if (response != null) {
                    return response.getValue();
                }
                response = xmlhandler.getAttributeValue("return");
                if (response != null) {
                    return response.getValue();
                }
                if (xmlhandler.getAttributesName().hasMoreElements()) {
                    String name = (String)xmlhandler.getAttributesName().nextElement();
                    response = xmlhandler.getAttributeValue(name);
                    return response.getValue();
                }
            }
        }
        catch (Exception ex) {
            ILogger logger = PortalRuntime.getLogger();
            if (logger != null && logger.isActive()) {
                logger.warning((Throwable)ex, this.getClass().getName() + " ERROR : Translate failed");
            }
            return null;
        }
        return null;
    }
}

