/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.ui;

import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WebDynproTopPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final String SETTING_NAME_CLASSES_AS_ARCHIVE = "classes_as_archive";
    private Button mClassesAsArchiveCheckBox = null;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        IGridLayoutPane settingsPane = PaneFactory.createGridLayoutPane((Composite)root, (int)2);
        IGridLayoutData gd = settingsPane.createGridLayoutData(4, 1, true, false);
        this.mClassesAsArchiveCheckBox = settingsPane.addCheckBox(mTextPool.getText(41), true, gd);
        this.mClassesAsArchiveCheckBox.setVisible(false);
        settingsPane.getComposite().addMouseListener(new MouseListener(){
            int counter = 0;

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    ++this.counter;
                    if (this.counter > 10) {
                        WebDynproTopPreferencePage.this.mClassesAsArchiveCheckBox.setVisible(true);
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.initializeValues();
        return root;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ArchiveBuilderPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        this.storeValues();
        return super.performOk();
    }

    protected void performApply() {
        this.storeValues();
        super.performApply();
    }

    protected void performDefaults() {
        this.initializeDefaults();
        super.performDefaults();
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.mClassesAsArchiveCheckBox.setSelection(store.getBoolean(SETTING_NAME_CLASSES_AS_ARCHIVE));
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(SETTING_NAME_CLASSES_AS_ARCHIVE, this.mClassesAsArchiveCheckBox.getSelection());
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.mClassesAsArchiveCheckBox.setSelection(store.getDefaultBoolean(SETTING_NAME_CLASSES_AS_ARCHIVE));
    }
}

