/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.ui;

import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.metamodel.core.dc.DevComponentService;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.ui.service.ServicesUI;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Property;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class GenerationPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String OPTIMIZE_TEXT_NO = "no";
    private static final String OPTIMIZE_TEXT_AUTO = "auto";
    private static final int OPTIMIZE_TEXT_DEFAULT_INDEX = 0;
    private static final int OPTIMIZE_TEXT_NO_INDEX = 0;
    private static final int OPTIMIZE_TEXT_AUTO_INDEX = 0;
    private static final String[] OPTIMIZE_TEXTS = new String[]{"no", "auto"};
    private static final String PROPERTY_OPTIMIZE_BYTE_CODE_NAME = "minimizeClassFiles";
    private static final String PROPERTY_OPTIMIZE_BYTE_CODE_NAMESPACE = "http://xml.sap.com/2004/07/DCProperties/WebDynpro";
    private Combo mOptimizeByteCodeCombo = null;
    private boolean mChanged = false;

    protected Control createContents(Composite parent) {
        boolean isDC = false;
        String propertyValue = OPTIMIZE_TEXTS[0];
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            IProject project = (IProject)adaptable;
            boolean bl = isDC = DevComponentService.getDC((IProject)project) != null;
            if (isDC) {
                propertyValue = this.getProperty();
            }
        }
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        IGridLayoutPane propertyPane = PaneFactory.createGridLayoutPane((Composite)root, (int)2);
        propertyPane.addTextLabel(mTextPool.getText(44));
        IGridLayoutData gd = propertyPane.createGridLayoutData(4, 1, true, false);
        this.mOptimizeByteCodeCombo = propertyPane.addComboBox(OPTIMIZE_TEXTS, propertyValue, true, gd);
        this.mOptimizeByteCodeCombo.setEnabled(isDC);
        this.mOptimizeByteCodeCombo.addSelectionListener((SelectionListener)new OptimizeByteCodeSelectionListener());
        return root;
    }

    protected void performApply() {
        this.saveSettings();
        super.performApply();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setOptimizeByteCodeSelection(0);
    }

    public boolean performOk() {
        this.saveSettings();
        return super.performOk();
    }

    private void setOptimizeByteCodeSelection(int i) {
        if (this.mOptimizeByteCodeCombo.getSelectionIndex() != i) {
            this.mChanged = true;
        }
        this.mOptimizeByteCodeCombo.select(i);
    }

    private String getProperty() {
        String result = OPTIMIZE_TEXTS[0];
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            IProject project = (IProject)adaptable;
            IDevelopmentComponentNode node = ComponentUtil.getDCNode((IProject)project);
            if (node != null) {
                DevelopmentComponent dc = null;
                try {
                    dc = node.getDevelopmentComponent(true);
                }
                catch (RepositoryAccessException e) {
                    ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", e.getMessage(), e, false);
                    return result;
                }
                catch (InvalidDefinitionException e) {
                    ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", e.getMessage(), e, false);
                    return result;
                }
                if (dc != null) {
                    String value;
                    Property property = dc.getProperty(PROPERTY_OPTIMIZE_BYTE_CODE_NAME, PROPERTY_OPTIMIZE_BYTE_CODE_NAMESPACE);
                    if (property != null && (value = property.getValue()) != null) {
                        if (value.equals(OPTIMIZE_TEXT_NO)) {
                            result = OPTIMIZE_TEXT_NO;
                        } else if (value.equals(OPTIMIZE_TEXT_AUTO)) {
                            result = OPTIMIZE_TEXT_AUTO;
                        }
                    }
                } else {
                    ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", "Could not get development component", new Exception(), false);
                }
            } else {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", "Could not get development component node", new Exception(), false);
            }
        } else {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", "Could not get project", new Exception(), false);
        }
        return result;
    }

    private void saveSettings() {
        if (this.mChanged) {
            IAdaptable adaptable = this.getElement();
            if (adaptable instanceof IProject) {
                IProject project = (IProject)adaptable;
                IDevelopmentComponentNode node = ComponentUtil.getDCNode((IProject)project);
                if (node != null) {
                    DevelopmentComponent dc = null;
                    try {
                        dc = node.getDevelopmentComponent(true);
                    }
                    catch (RepositoryAccessException e) {
                        ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", e.getMessage(), e, false);
                        return;
                    }
                    catch (InvalidDefinitionException e) {
                        ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", e.getMessage(), e, false);
                        return;
                    }
                    if (dc != null) {
                        try {
                            if (!node.getDCProxy().isLocalOnly()) {
                                IFile dcdefFile = project.getFile(".dcdef");
                                MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
                                if (dcdefFile.isReadOnly()) {
                                    MMRepositoryObject repositoryObject = new MMRepositoryObject(MetamodelServices.getMetamodel((String)project.getName()), "DC definition", "", false);
                                    IPath path = dcdefFile.getProjectRelativePath();
                                    repositoryObject.addAdditionalFile(path);
                                    repositoryObjectList.addRepositoryObject(repositoryObject);
                                    RepositoryServices.checkout((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
                                }
                                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects())) {
                                    ServicesUI.displayErrorMessage((String)"Changes were not saved", (String)"Could not save the changes because the development configuration file was not checked out");
                                    return;
                                }
                            }
                        }
                        catch (DevConfigException e) {
                            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", e.getMessage(), e, false);
                            return;
                        }
                        Property property = dc.getProperty(PROPERTY_OPTIMIZE_BYTE_CODE_NAME, PROPERTY_OPTIMIZE_BYTE_CODE_NAMESPACE);
                        if (property != null) {
                            property.setValue(OPTIMIZE_TEXTS[this.mOptimizeByteCodeCombo.getSelectionIndex()]);
                        } else {
                            dc.addProperty(PROPERTY_OPTIMIZE_BYTE_CODE_NAME, PROPERTY_OPTIMIZE_BYTE_CODE_NAMESPACE, OPTIMIZE_TEXTS[this.mOptimizeByteCodeCombo.getSelectionIndex()]);
                        }
                        try {
                            node.getDCProxy().serializeDefinition();
                        }
                        catch (DevConfigException e) {
                            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", e.getMessage(), e, false);
                            return;
                        }
                    }
                    ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", "Could not get development component", new Exception(), false);
                    return;
                }
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", "Could not get development component node", new Exception(), false);
                return;
            }
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "saveSettings()", "Could not get project", new Exception(), false);
            return;
            this.mChanged = false;
        }
    }

    private class OptimizeByteCodeSelectionListener
    implements SelectionListener {
        private OptimizeByteCodeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            GenerationPropertyPage.this.mChanged = true;
        }
    }
}

