/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.projectproperties;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.project.LibraryReference;
import com.sap.ide.metamodel.webdynpro.project.ProjectProperties;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.LibraryReferenceTableModel;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.LibraryReferencesTab;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.ProjectPropertiesService;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.TableModelInterfaceReferences;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.TableModelJCOReferences;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.TableModelLibraryReferences;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.TableModelServiceReferences;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.TableModelSharingReferences;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectReferencesPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private List mArchiveList = null;
    private ProjectProperties mProjectProperties = null;
    LibraryReferenceTableModel mInterfaceReferencesTableModel = null;
    LibraryReferencesTab mInterfaceReferencesTab = null;
    LibraryReferenceTableModel mJCOReferencesTableModel = null;
    LibraryReferencesTab mJCOReferencesTab = null;
    LibraryReferenceTableModel mLibraryReferencesTableModel = null;
    LibraryReferencesTab mLibraryReferencesTab = null;
    LibraryReferenceTableModel mServiceReferencesTableModel = null;
    LibraryReferencesTab mServiceReferencesTab = null;
    LibraryReferenceTableModel mSharingReferencesTableModel = null;
    LibraryReferencesTab mSharingReferencesTab = null;

    protected Control createContents(Composite parent) {
        IProject project = this.getProject();
        this.mProjectProperties = ProjectPropertiesService.createProjectProperties(project);
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        IGridLayoutPane propertyPane = PaneFactory.createGridLayoutPane((Composite)root, (int)1);
        IGridLayoutData gd = propertyPane.createGridLayoutData(4, 4, false, true);
        ITabbedPane tabs = propertyPane.addTabbedPane(gd);
        this.mInterfaceReferencesTableModel = new TableModelInterfaceReferences(this.mProjectProperties, this);
        this.mInterfaceReferencesTab = new LibraryReferencesTab(this.mProjectProperties, this.mInterfaceReferencesTableModel);
        this.mInterfaceReferencesTab.initUI(tabs, mTextPool.getText(15));
        this.mJCOReferencesTableModel = new TableModelJCOReferences(this.mProjectProperties, this);
        this.mJCOReferencesTab = new LibraryReferencesTab(this.mProjectProperties, this.mJCOReferencesTableModel);
        this.mJCOReferencesTab.initUI(tabs, mTextPool.getText(22));
        this.mLibraryReferencesTableModel = new TableModelLibraryReferences(this.mProjectProperties, this);
        this.mLibraryReferencesTab = new LibraryReferencesTab(this.mProjectProperties, this.mLibraryReferencesTableModel);
        this.mLibraryReferencesTab.initUI(tabs, mTextPool.getText(23));
        this.mServiceReferencesTableModel = new TableModelServiceReferences(this.mProjectProperties, this);
        this.mServiceReferencesTab = new LibraryReferencesTab(this.mProjectProperties, this.mServiceReferencesTableModel);
        this.mServiceReferencesTab.initUI(tabs, mTextPool.getText(24));
        this.mSharingReferencesTableModel = new TableModelSharingReferences(this.mProjectProperties, this);
        this.mSharingReferencesTab = new LibraryReferencesTab(this.mProjectProperties, this.mSharingReferencesTableModel);
        this.mSharingReferencesTab.initUI(tabs, mTextPool.getText(25));
        return root;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            IProject project = (IProject)adaptable;
            return project;
        }
        return null;
    }

    protected void performApply() {
        this.setReferences();
        super.performApply();
    }

    protected void performDefaults() {
        this.mInterfaceReferencesTableModel.initTableData();
        this.mJCOReferencesTableModel.initTableData();
        this.mLibraryReferencesTableModel.initTableData();
        this.mServiceReferencesTableModel.initTableData();
        this.mSharingReferencesTableModel.initTableData();
        super.performDefaults();
    }

    public boolean performOk() {
        this.setReferences();
        return super.performOk();
    }

    private void setReferences() {
        MMRepositoryObject[] repositoryObjects = ProjectPropertiesService.getRepositoryObjectsAffectedByProjectPropertiesModification(this.mProjectProperties);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        this.clearReferences();
        String[] references = this.mInterfaceReferencesTab.getReferences();
        int i = 0;
        while (i < references.length) {
            try {
                LibraryReference reference = this.mProjectProperties.createInterfaceReference(Integer.toString(i));
                reference.setLibraryName(references[i]);
            }
            catch (CreateException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i;
        }
        references = this.mJCOReferencesTab.getReferences();
        int i2 = 0;
        while (i2 < references.length) {
            try {
                LibraryReference reference = this.mProjectProperties.createJcoReference(Integer.toString(i2));
                reference.setLibraryName(references[i2]);
            }
            catch (CreateException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i2;
        }
        references = this.mLibraryReferencesTab.getReferences();
        int i3 = 0;
        while (i3 < references.length) {
            try {
                LibraryReference reference = this.mProjectProperties.createLibraryReference(Integer.toString(i3));
                reference.setLibraryName(references[i3]);
            }
            catch (CreateException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i3;
        }
        references = this.mServiceReferencesTab.getReferences();
        int i4 = 0;
        while (i4 < references.length) {
            try {
                LibraryReference reference = this.mProjectProperties.createServiceReference(Integer.toString(i4));
                reference.setLibraryName(references[i4]);
            }
            catch (CreateException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i4;
        }
        references = this.mSharingReferencesTab.getReferences();
        int i5 = 0;
        while (i5 < references.length) {
            try {
                LibraryReference reference = this.mProjectProperties.createSharingReference(Integer.toString(i5));
                reference.setLibraryName(references[i5]);
            }
            catch (CreateException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i5;
        }
    }

    private void clearReferences() {
        LibraryReference[] references = this.mProjectProperties.getInterfaceReferences();
        int i = 0;
        while (i < references.length) {
            try {
                references[i].delete();
            }
            catch (DeleteException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i;
        }
        references = this.mProjectProperties.getJcoReferences();
        int i2 = 0;
        while (i2 < references.length) {
            try {
                references[i2].delete();
            }
            catch (DeleteException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i2;
        }
        references = this.mProjectProperties.getLibraryReferences();
        int i3 = 0;
        while (i3 < references.length) {
            try {
                references[i3].delete();
            }
            catch (DeleteException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i3;
        }
        references = this.mProjectProperties.getServiceReferences();
        int i4 = 0;
        while (i4 < references.length) {
            try {
                references[i4].delete();
            }
            catch (DeleteException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i4;
        }
        references = this.mProjectProperties.getSharingReferences();
        int i5 = 0;
        while (i5 < references.length) {
            try {
                references[i5].delete();
            }
            catch (DeleteException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "clearReferences()", e.getMessage(), e, false);
            }
            ++i5;
        }
    }

    public String[] getAllEntriesFromMemory() {
        ArrayList<String> list = new ArrayList<String>();
        String[] references = this.mInterfaceReferencesTableModel.getReferences();
        int i = 0;
        while (i < references.length) {
            list.add(references[i]);
            ++i;
        }
        references = this.mJCOReferencesTableModel.getReferences();
        int i2 = 0;
        while (i2 < references.length) {
            list.add(references[i2]);
            ++i2;
        }
        references = this.mLibraryReferencesTableModel.getReferences();
        int i3 = 0;
        while (i3 < references.length) {
            list.add(references[i3]);
            ++i3;
        }
        references = this.mServiceReferencesTableModel.getReferences();
        int i4 = 0;
        while (i4 < references.length) {
            list.add(references[i4]);
            ++i4;
        }
        references = this.mSharingReferencesTableModel.getReferences();
        int i5 = 0;
        while (i5 < references.length) {
            list.add(references[i5]);
            ++i5;
        }
        String[] entries = new String[list.size()];
        entries = list.toArray(entries);
        return entries;
    }
}

