/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.projectproperties;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.webdynpro.project.ProjectProperties;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.LibraryReferenceTableModel;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.ProjectPropertiesService;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import javax.swing.table.TableModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

public class LibraryReferencesTab {
    private static final TextPool mTextPool = TextPool.getInstance();
    private ProjectProperties mProjectProperties = null;
    private LibraryReferenceTableModel mTableModel = null;
    private Button mButtonAdd = null;
    private Button mButtonDelete = null;
    private ButtonSelectionListener mButtonSelectionListener = null;
    private ISapTableViewer mTableViewer = null;

    public LibraryReferencesTab(ProjectProperties properties, LibraryReferenceTableModel tableModel) {
        this.mProjectProperties = properties;
        this.mTableModel = tableModel;
        this.mButtonSelectionListener = new ButtonSelectionListener();
    }

    public void initUI(ITabbedPane parent, String title) {
        IGridLayoutPane pane = parent.addGridLayoutPaneAsTab(title, 2);
        IGridLayoutData gd = pane.createGridLayoutData(4, 4, true, true);
        this.mTableViewer = pane.addSapTableViewer((TableModel)this.mTableModel, gd, true);
        IGridLayoutPane buttonPane = pane.addGridLayoutPane(1);
        gd = pane.createGridLayoutData(4, 4, false, false);
        this.mButtonAdd = buttonPane.addPushButton(mTextPool.getText(16), gd);
        this.mButtonAdd.addSelectionListener((SelectionListener)this.mButtonSelectionListener);
        gd = pane.createGridLayoutData(4, 4, false, false);
        this.mButtonDelete = buttonPane.addPushButton(mTextPool.getText(17), gd);
        this.mButtonDelete.addSelectionListener((SelectionListener)this.mButtonSelectionListener);
    }

    public String[] getReferences() {
        return this.mTableModel.getReferences();
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(LibraryReferencesTab.this.mButtonAdd)) {
                MMRepositoryObject[] repositoryObjects = ProjectPropertiesService.getRepositoryObjectsAffectedByProjectPropertiesModification(LibraryReferencesTab.this.mProjectProperties);
                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                    return;
                }
                LibraryReferencesTab.this.mTableModel.add();
            } else if (e.widget.equals(LibraryReferencesTab.this.mButtonDelete)) {
                MMRepositoryObject[] repositoryObjects = ProjectPropertiesService.getRepositoryObjectsAffectedByProjectPropertiesModification(LibraryReferencesTab.this.mProjectProperties);
                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                    return;
                }
                LibraryReferencesTab.this.mTableModel.delete(LibraryReferencesTab.this.mTableViewer.getTable().getSelectionIndex());
            }
        }
    }
}

