/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.projectproperties;

import com.sap.ide.metamodel.webdynpro.project.ProjectProperties;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.LibraryEditDialog;
import com.sap.ide.webdynpro.archivebuilder.projectproperties.ProjectReferencesPage;
import com.sap.ide.webdynpro.service.core.UIHelper;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public abstract class LibraryReferenceTableModel
extends AbstractTableModel {
    private static final TextPool mTextPool = TextPool.getInstance();
    protected ProjectProperties mProjectProperties = null;
    protected String[] mReferences = null;
    private ProjectReferencesPage mProjectReferencesPage = null;

    public LibraryReferenceTableModel(ProjectProperties properties, ProjectReferencesPage projectReferencesPage) {
        this.mProjectProperties = properties;
        this.mProjectReferencesPage = projectReferencesPage;
        this.initTableData();
    }

    public abstract void initTableData();

    public Object getValueAt(int rowIndex, int columnIndex) {
        String ret = "";
        if (rowIndex < this.getRowCount()) {
            switch (columnIndex) {
                case 0: {
                    ret = this.mReferences[rowIndex];
                    break;
                }
                default: {
                    return "";
                }
            }
        }
        return ret;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this.mReferences.length;
    }

    public void add() {
        LibraryEditDialog dialog = new LibraryEditDialog(this.mProjectReferencesPage.getAllEntriesFromMemory());
        if (dialog.open() == 0) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this.mReferences.length) {
                list.add(this.mReferences[i]);
                ++i;
            }
            list.add(dialog.getNewReferenceName());
            this.mReferences = new String[list.size()];
            this.mReferences = list.toArray(this.mReferences);
            this.fireTableDataChanged();
        }
    }

    public void delete(int index) {
        if (index > -1 && index < this.getRowCount() && UIHelper.askUserToDelete((String)this.mReferences[index], (String)mTextPool.getText(18))) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this.mReferences.length) {
                list.add(this.mReferences[i]);
                ++i;
            }
            ((AbstractCollection)list).remove(this.mReferences[index]);
            this.mReferences = new String[list.size()];
            this.mReferences = list.toArray(this.mReferences);
            this.fireTableDataChanged();
        }
    }

    public String[] getReferences() {
        return this.mReferences;
    }

    public String getColumnName(int columnIndex) {
        String ret = "";
        switch (columnIndex) {
            case 0: {
                ret = mTextPool.getText(21);
                break;
            }
            default: {
                return "";
            }
        }
        return ret;
    }
}

