/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.projectproperties;

import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LibraryEditDialog
extends TitleAreaDialog {
    private static final TextPool mTextPool = TextPool.getInstance();
    private String mErrorMessage = null;
    private String mTitle = mTextPool.getText(19);
    private String mDescription = mTextPool.getText(20);
    private int mColumns = 2;
    private Text mNameField = null;
    private String mName = "";
    private String[] mExistingEntries = null;

    public LibraryEditDialog(String[] existingEntries) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.mExistingEntries = existingEntries;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 1;
        content.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        content.setLayoutData((Object)gd);
        content.setFont(parentComposite.getFont());
        IGridLayoutPane userArea = PaneFactory.createGridLayoutPane((Composite)content, (int)this.mColumns);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        userArea.setLayoutData((Object)gd);
        this.initUserArea(userArea);
        this.setTitle(this.mTitle);
        this.setMessage(this.mDescription);
        return content;
    }

    private void initUserArea(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(21));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(false, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.validatePage();
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
        this.mErrorMessage = errorMessage;
        this.enableDisableOkButton();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableDisableOkButton();
    }

    private void enableDisableOkButton() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.mErrorMessage == null);
        }
    }

    private void validatePage() {
        if (this.mName.length() <= 0) {
            this.setErrorMessage(mTextPool.getText(514));
            return;
        }
        int i = 0;
        while (i < this.mExistingEntries.length) {
            if (this.mName.equals(this.mExistingEntries[i])) {
                this.setErrorMessage(mTextPool.getText(515, this.mName));
                return;
            }
            ++i;
        }
        this.setErrorMessage(null);
    }

    public String getNewReferenceName() {
        return this.mName;
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            LibraryEditDialog.this.mName = LibraryEditDialog.this.mNameField.getText();
            LibraryEditDialog.this.validatePage();
        }
    }
}

