/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.project;

import com.sap.ide.metamodel.general.exception.I18NException;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.ide.metamodel.general.i18n.LanguageInfo;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class WebDynproWizardProjectCreationPage
extends WizardPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private LanguageInfo[] mLanguages = null;
    private Combo mLanguageCombo = null;
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private boolean mEnabled = false;
    private String mProjectPath;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WebDynproWizardProjectCreationPage.this.setLocationForSelection();
            WebDynproWizardProjectCreationPage.this.setPageComplete(WebDynproWizardProjectCreationPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WebDynproWizardProjectCreationPage.this.setPageComplete(WebDynproWizardProjectCreationPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final int SIZING_INDENTATION_WIDTH = 10;

    public WebDynproWizardProjectCreationPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
        this.customLocationFieldValue = this.initialLocationFieldValue.toOSString();
        this.initializeSAPspecifics();
        this.mEnabled = true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.createSAPSpecificGroup(composite);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createSAPSpecificGroup(Composite parent) {
        IGridLayoutPane sapGroup = PaneFactory.createGridLayoutPane((Composite)parent, (int)2);
        if (this.mEnabled) {
            sapGroup.addTextLabel(mTextPool.getText(0));
            this.mLanguageCombo = sapGroup.addComboBox(this.getLanguageNames(), this.getDefaultLanguageName(), true);
            this.mLanguageCombo.setEnabled(this.mEnabled);
        }
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectContentsLabel"));
        GridData labelData = new GridData();
        labelData.horizontalSpan = 3;
        projectContentsLabel.setLayoutData((Object)labelData);
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setEnabled(this.mEnabled);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebDynproWizardProjectCreationPage.this.useDefaults = useDefaultsButton.getSelection();
                WebDynproWizardProjectCreationPage.this.browseButton.setEnabled(!WebDynproWizardProjectCreationPage.this.useDefaults);
                WebDynproWizardProjectCreationPage.this.locationPathField.setEditable(!WebDynproWizardProjectCreationPage.this.useDefaults);
                if (WebDynproWizardProjectCreationPage.this.useDefaults) {
                    WebDynproWizardProjectCreationPage.this.customLocationFieldValue = WebDynproWizardProjectCreationPage.this.locationPathField.getText();
                    WebDynproWizardProjectCreationPage.this.setLocationForSelection();
                } else {
                    if (WebDynproWizardProjectCreationPage.this.customLocationFieldValue.equals(WebDynproWizardProjectCreationPage.this.initialLocationFieldValue.toOSString())) {
                        WebDynproWizardProjectCreationPage.this.customLocationFieldValue = WebDynproWizardProjectCreationPage.this.locationPathField.getText();
                    }
                    WebDynproWizardProjectCreationPage.this.locationPathField.setText(WebDynproWizardProjectCreationPage.this.customLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.nameLabel"));
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setEnabled(this.mEnabled);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.locationLabel"));
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEditable(false);
        if (enabled) {
            this.locationPathField.setEnabled(this.mEnabled);
        }
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebDynproWizardProjectCreationPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        if (this.mProjectPath != null) {
            this.locationPathField.setText(this.mProjectPath);
            this.setPageComplete(this.validatePage());
        } else {
            this.locationPathField.addListener(24, this.locationModifyListener);
        }
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.directoryLabel"));
        String dirName = this.getProjectLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    public void setInitialProjectName(String name) {
        this.initialProjectFieldValue = name == null ? null : name.trim();
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.getProjectNameFieldValue());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }

    private boolean validatePage() {
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectNameEmpty"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectLocationEmpty"));
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.locationError"));
            return false;
        }
        if (!this.useDefaults && Platform.getLocation().isPrefixOf((IPath)new Path(locationFieldContents))) {
            this.setErrorMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.defaultLocationError"));
            return false;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getName().equalsIgnoreCase(this.getProjectName())) {
                this.setErrorMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectExistsMessage"));
                return false;
            }
            ++i;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public void setLocation(IPath path) {
        this.mProjectPath = path.toOSString();
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    private void initializeSAPspecifics() {
        I18NService service = I18NService.getInstance();
        try {
            this.mLanguages = service.getValidLanguages();
        }
        catch (I18NException e) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "initializeSAPspecifice()", e.getMessage(), e, false);
        }
        Arrays.sort(this.mLanguages, new LanguageComparator());
    }

    private String[] getLanguageNames() {
        String[] names = new String[this.mLanguages.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.mLanguages[i].getDescription();
            ++i;
        }
        return names;
    }

    private String getDefaultLanguageName() {
        int i = 0;
        while (i < this.mLanguages.length) {
            if (this.mLanguages[i].getName().equals("en")) {
                return this.mLanguages[i].getDescription();
            }
            ++i;
        }
        return "";
    }

    public String getSelectedLanguage() {
        return this.mLanguages[this.mLanguageCombo.getSelectionIndex()].getName();
    }

    private class LanguageComparator
    implements Comparator {
        private LanguageComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof LanguageInfo) {
                LanguageInfo info1 = (LanguageInfo)o1;
                if (o2 instanceof LanguageInfo) {
                    LanguageInfo info2 = (LanguageInfo)o2;
                    return info1.getDescription().compareTo(info2.getDescription());
                }
            }
            return 0;
        }
    }
}

