/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.project;

import com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer;
import com.sap.ide.webdynpro.archivebuilder.project.WebDynproProjectWizard;
import com.tssap.util.projectinfo.ProjectInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;

public class WebDynproStandaloneProjectWizard
extends WebDynproProjectWizard {
    public String runPerformFinish(IProgressMonitor monitor) {
        String message = this.checkNewProjectName(this.mNewProjectPage.getProjectName());
        if (message != null) {
            this.mNewProjectPage.setErrorMessage(message);
            return message;
        }
        IProject project = super.createProject(this.mNewProjectPage.getProjectName(), this.mNewProjectPage.getLocationPath(), monitor);
        if (project == null) {
            String error = WebDynproProjectWizard.mTextPool.getText(505);
            this.mNewProjectPage.setErrorMessage(error);
            return error;
        }
        IJavaProject javaProject = super.createJavaProject(project, monitor);
        if (javaProject == null) {
            String error = WebDynproProjectWizard.mTextPool.getText(512);
            this.mNewProjectPage.setErrorMessage(error);
            return error;
        }
        WDRuntimeVariableClasspathInitializer.setDefaultWebDynproSourceAndOutputPaths(javaProject, monitor);
        WDRuntimeVariableClasspathInitializer.initialize();
        WDRuntimeVariableClasspathInitializer.updateClasspathEntries(javaProject, monitor, false);
        if (!this.configureProject(javaProject, monitor, true)) {
            String error = WebDynproProjectWizard.mTextPool.getText(507);
            this.mNewProjectPage.setErrorMessage(error);
            return error;
        }
        String error = this.setProjectProperties(project, this.mNewProjectPage.getSelectedLanguage());
        if (error != null) {
            this.mNewProjectPage.setErrorMessage(error);
            return error;
        }
        this.setProjectOptions(javaProject);
        return null;
    }

    protected String setProjectProperties(IProject project, String projectLanguage) {
        String result = super.setProjectProperties(project);
        if (result != null) {
            return result;
        }
        if (!ProjectInfo.setProperty((IProject)project, (String)"com.sap.ide.metamodel.project.masterlanguage", (String)projectLanguage)) {
            ProjectInfo.SaveFailedReason reason = ProjectInfo.getLastSaveFailedReason();
            if (reason.isReadOnly()) {
                return WebDynproProjectWizard.mTextPool.getText(513);
            }
            return reason.getException().getMessage();
        }
        return null;
    }

    private String checkNewProjectName(String name) {
        if (!this.isValidProjectIdentifier(name)) {
            String error = WebDynproProjectWizard.mCoreTextPool.getText(1, (Object)name);
            return error;
        }
        return null;
    }

    private boolean isValidProjectIdentifier(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0))) {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

