/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.project;

import com.sap.dictionary.tools.archivebuilder.project.DictionaryNatureAction;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.archivebuilder.project.WebDynproNatureAction;
import com.sap.ide.webdynpro.archivebuilder.project.WebDynproWizardProjectCreationPage;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public abstract class WebDynproProjectWizard
extends Wizard
implements INewWizard {
    protected static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    protected static final TextPool mTextPool = TextPool.getInstance();
    protected WebDynproWizardProjectCreationPage mNewProjectPage = null;

    public WebDynproProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected IProject createProject(String projectName, IPath projectPath, IProgressMonitor monitor) {
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        if (!projectPath.equals((Object)Platform.getLocation())) {
            projectDescription.setLocation(projectPath);
        } else {
            projectDescription.setLocation(null);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectDescription.getName());
        try {
            project.create(projectDescription, monitor);
        }
        catch (CoreException e) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "createProject(String, IPath, IProgressMonitor)", e.getMessage(), e, false);
            return null;
        }
        if (!project.isOpen()) {
            try {
                project.open(monitor);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "createProject(String, IPath, IProgressMonitor)", e.getMessage(), e, false);
                return null;
            }
        }
        PARService.prepareProject(project);
        return project;
    }

    protected IJavaProject createJavaProject(IProject project, IProgressMonitor monitor) {
        IJavaProject javaProject = ServicesEclipse.getJavaProject((String)project.getName());
        if (javaProject == null || !javaProject.exists()) {
            IProjectDescription projectDescription = null;
            try {
                projectDescription = project.getDescription();
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "createJavaProject(IProject, IProgressMonitor)", e.getMessage(), e, false);
                return null;
            }
            String[] natures = projectDescription.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = "org.eclipse.jdt.core.javanature";
            projectDescription.setNatureIds(newNatures);
            try {
                project.setDescription(projectDescription, monitor);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "createJavaProject(IProject, IProgressMonitor)", e.getMessage(), e, false);
                return null;
            }
            javaProject = ServicesEclipse.getJavaProject((String)project.getName());
        }
        IClasspathEntry[] classpathEntries = new IClasspathEntry[]{JavaRuntime.getJREVariableEntry()};
        try {
            javaProject.setRawClasspath(classpathEntries, javaProject.getOutputLocation(), monitor);
        }
        catch (JavaModelException e) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "createJavaProject(IProject, IProgressMonitor)", e.getMessage(), e, false);
        }
        return javaProject;
    }

    protected boolean configureProject(IJavaProject javaProject, IProgressMonitor monitor, boolean openPerspective) {
        DictionaryNatureAction dictionaryNatureAction = new DictionaryNatureAction(javaProject.getProject());
        dictionaryNatureAction.run();
        WebDynproNatureAction webDynproNatureAction = new WebDynproNatureAction(javaProject.getProject());
        webDynproNatureAction.run();
        IClasspathEntry[] classpathEntrys = null;
        try {
            classpathEntrys = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "configureProject(String, IPath, IProgressMonitor)", e.getMessage(), e, false);
        }
        classpathEntrys = ProjectService.getMetamodelRelevantEntries((IClasspathEntry[])classpathEntrys);
        ProjectService.addPublicPartJars((IProject)javaProject.getProject(), (IPath[])ProjectService.getFullPaths((IClasspathEntry[])classpathEntrys));
        if (openPerspective) {
            try {
                PlatformUI.getWorkbench().showPerspective("com.sap.ide.webdynproperspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "configureProject(String, IPath, IProgressMonitor)", e.getMessage(), e, false);
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(mTextPool.getText(4));
    }

    public void addPages() {
        super.addPages();
        this.mNewProjectPage = new WebDynproWizardProjectCreationPage(mTextPool.getText(5));
        this.mNewProjectPage.setTitle(mTextPool.getText(5));
        this.mNewProjectPage.setDescription(mTextPool.getText(6));
        this.addPage((IWizardPage)this.mNewProjectPage);
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                String error = 1.access$000(this.this$1).runPerformFinish(monitor);
                                if (error != null) {
                                    Status status = new Status(4, "com.sap.ide.webdynpro.archivebuilder", 0, error, (Throwable)new Exception(error));
                                    throw new CoreException((IStatus)status);
                                }
                            }
                        }, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }

            static /* synthetic */ WebDynproProjectWizard access$000(1 x0) {
                return x0.WebDynproProjectWizard.this;
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "performFinish()", e.getMessage(), e, true);
            this.mNewProjectPage.setErrorMessage(e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
        return true;
    }

    protected String setProjectProperties(IProject project) {
        return null;
    }

    protected void setProjectOptions(IJavaProject project) {
        Map options = project.getOptions(false);
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        project.setOptions(options);
    }

    abstract String runPerformFinish(IProgressMonitor var1);
}

