/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.project;

import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class WebDynproNatureAction
implements IActionDelegate,
IRunnableWithProgress {
    public static final String NATURE_ID = "com.sap.ide.webdynpro.archivebuilder.WebDynproNature";
    private IProject mProject = null;

    public WebDynproNatureAction(IProject project) {
        this.mProject = project;
    }

    public void run() {
        WorkspaceModifyDelegatingOperation operation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(WebDynproNatureAction.getShell());
        try {
            dialog.run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
        }
        catch (InterruptedException e) {
            dialog.close();
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            WebDynproNatureAction.addNature(this.mProject, NATURE_ID, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static void addNature(IProject project, String id, IProgressMonitor monitor) throws CoreException {
        IProjectDescription lDescription = project.getDescription();
        String[] lNatures = lDescription.getNatureIds();
        if (!WebDynproNatureAction.hasNature(lNatures, id)) {
            lNatures = WebDynproNatureAction.addNature(lNatures, id);
            lDescription.setNatureIds(lNatures);
            project.setDescription(lDescription, monitor);
        }
    }

    private static boolean hasNature(String[] natures, String id) {
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] addNature(String[] natures, String id) {
        String[] lResult = new String[natures.length + 1];
        System.arraycopy(natures, 0, lResult, 1, natures.length);
        lResult[0] = id;
        return lResult;
    }

    private static Shell getShell() {
        return WebDynproNatureAction.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }
}

