/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.project;

import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer;
import com.sap.ide.webdynpro.archivebuilder.project.WebDynproProjectWizard;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.widgets.Display;

public class WebDynproDevelopmentComponentProjectWizard
extends WebDynproProjectWizard
implements IConnectedWizard {
    private static final String FILE_NAME_PROJECT = ".project";
    private static final String FILE_NAME_CLASSPATH = ".classpath";
    private static final String FILE_NAME_TSSAPINFO = ".tssapinfo";
    private IStartCreateProjectWizard mDevelopmentComponentWizard = null;

    public void init(IStartCreateProjectWizard wizard) {
        this.mDevelopmentComponentWizard = wizard;
    }

    public String runPerformFinish(IProgressMonitor monitor) {
        IProjectDescription projectDescription = this.mDevelopmentComponentWizard.getProjectDescription();
        IProject project = super.createProject(projectDescription.getName(), projectDescription.getLocation(), monitor);
        if (project == null) {
            String error = WebDynproProjectWizard.mTextPool.getText(505);
            this.mNewProjectPage.setErrorMessage(error);
            return error;
        }
        IJavaProject javaProject = super.createJavaProject(project, monitor);
        if (javaProject == null) {
            String error = WebDynproProjectWizard.mTextPool.getText(512);
            this.mNewProjectPage.setErrorMessage(error);
            try {
                project.delete(true, monitor);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "runPerformFinish(IProgressMonitor)", e.getMessage(), e, false);
            }
            return error;
        }
        WDRuntimeVariableClasspathInitializer.setDefaultWebDynproSourceAndOutputPaths(javaProject, monitor);
        if (!this.mDevelopmentComponentWizard.fillProject(project, this.createPropertiesForDevelopmentComponent(javaProject))) {
            String error = WebDynproProjectWizard.mTextPool.getText(506);
            this.mNewProjectPage.setErrorMessage(error);
            try {
                project.delete(true, monitor);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "runPerformFinish(IProgressMonitor)", e.getMessage(), e, false);
            }
            return error;
        }
        WDRuntimeVariableClasspathInitializer.updateClasspathEntries(javaProject, monitor, false);
        if (!super.configureProject(javaProject, monitor, true)) {
            String error = WebDynproProjectWizard.mTextPool.getText(507);
            this.mNewProjectPage.setErrorMessage(error);
            return error;
        }
        String error = this.setProjectProperties(project);
        if (error != null) {
            this.mNewProjectPage.setErrorMessage(error);
            return error;
        }
        if (!this.setDCProjectSpecific(project)) {
            error = WebDynproProjectWizard.mTextPool.getText(510);
            this.mNewProjectPage.setErrorMessage(error);
            return error;
        }
        this.setProjectOptions(javaProject);
        return null;
    }

    public void addPages() {
        super.addPages();
        this.mNewProjectPage.setEnabled(false);
        this.mNewProjectPage.setInitialProjectName(this.mDevelopmentComponentWizard.getProjectDescription().getName());
        this.mNewProjectPage.setLocation(this.mDevelopmentComponentWizard.getProjectDescription().getLocation());
    }

    public boolean completeProject(IProject project, Properties properties) {
        Display.getDefault().syncExec((Runnable)new CompleteProjectRunnable(project, properties));
        return true;
    }

    private boolean setDCProjectSpecific(IProject project) {
        String folderName;
        IFolder folder;
        WorkspaceMonitor monitor = WorkspaceMonitor.getInstance();
        IFile file = project.getFile(FILE_NAME_PROJECT);
        if (file.exists()) {
            try {
                file.setDerived(true);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "setDCProjectSpecific(IProject)", "Could not set .project file to derived", new Exception(e.getMessage()), false);
            }
            monitor.setMonitorResource((IResource)file, false, 1);
        }
        if ((file = project.getFile(FILE_NAME_CLASSPATH)).exists()) {
            try {
                file.setDerived(true);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "setDCProjectSpecific(IProject)", "Could not set .project file to derived", new Exception(e.getMessage()), false);
            }
            monitor.setMonitorResource((IResource)file, false, 1);
        }
        if ((file = project.getFile(FILE_NAME_TSSAPINFO)).exists()) {
            try {
                file.setDerived(false);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "setDCProjectSpecific(IProject)", "Could not set .project file to derived", new Exception(e.getMessage()), false);
            }
        }
        if ((folder = project.getFolder(folderName = com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse.getGenerationOutputPathInfix())).exists()) {
            try {
                folder.setDerived(true);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "setDCProjectSpecific(IProject)", "Could not set '" + folderName + "' folder to derived", new Exception(e.getMessage()), false);
            }
            monitor.setMonitorResource((IResource)folder, false, -1);
        }
        if ((folder = project.getFolder(folderName = GenerationEclipse.getGenerationOutputPathInfix())).exists()) {
            try {
                folder.setDerived(true);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "setDCProjectSpecific(IProject)", "Could not set '" + folderName + "' folder to derived", new Exception(e.getMessage()), false);
            }
            monitor.setMonitorResource((IResource)folder, false, -1);
        }
        return true;
    }

    private Properties createPropertiesForDevelopmentComponent(IJavaProject javaProject) {
        Properties properties = new Properties();
        ArrayList<String> list = new ArrayList<String>();
        if (javaProject != null) {
            IClasspathEntry[] classpathEntries = null;
            try {
                classpathEntries = javaProject.getRawClasspath();
            }
            catch (JavaModelException e) {
                ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "createPropertiesForDevelopmentComponent(IProject)", e.getMessage(), e, false);
                return null;
            }
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3 && !this.isPathForGeneratedSources(javaProject, classpathEntries[i])) {
                    String path = classpathEntries[i].getPath().removeFirstSegments(1).toString();
                    list.add(path);
                }
                ++i;
            }
        }
        ((Hashtable)properties).put("DCPackageFolder", list);
        list = new ArrayList();
        list.add("META-INF");
        list.add("src/mimes");
        list.add("src/configuration");
        ((Hashtable)properties).put("DCSourceFolder", list);
        return properties;
    }

    private IClasspathEntry[] getGenerationSourcePaths(IJavaProject javaProject) {
        IClasspathEntry[] entries = new IClasspathEntry[]{WDRuntimeVariableClasspathInitializer.getDictionaryGenSourcePath(javaProject), WDRuntimeVariableClasspathInitializer.getWebDynproGenSourcePath(javaProject)};
        return entries;
    }

    private boolean isPathForGeneratedSources(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        if (classpathEntry.getEntryKind() != 3) {
            return false;
        }
        IClasspathEntry entry = WDRuntimeVariableClasspathInitializer.getDictionaryGenSourcePath(javaProject);
        if (entry.getPath().equals((Object)classpathEntry.getPath())) {
            return true;
        }
        entry = WDRuntimeVariableClasspathInitializer.getWebDynproGenSourcePath(javaProject);
        return entry.getPath().equals((Object)classpathEntry.getPath());
    }

    public void finalProject() {
    }

    private class CompleteProjectRunnable
    implements Runnable {
        private IProject mProject = null;
        private Properties mProperties = null;

        public CompleteProjectRunnable(IProject project, Properties properties) {
            this.mProject = project;
            this.mProperties = properties;
        }

        public void run() {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!WebDynproDevelopmentComponentProjectWizard.this.setDCProjectSpecific(this.mProject)) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "completeProject(IProject, Properties)", "Could not set develeopment component project specifics, please see log for details.", new Exception(), false);
                return;
            }
            IJavaProject javaProject = WebDynproDevelopmentComponentProjectWizard.this.createJavaProject(this.mProject, (IProgressMonitor)monitor);
            if (javaProject == null) {
                return;
            }
            PARService.prepareProject(this.mProject);
            if (!WebDynproDevelopmentComponentProjectWizard.this.configureProject(javaProject, (IProgressMonitor)monitor, false)) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "completeProject(IProject, Properties)", "Could not configure project, please see log for details.", new Exception(), false);
                return;
            }
            String language = null;
            language = ((Hashtable)this.mProperties).containsKey("DCLanguage") ? this.mProperties.getProperty("DCLanguage") : "en";
            String error = WebDynproDevelopmentComponentProjectWizard.this.setProjectProperties(this.mProject);
            if (error != null) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "completeProject(IProject, Properties", error, new Exception(), false);
                return;
            }
            ArrayList list = new ArrayList();
            if (((Hashtable)this.mProperties).containsKey("UsedDCsPaths")) {
                list = (ArrayList)((Hashtable)this.mProperties).get("UsedDCsPaths");
            }
            list = WDRuntimeVariableClasspathInitializer.getJARPathsFromReferencedDCs(list);
            list.add(0, JavaRuntime.getJREVariableEntry());
            ArrayList sourceList = new ArrayList();
            if (((Hashtable)this.mProperties).containsKey("DCPackageFolder")) {
                sourceList = (ArrayList)((Hashtable)this.mProperties).get("DCPackageFolder");
            }
            String[] sourcePaths = new String[sourceList.size()];
            sourcePaths = sourceList.toArray(sourcePaths);
            int i = 0;
            while (i < sourcePaths.length) {
                IPath path = this.mProject.getFolder(sourcePaths[i]).getFullPath();
                list.add(0, JavaCore.newSourceEntry((IPath)path));
                ++i;
            }
            IClasspathEntry[] genSourceEntries = WebDynproDevelopmentComponentProjectWizard.this.getGenerationSourcePaths(javaProject);
            int i2 = 0;
            while (i2 < genSourceEntries.length) {
                if (!list.contains(genSourceEntries[i2])) {
                    list.add(1, genSourceEntries[i2]);
                }
                ++i2;
            }
            if (javaProject != null) {
                IClasspathEntry[] classpathEntrys = new IClasspathEntry[list.size()];
                classpathEntrys = list.toArray(classpathEntrys);
                try {
                    javaProject.setRawClasspath(classpathEntrys, javaProject.getOutputLocation(), (IProgressMonitor)monitor);
                }
                catch (JavaModelException e) {
                    ArchiveBuilderPlugin.internalError(this.getClass(), "completeProject(IProject, Properties)", e.getMessage(), e, false);
                    return;
                }
            }
            WebDynproDevelopmentComponentProjectWizard.this.setProjectOptions(javaProject);
            ProjectService.updateMetamodelJarsFromClasspath((IProject)this.mProject);
        }
    }
}

