/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.project;

import com.sap.ide.eclipse.component.dcmdcommons.resources.MessageUtil;
import com.sap.ide.eclipse.component.dcmetadata.model.DevelopmentComponentFileOutputProvider;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class WDRuntimeVariableClasspathInitializer
extends ClasspathVariableInitializer {
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final String WD_RUNTIME_CLASSPATH_VARIABLE = "WD_RUNTIME";
    public static final String JAVA_CLASSPATH_VARIABLE = "JRE_SRC";
    public static final String SOURCE_PATH_ENTRY = "src";
    public static final String PACKAGES_PATH_ENTRY = "packages";
    public static final String DATATYPES_PATH_ENTRY = "datatypes";
    public static final String OUTPUT_PATH_ENTRY = "bin";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer;

    public static void initialize() {
        WDRuntimeVariableClasspathInitializer initializer = new WDRuntimeVariableClasspathInitializer();
        initializer.initialize(WD_RUNTIME_CLASSPATH_VARIABLE);
    }

    public void initialize(String variable) {
        if (!variable.equals(WD_RUNTIME_CLASSPATH_VARIABLE)) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "initialize(String)", "Cannot initialize " + variable, new Exception(), false);
            return;
        }
        try {
            JavaCore.setClasspathVariable((String)WD_RUNTIME_CLASSPATH_VARIABLE, (IPath)this.getVariablePath(), null);
        }
        catch (JavaModelException e) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "initialize(String)", e.getMessage(), e, false);
        }
    }

    private IPath getVariablePath() {
        IPluginDescriptor runtimePluginDescriptor = Platform.getPlugin((String)"com.sap.tc.webdynpro.runtime").getDescriptor();
        URL runtimePluginUrl = null;
        try {
            runtimePluginUrl = Platform.resolve((URL)runtimePluginDescriptor.getInstallURL());
        }
        catch (IOException e) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "getVariablePath()", e.getMessage(), e, false);
            return null;
        }
        Path runtimePluginPath = new Path(runtimePluginUrl.getFile());
        return runtimePluginPath.removeLastSegments(1);
    }

    public static void updateClasspathEntries(IJavaProject javaProject, IProgressMonitor monitor, boolean updateDCReferences) {
        if (javaProject == null) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "updateClasspathEntries(IJavaProject)", "No java project given", new Exception(), false);
            return;
        }
        IProject project = javaProject.getProject();
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "updateClasspathEntries(IJavaProject)", e.getMessage(), e, false);
            return;
        }
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            if ((entries[i].getEntryKind() != 4 || entries[i].getEntryKind() == 4 && !entries[i].toString().startsWith(WD_RUNTIME_CLASSPATH_VARIABLE)) && !list.contains(entries[i])) {
                list.add(entries[i]);
            }
            ++i;
        }
        ArrayList wdRuntimeEntriesList = WDRuntimeVariableClasspathInitializer.getWDRuntimeClasspathEntries();
        IClasspathEntry[] wdRuntimeEntries = new IClasspathEntry[wdRuntimeEntriesList.size()];
        wdRuntimeEntries = wdRuntimeEntriesList.toArray(wdRuntimeEntries);
        if (ServicesEclipse.projectHasComponentNature((String)javaProject.getProject().getName())) {
            IDCExtendedProject componentProject = ServicesEclipse.getComponentProject((String)javaProject.getProject().getName());
            List usedDCsList = componentProject.getUsedCompilationPathList();
            if (updateDCReferences) {
                try {
                    IFile dcdefFile = project.getFile(".dcdef");
                    if (dcdefFile.isReadOnly()) {
                        MMRepositoryObject repositoryObject = new MMRepositoryObject(MetamodelServices.getMetamodel((String)project.getName()), "DC definition", "", false);
                        IPath path = dcdefFile.getProjectRelativePath();
                        repositoryObject.addAdditionalFile(path);
                        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
                        repositoryObjectList.addRepositoryObject(repositoryObject);
                        RepositoryServices.checkout((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
                    }
                    if (!dcdefFile.isReadOnly()) {
                        ArrayList references = WDRuntimeVariableClasspathInitializer.getInitialWDDCReferences();
                        IDCExtendedProject extendedComponentProject = ServicesEclipse.getComponentProject((String)project.getName());
                        IDevelopmentConfiguration developmentConfiguration = extendedComponentProject.getConfiguration();
                        DevelopmentComponent developmentComponent = extendedComponentProject.getDCNode().getDCProxy().getComponent();
                        if (developmentConfiguration != null) {
                            Iterator it = ((AbstractList)references).iterator();
                            while (it.hasNext()) {
                                Object object = it.next();
                                if (!(object instanceof DCReferenceNameStorage)) continue;
                                DCReferenceNameStorage usedDC = (DCReferenceNameStorage)object;
                                WDRuntimeVariableClasspathInitializer.addDCReference(developmentComponent, usedDC);
                            }
                            ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)developmentConfiguration).synchronizeProject(developmentComponent, monitor);
                            DevelopmentComponentFileOutputProvider dcFileOutputProvider = new DevelopmentComponentFileOutputProvider(dcdefFile, MessageUtil.getInstance((String)"com.sap.ide.eclipse.component.dcmdcommons.resources.messages"));
                            developmentComponent.serialize((DCOutputProvider)dcFileOutputProvider);
                        } else {
                            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "updateClasspathEntries(IJavaProject, IProgressMonitor, boolean)", "Could not get development configuration for project " + project.getName(), new Exception("Could not get development configuration for project " + project.getName()), true);
                        }
                    }
                }
                catch (Exception e) {
                    ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "updateClasspathEntries(IJavaProject, IProgressMonitor, boolean)", "Could not update DC references for project " + project.getName(), new Exception("Could not update DC references for project " + project.getName()), true);
                }
            }
            ArrayList usedPathsList = WDRuntimeVariableClasspathInitializer.getJARPathsFromReferencedDCs(usedDCsList);
            ((AbstractCollection)list).removeAll(usedPathsList);
            list.addAll(usedPathsList);
        } else {
            ((AbstractCollection)list).removeAll(wdRuntimeEntriesList);
            list.addAll(wdRuntimeEntriesList);
        }
        IClasspathEntry[] allEntries = new IClasspathEntry[list.size()];
        allEntries = list.toArray(allEntries);
        try {
            javaProject.setRawClasspath(allEntries, WDRuntimeVariableClasspathInitializer.getOutputPath(javaProject), monitor);
        }
        catch (JavaModelException e) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "updateClasspathEntries(IJavaProject)", e.getMessage(), e, false);
            return;
        }
    }

    private static ArrayList getWDRuntimeClasspathEntries() {
        IPluginDescriptor descriptor = Platform.getPlugin((String)"com.sap.tc.webdynpro.runtime").getDescriptor();
        ArrayList list = new ArrayList();
        WDRuntimeVariableClasspathInitializer.addClasspathEntriesForPlugin(descriptor, list);
        return list;
    }

    private static void addClasspathEntriesForPlugin(IPluginDescriptor descriptor, ArrayList list) {
        Path pluginFolderPath = null;
        try {
            pluginFolderPath = new Path(new Path(Platform.resolve((URL)descriptor.getInstallURL()).getFile()).lastSegment());
        }
        catch (IOException e) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "addClasspathEntriesForPlugin(IPluginDescriptor, ArrayList)", e.getMessage(), e, false);
            return;
        }
        IPath pluginPath = new Path(WD_RUNTIME_CLASSPATH_VARIABLE).append((IPath)pluginFolderPath);
        ILibrary[] libraries = descriptor.getRuntimeLibraries();
        int i = 0;
        while (i < libraries.length) {
            if (libraries[i].isExported()) {
                IPath path = pluginPath.append(libraries[i].getPath());
                IClasspathEntry entry = JavaCore.newVariableEntry((IPath)path, (IPath)path, (IPath)new Path(""));
                list.add(entry);
            }
            ++i;
        }
        IPluginPrerequisite[] requisites = descriptor.getPluginPrerequisites();
        int i2 = 0;
        while (i2 < requisites.length) {
            if (requisites[i2].isExported()) {
                Plugin plugin = Platform.getPlugin((String)requisites[i2].getUniqueIdentifier());
                WDRuntimeVariableClasspathInitializer.addClasspathEntriesForPlugin(plugin.getDescriptor(), list);
            }
            ++i2;
        }
    }

    private static IClasspathEntry getSourcePath(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        IPath srcPath = project.getLocation().append(SOURCE_PATH_ENTRY).append(PACKAGES_PATH_ENTRY);
        IContainer srcContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(srcPath);
        IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
        return srcEntry;
    }

    public static IClasspathEntry getWebDynproGenSourcePath(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        IPath path = project.getLocation().append(GenerationEclipse.getGenerationOutputPathInfix());
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        try {
            container.setDerived(true);
        }
        catch (CoreException e) {
            ArchiveBuilderPlugin.internalWarning(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "getWebDynproGenSourcePath(IJavaProject)", e.getMessage(), e);
        }
        path = path.append(PACKAGES_PATH_ENTRY);
        container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        IClasspathEntry genSrcEntry = JavaCore.newSourceEntry((IPath)container.getFullPath());
        return genSrcEntry;
    }

    public static IClasspathEntry getDictionaryGenSourcePath(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        IPath path = project.getLocation().append(com.sap.dictionary.tools.generation.eclipse.GenerationEclipse.getGenerationOutputPathInfix());
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        try {
            container.setDerived(true);
        }
        catch (CoreException e) {
            ArchiveBuilderPlugin.internalWarning(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "getDictionaryGenSourcePath(IJavaProject)", e.getMessage(), e);
        }
        path = path.append(DATATYPES_PATH_ENTRY);
        container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        IClasspathEntry genSrcEntry = JavaCore.newSourceEntry((IPath)container.getFullPath());
        return genSrcEntry;
    }

    private static IPath getOutputPath(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        IPath binPath = project.getLocation().append(OUTPUT_PATH_ENTRY);
        IContainer binContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(binPath);
        return binContainer.getFullPath();
    }

    public static ArrayList getJARPathsFromReferencedDCs(List dcList) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        String[] dcPaths = new String[dcList.size()];
        dcPaths = dcList.toArray(dcPaths);
        int i = 0;
        while (i < dcPaths.length) {
            if (dcPaths[i].toLowerCase().endsWith(".jar")) {
                IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)new Path(dcPaths[i]), null, null);
                if (!list.contains(newEntry)) {
                    list.add(newEntry);
                }
            } else {
                File[] files;
                File dir = new File(dcPaths[i] + "lib/java");
                if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
                    int j = 0;
                    while (j < files.length) {
                        IClasspathEntry newEntry;
                        if (files[j].toString().toLowerCase().endsWith(".jar") && !list.contains(newEntry = JavaCore.newLibraryEntry((IPath)new Path(files[j].toString()), null, null))) {
                            list.add(newEntry);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return list;
    }

    public static void setDefaultWebDynproSourceAndOutputPaths(IJavaProject javaProject, IProgressMonitor monitor) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] classpathEntrys = new IClasspathEntry[]{};
        try {
            classpathEntrys = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "setDefaultWebDynproSourceAndOutputPaths(IJavaProject, IProgressMonitor)", e.getMessage(), e, false);
        }
        int i = 0;
        while (i < classpathEntrys.length) {
            if (classpathEntrys[i].getEntryKind() != 3) {
                list.add(classpathEntrys[i]);
            }
            ++i;
        }
        list.add(0, WDRuntimeVariableClasspathInitializer.getWebDynproGenSourcePath(javaProject));
        list.add(0, WDRuntimeVariableClasspathInitializer.getDictionaryGenSourcePath(javaProject));
        list.add(0, WDRuntimeVariableClasspathInitializer.getSourcePath(javaProject));
        IFolder outputFolder = javaProject.getProject().getFolder(OUTPUT_PATH_ENTRY);
        if (!outputFolder.exists()) {
            try {
                outputFolder.create(true, true, monitor);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "setDefaultWebDynproSourceAndOutputPaths(IJavaProject, IProgressMonitor)", e.getMessage(), e, false);
            }
        }
        IPath outputPath = outputFolder.getFullPath();
        classpathEntrys = new IClasspathEntry[list.size()];
        classpathEntrys = list.toArray(classpathEntrys);
        try {
            javaProject.setRawClasspath(classpathEntrys, outputPath, monitor);
        }
        catch (JavaModelException e) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer = WDRuntimeVariableClasspathInitializer.class$("com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer")) : class$com$sap$ide$webdynpro$archivebuilder$project$WDRuntimeVariableClasspathInitializer, "setDefaultWebDynproSourceAndOutputPaths(IJavaProject, IProgressMonitor)", e.getMessage(), e, false);
        }
    }

    private static void addDCReference(DevelopmentComponent developmentComponent, DCReferenceNameStorage nameStorage) {
        Dependency dependency;
        DCReference aNewDCRef = new DCReference(nameStorage.getName(), nameStorage.getVendor());
        List list = developmentComponent.getDependencies();
        Iterator it = list.iterator();
        boolean found = false;
        while (it.hasNext()) {
            dependency = (Dependency)it.next();
            if (!dependency.getComponent().getName().equals(nameStorage.getName()) || !dependency.getComponent().getVendor().equals(nameStorage.getVendor())) continue;
            found = true;
            break;
        }
        if (!found) {
            dependency = ComponentFactory.createDependency((DCReference)aNewDCRef, (DevelopmentComponent)developmentComponent);
            dependency.setPublicPart(nameStorage.getPP());
            dependency.setAtBuildTime(true);
        }
    }

    private static ArrayList getInitialWDDCReferences() {
        ArrayList<DCReferenceNameStorage> list = new ArrayList<DCReferenceNameStorage>();
        list.add(new DCReferenceNameStorage("tc/cmi", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("tc/ddic/ddicruntime", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("tc/ddic/metamodel/content", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("tc/wd/webdynpro", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("tc/logging", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("tc/wdp/metamodel/content", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("com.sap.aii.proxy.framework", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("com.sap.aii.util.misc", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("com.sap.exception", "sap.com", "default"));
        list.add(new DCReferenceNameStorage("com.sap.mw.jco", "sap.com", "default"));
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DCReferenceNameStorage {
        private String mName = null;
        private String mVendor = null;
        private String mPP = null;

        public DCReferenceNameStorage(String name, String vendor, String pp) {
            this.mName = name;
            this.mVendor = vendor;
            this.mPP = pp;
        }

        public String getName() {
            return this.mName;
        }

        public String getVendor() {
            return this.mVendor;
        }

        public String getPP() {
            return this.mPP;
        }
    }

    private static class DcdefReadonlyMessageRunnable
    implements Runnable {
        private IProject mProject = null;

        public DcdefReadonlyMessageRunnable(IProject project) {
            this.mProject = project;
        }

        public void run() {
            String message = mTextPool.getText(30, this.mProject.getName());
            ServicesUI.askUserToConfirm((String)mTextPool.getText(31), (String)message);
        }
    }
}

