/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder.project;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.ReloadMetadataAction;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.archivebuilder.ActionGeneratePAR;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.archivebuilder.project.WDRuntimeVariableClasspathInitializer;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class ProjectService
implements IRunnableWithProgress {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final com.sap.ide.metamodel.core.services.TextPool mMMCTextPool = com.sap.ide.metamodel.core.services.TextPool.getInstance();
    private static boolean mGoOn = true;
    private IProject mProject = null;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService;

    private ProjectService(IProject project) {
        this.mProject = project;
    }

    public static void repairProject(IProject project) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(mTextPool.getText(36));
        buffer.append("\n");
        buffer.append(mTextPool.getText(37));
        buffer.append("\n");
        buffer.append(mTextPool.getText(38));
        if (com.sap.ide.metamodel.core.services.ServicesEclipse.projectHasComponentNature((String)project.getName())) {
            buffer.append("\n");
            buffer.append(mTextPool.getText(39));
        }
        if (!UIHelper.askUserToRepair((String)project.getName(), (String)mTextPool.getText(35), (String)buffer.toString())) {
            return;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel((String)project.getName());
        if (metamodel.isModified()) {
            mGoOn = true;
            Display.getCurrent().syncExec((Runnable)new AskUserToConfirmReloadRunnable(project));
            if (!mGoOn) {
                return;
            }
        }
        ProjectService service = new ProjectService(project);
        Display.getDefault().syncExec((Runnable)new RepairRunnable(service, project));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        WebDynproRoot root = MetamodelServices.getWebDynproRoot((String)this.mProject.getName());
        Application[] applications = null;
        try {
            applications = root.getApplications();
        }
        catch (LoadException e) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService = ProjectService.class$("com.sap.ide.webdynpro.archivebuilder.project.ProjectService")) : class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService, "repairProject(IProject)", e.getMessage(), e, false);
            applications = new Application[]{};
        }
        Component[] components = null;
        try {
            components = root.getComponents();
        }
        catch (LoadException e) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService = ProjectService.class$("com.sap.ide.webdynpro.archivebuilder.project.ProjectService")) : class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService, "repairProject(IProject)", e.getMessage(), e, false);
            components = new Component[]{};
        }
        ComponentInterfaceDefinition[] componentInterfaceDefinitions = null;
        try {
            componentInterfaceDefinitions = root.getComponentInterfaceDefinitions();
        }
        catch (LoadException e) {
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService = ProjectService.class$("com.sap.ide.webdynpro.archivebuilder.project.ProjectService")) : class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService, "repairProject(IProject)", e.getMessage(), e, false);
            componentInterfaceDefinitions = new ComponentInterfaceDefinition[]{};
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        dialog.open();
        try {
            block17: {
                try {
                    IJavaProject javaProject;
                    dialog.getProgressMonitor().setTaskName(mTextPool.getText(2));
                    PARService.createFolderStructure(this.mProject);
                    int i = 0;
                    while (i < applications.length) {
                        PARService.createApplicationFilesAndFolders(applications[i]);
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < components.length) {
                        PARService.createComponentFilesAndFolders(components[i2]);
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < componentInterfaceDefinitions.length) {
                        PARService.createComponentInterfaceDefinitionFilesAndFolders(componentInterfaceDefinitions[i3]);
                        ++i3;
                    }
                    boolean projectFileReadOnly = false;
                    IFile file = this.mProject.getFile(".project");
                    if (file.exists() && file.isReadOnly() && !com.sap.ide.metamodel.core.services.ServicesEclipse.projectHasComponentNature((String)this.mProject.getName())) {
                        MMRepositoryObject repositoryObject = new MMRepositoryObject(MetamodelServices.getMetamodel((String)this.mProject.getName()), "Project file", "", false);
                        IPath path = file.getProjectRelativePath();
                        repositoryObject.addAdditionalFile(path);
                        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
                        repositoryObjectList.addRepositoryObject(repositoryObject);
                        RepositoryServices.checkout((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
                        if (file.isReadOnly()) {
                            projectFileReadOnly = true;
                        }
                    }
                    boolean classpathFileReadOnly = false;
                    file = this.mProject.getFile(".classpath");
                    if (file.exists() && file.isReadOnly() && !com.sap.ide.metamodel.core.services.ServicesEclipse.projectHasComponentNature((String)this.mProject.getName())) {
                        MMRepositoryObject repositoryObject = new MMRepositoryObject(MetamodelServices.getMetamodel((String)this.mProject.getName()), "Classpath file", "", false);
                        IPath path = file.getProjectRelativePath();
                        repositoryObject.addAdditionalFile(path);
                        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
                        repositoryObjectList.addRepositoryObject(repositoryObject);
                        RepositoryServices.checkout((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
                        if (file.isReadOnly()) {
                            classpathFileReadOnly = true;
                        }
                    }
                    if (projectFileReadOnly || classpathFileReadOnly || (javaProject = com.sap.ide.metamodel.core.services.ServicesEclipse.getJavaProject((String)this.mProject.getName())) == null) break block17;
                    WDRuntimeVariableClasspathInitializer.setDefaultWebDynproSourceAndOutputPaths(javaProject, dialog.getProgressMonitor());
                    WDRuntimeVariableClasspathInitializer.updateClasspathEntries(javaProject, dialog.getProgressMonitor(), true);
                }
                catch (Exception e) {
                    ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService = ProjectService.class$("com.sap.ide.webdynpro.archivebuilder.project.ProjectService")) : class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService, "repairProject(IProject)", e.getMessage(), e, false);
                    Object var18_23 = null;
                    dialog.close();
                    return;
                }
            }
            Object var18_22 = null;
            dialog.close();
            return;
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            dialog.close();
            throw throwable;
        }
    }

    public static boolean checkForProjectErrors(IProject project) {
        boolean result = true;
        if (project != null && project.isAccessible()) {
            IMarker[] markers = new IMarker[]{};
            try {
                markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService == null ? (class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService = ProjectService.class$("com.sap.ide.webdynpro.archivebuilder.project.ProjectService")) : class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService, "checkForProjectErrors(IProject)", e.getMessage(), e, false);
            }
            int i = 0;
            while (i < markers.length) {
                try {
                    int severity;
                    Object severityObject = markers[i].getAttribute("severity");
                    if (severityObject instanceof Integer && (severity = ((Integer)severityObject).intValue()) == 2) {
                        result = false;
                        break;
                    }
                }
                catch (CoreException e) {
                    ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService == null ? ProjectService.class$("com.sap.ide.webdynpro.archivebuilder.project.ProjectService") : class$com$sap$ide$webdynpro$archivebuilder$project$ProjectService, "checkForProjectErrors(IProject)", e.getMessage(), e, false);
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean performGenerationForArchive(IProject project) {
        if (!ServicesEclipse.projectHasWebDynproNature((String)project.getName())) {
            return false;
        }
        ActionGeneratePAR action = new ActionGeneratePAR(project);
        action.run(true);
        return action.isError();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RepairRunnable
    implements Runnable {
        private ProjectService mService = null;
        private IProject mProject = null;

        public RepairRunnable(ProjectService service, IProject project) {
            this.mService = service;
            this.mProject = project;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block5: {
                WorkspaceModifyDelegatingOperation operation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this.mService);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                try {
                    try {
                        dialog.run(false, true, (IRunnableWithProgress)operation);
                    }
                    catch (InvocationTargetException e) {
                        ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                        Object var7_5 = null;
                        dialog.close();
                        break block5;
                    }
                    catch (InterruptedException e) {
                        ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                        Object var7_6 = null;
                        dialog.close();
                        break block5;
                    }
                    Object var7_4 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    dialog.close();
                    throw throwable;
                }
                dialog.close();
            }
            MetamodelManager.reloadMetamodel((String)this.mProject.getName());
            ReloadMetadataAction reloadMetadataAction = new ReloadMetadataAction();
            reloadMetadataAction.rebuildProject(this.mProject);
        }
    }

    private static class AskUserToConfirmReloadRunnable
    implements Runnable {
        private IProject mProject = null;

        public AskUserToConfirmReloadRunnable(IProject project) {
            this.mProject = project;
        }

        public void run() {
            String message = mTextPool.getText(27, this.mProject.getName());
            if (!ServicesUI.askUserToDecide((String)mTextPool.getText(26), (String)message)) {
                mGoOn = false;
            }
        }
    }
}

