/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder;

import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.tssap.dii.component.IDCProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class PARService {
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final String RUNTIME_PLUGIN_ID = "com.sap.tc.webdynpro.runtime";
    public static final String EXTENSION_WDA = ".wda";
    public static final String EXTENSION_SDA = ".ear";
    public static final String PATH_SEP = "/";
    public static final String DC_NAME_SEPARATOR = "~";
    public static final String EMPTY_STRING = "";
    public static final String FOLDER_SOURCE = "src";
    public static final String FOLDER_PACKAGES = "packages";
    public static final String FOLDER_DATATYPES = "datatypes";
    public static final String FOLDER_MIMES = "mimes";
    public static final String FOLDER_APPLICATIONS = "Applications";
    public static final String FOLDER_COMPONENTS = "Components";
    public static final String FOLDER_COMPONENT_INTERFACES = "ComponentInterfaces";
    public static final String FOLDER_CONFIGURATION = "configuration";
    public static final String FOLDER_LIB = "lib";
    public static final String FOLDER_BIN = "bin";
    public static final String FOLDER_PLACEHOLDER_GEN_WDP = "$GEN_WDP";
    public static final String FOLDER_PLACEHOLDER_GEN_DDIC = "$GEN_DDIC";
    public static final String FOLDER_PLACEHOLDER_LIBDIR = "$LIBDIR";
    public static final String FOLDER_COMPLETE_MIMES = "src/mimes";
    public static final String FOLDER_PLACEHOLDER_COMPLETE_CONFIGURATION = "$GEN_WDP/configuration";
    private static final String LOCAL_FOLDER_GEN = "gen";
    private static final String LOCAL_FOLDER_DEPLOY = "deploy";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$archivebuilder$PARService;

    public static void prepareProject(IProject project) {
        PARService.createFolderStructure(project);
    }

    public static String getArchiveName(IProject project) {
        IDCExtendedProject componentProject = ServicesEclipse.getComponentProject((String)project.getName());
        if (componentProject != null) {
            return PARService.getArchiveNameFromDCProject((IDCProject)componentProject);
        }
        return project.getName();
    }

    public static String getWDAFileName(IProject project) {
        return PARService.getArchiveName(project) + EXTENSION_WDA;
    }

    public static String getEARFileName(IProject project) {
        return PARService.getArchiveName(project) + EXTENSION_SDA;
    }

    public static void createApplicationFilesAndFolders(Application application) {
        PARService.createWebDynproObjectFilesAndFolders((WebDynproObject)application);
    }

    public static void createComponentFilesAndFolders(Component component) {
        PARService.createWebDynproObjectFilesAndFolders((WebDynproObject)component);
    }

    public static void createComponentInterfaceDefinitionFilesAndFolders(ComponentInterfaceDefinition componentInterfaceDefinition) {
        PARService.createWebDynproObjectFilesAndFolders((WebDynproObject)componentInterfaceDefinition);
    }

    public static void copyComponentFilesAndFolders(Component source, Component target, IProgressMonitor monitor) {
        PARService.copyWebDynproFilesAndFolders((WebDynproObject)source, (WebDynproObject)target, monitor);
    }

    public static void copyApplicationFilesAndFolders(Application source, Application target, IProgressMonitor monitor) {
        PARService.copyWebDynproFilesAndFolders((WebDynproObject)source, (WebDynproObject)target, monitor);
    }

    public static void copyComponentInterfaceDefinitionFilesAndFolders(ComponentInterfaceDefinition source, ComponentInterfaceDefinition target, IProgressMonitor monitor) {
        PARService.copyWebDynproFilesAndFolders((WebDynproObject)source, (WebDynproObject)target, monitor);
    }

    private static void copyWebDynproFilesAndFolders(WebDynproObject source, WebDynproObject target, IProgressMonitor monitor) {
        PARService.createWebDynproObjectFilesAndFolders(target);
        IProject sourceProject = ServicesEclipse.getEclipseProject((DevelopmentObject)source);
        IWorkspace targetWorkspace = ServicesEclipse.getEclipseProject((DevelopmentObject)target).getWorkspace();
        IFolder sourceFolder = sourceProject.getFolder(PARService.getWebDynproObjectPublicFolderPath(source));
        IPath targetPath = null;
        if (sourceFolder != null && sourceFolder.exists()) {
            targetPath = ServicesEclipse.getEclipseProject((DevelopmentObject)target).getFolder(PARService.getWebDynproObjectPublicFolderPath(target)).getFullPath();
            try {
                sourceFolder.accept((IResourceVisitor)new CopyFilesAndFoldersVisitor(sourceFolder.getFullPath(), targetPath, targetWorkspace, monitor));
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$PARService == null ? (class$com$sap$ide$webdynpro$archivebuilder$PARService = PARService.class$("com.sap.ide.webdynpro.archivebuilder.PARService")) : class$com$sap$ide$webdynpro$archivebuilder$PARService, "copyWebDynproFilesAndFolders(WebDynproObject, WebDynproObject, IProgressMonitor)", "Error while copying folder src/mimes/...", e, false);
            }
        }
        if ((sourceFolder = sourceProject.getFolder(PARService.getWebDynproObjectSrcConfigurationFolderPath(source))) != null && sourceFolder.exists()) {
            targetPath = ServicesEclipse.getEclipseProject((DevelopmentObject)target).getFolder(PARService.getWebDynproObjectSrcConfigurationFolderPath(target)).getFullPath();
            try {
                sourceFolder.accept((IResourceVisitor)new CopyFilesAndFoldersVisitor(sourceFolder.getFullPath(), targetPath, targetWorkspace, monitor));
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$PARService == null ? (class$com$sap$ide$webdynpro$archivebuilder$PARService = PARService.class$("com.sap.ide.webdynpro.archivebuilder.PARService")) : class$com$sap$ide$webdynpro$archivebuilder$PARService, "copyWebDynproFilesAndFolders(WebDynproObject, WebDynproObject, IProgressMonitor)", "Error while copying folder src/configuration/...", e, false);
            }
        }
    }

    private static void createWebDynproObjectFilesAndFolders(WebDynproObject webDynproObject) {
        IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)webDynproObject);
        IPath path = PARService.getWebDynproObjectPublicFolderPath(webDynproObject);
        PARService.createFolderStructure(path, (IContainer)project, ServicesEclipse.projectHasComponentNature((String)project.getName()));
        path = PARService.getWebDynproObjectSrcConfigurationFolderPath(webDynproObject);
        PARService.createFolderStructure(path, (IContainer)project, ServicesEclipse.projectHasComponentNature((String)project.getName()));
    }

    private static IPath getWebDynproObjectPublicFolderPath(WebDynproObject webDynproObject) {
        IPath path = new Path(FOLDER_SOURCE).append(FOLDER_MIMES);
        if (webDynproObject instanceof Application) {
            path = path.append(FOLDER_APPLICATIONS);
        } else if (webDynproObject instanceof Component) {
            path = path.append(FOLDER_COMPONENTS);
        } else if (webDynproObject instanceof ComponentInterfaceDefinition) {
            path = path.append(FOLDER_COMPONENT_INTERFACES);
        }
        path = path.append(((MainDevelopmentObject)webDynproObject).getQualifiedName());
        return path;
    }

    public static IPath getWebDynproObjectSrcConfigurationFolderPath(WebDynproObject webDynproObject) {
        IPath path = new Path(FOLDER_SOURCE).append(FOLDER_CONFIGURATION);
        if (webDynproObject instanceof Application) {
            path = path.append(FOLDER_APPLICATIONS);
        } else if (webDynproObject instanceof Component) {
            path = path.append(FOLDER_COMPONENTS);
        } else if (webDynproObject instanceof ComponentInterfaceDefinition) {
            path = path.append(FOLDER_COMPONENT_INTERFACES);
        }
        path = path.append(((MainDevelopmentObject)webDynproObject).getQualifiedName());
        return path;
    }

    public static void createFolderStructure(IProject project) {
        String[] folders = new String[]{FOLDER_SOURCE, "src/packages", FOLDER_COMPLETE_MIMES, "src/mimes/Applications", "src/mimes/Components", "src/mimes/ComponentInterfaces", "src/configuration", "src/configuration/Applications", "src/configuration/Components", "src/configuration/ComponentInterfaces", "$GEN_WDP/packages", FOLDER_PLACEHOLDER_COMPLETE_CONFIGURATION, "$GEN_DDIC/datatypes", "META-INF", FOLDER_PLACEHOLDER_LIBDIR, FOLDER_BIN};
        boolean isDCProject = ServicesEclipse.projectHasComponentNature((String)project.getName());
        int i = 0;
        while (i < folders.length) {
            Path path = new Path(folders[i]);
            PARService.createFolderStructure((IPath)path, (IContainer)project, isDCProject);
            ++i;
        }
    }

    private static void createFolderStructure(IPath folderStructure, IContainer parentFolder, boolean isDCProject) {
        String[] subfolders = folderStructure.segments();
        int j = 0;
        while (j < subfolders.length) {
            if (subfolders[j].equals(FOLDER_PLACEHOLDER_LIBDIR)) {
                if (isDCProject) {
                    return;
                }
                subfolders[j] = FOLDER_LIB;
            } else if (subfolders[j].equals(FOLDER_PLACEHOLDER_GEN_WDP)) {
                subfolders[j] = com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse.getGenerationOutputPathInfix();
            } else if (subfolders[j].equals(FOLDER_PLACEHOLDER_GEN_DDIC)) {
                subfolders[j] = GenerationEclipse.getGenerationOutputPathInfix();
            }
            Path folderPath = new Path(subfolders[j]);
            IFolder folder = parentFolder.getFolder((IPath)folderPath);
            if (!folder.getLocation().toFile().exists()) {
                try {
                    folder.create(true, true, null);
                }
                catch (CoreException e) {
                    ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$PARService == null ? PARService.class$("com.sap.ide.webdynpro.archivebuilder.PARService") : class$com$sap$ide$webdynpro$archivebuilder$PARService, "createFolderStructure(IPath, IContainer, boolean)", e.getMessage(), e, false);
                }
            }
            parentFolder = folder;
            ++j;
        }
    }

    public static String getWebDynproObjectPublicFolder(WebDynproObject webDynproObject) {
        IPath path = PARService.getWebDynproObjectPublicFolderPath(webDynproObject);
        return path.toOSString();
    }

    public static String getDictionaryGenerationFolder() {
        String[] subfolders = new Path(FOLDER_PLACEHOLDER_GEN_DDIC).segments();
        Path path = new Path(EMPTY_STRING);
        int i = 0;
        while (i < subfolders.length) {
            if (subfolders[i].equals(FOLDER_PLACEHOLDER_GEN_DDIC)) {
                subfolders[i] = GenerationEclipse.getGenerationOutputPathInfix();
            }
            path = path.append(subfolders[i]);
            ++i;
        }
        return path.toOSString();
    }

    public static String getWebDynproGenerationFolder() {
        String[] subfolders = new Path(FOLDER_PLACEHOLDER_GEN_WDP).segments();
        Path path = new Path(EMPTY_STRING);
        int i = 0;
        while (i < subfolders.length) {
            if (subfolders[i].equals(FOLDER_PLACEHOLDER_GEN_WDP)) {
                subfolders[i] = com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse.getGenerationOutputPathInfix();
            }
            path = path.append(subfolders[i]);
            ++i;
        }
        return path.toOSString();
    }

    public static String getConfigurationFolder() {
        String[] subfolders = new Path(FOLDER_PLACEHOLDER_COMPLETE_CONFIGURATION).segments();
        Path path = new Path(EMPTY_STRING);
        int i = 0;
        while (i < subfolders.length) {
            if (subfolders[i].equals(FOLDER_PLACEHOLDER_GEN_WDP)) {
                subfolders[i] = com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse.getGenerationOutputPathInfix();
            }
            path = path.append(subfolders[i]);
            ++i;
        }
        return path.toOSString();
    }

    public static String getOutputFolder() {
        return new Path(FOLDER_BIN).toOSString();
    }

    private static String getArchiveNameFromDCProject(IDCProject project) {
        String dcVendor = project.getDCVendor();
        String dcName = project.getDCName();
        if (dcName == null) {
            Exception e = new Exception("Could not get name for DC project");
            ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$PARService == null ? (class$com$sap$ide$webdynpro$archivebuilder$PARService = PARService.class$("com.sap.ide.webdynpro.archivebuilder.PARService")) : class$com$sap$ide$webdynpro$archivebuilder$PARService, "getArchiveNameFromDCProject(IDCProject)", e.getMessage(), e, false);
            return EMPTY_STRING;
        }
        dcName = dcName.replace('/', '~');
        return dcVendor + DC_NAME_SEPARATOR + dcName;
    }

    public static IContainer getArchiveFolder(IProject project, IProgressMonitor monitor) {
        IProject earFolder = project;
        if (ServicesEclipse.projectHasComponentNature((String)project.getName())) {
            try {
                String buildVariant;
                IFolder folder = project.getFolder(LOCAL_FOLDER_GEN);
                if (!folder.getLocation().toFile().exists()) {
                    folder.create(true, true, monitor);
                    folder.setDerived(true);
                }
                if ((buildVariant = ServicesEclipse.getComponentProject((String)project.getName()).getBuildVariant()) != null) {
                    if (!(folder = folder.getFolder(buildVariant)).getLocation().toFile().exists()) {
                        folder.create(true, true, monitor);
                        folder.setDerived(true);
                    }
                    if (!(folder = folder.getFolder(LOCAL_FOLDER_DEPLOY)).getLocation().toFile().exists()) {
                        folder.create(true, true, monitor);
                        folder.setDerived(true);
                    }
                    return folder;
                }
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(class$com$sap$ide$webdynpro$archivebuilder$PARService == null ? (class$com$sap$ide$webdynpro$archivebuilder$PARService = PARService.class$("com.sap.ide.webdynpro.archivebuilder.PARService")) : class$com$sap$ide$webdynpro$archivebuilder$PARService, "run()", e.getMessage(), e, false);
                return project;
            }
        }
        return project;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class CopyFilesAndFoldersVisitor
    implements IResourceVisitor {
        private IPath mSourcePath;
        private IPath mTargetPath;
        private IWorkspace mTargetWorkspace;
        private IProgressMonitor mMonitor;

        public CopyFilesAndFoldersVisitor(IPath sourcePath, IPath targetPath, IWorkspace targetWorkspace, IProgressMonitor monitor) {
            this.mSourcePath = sourcePath;
            this.mTargetPath = targetPath;
            this.mTargetWorkspace = targetWorkspace;
            this.mMonitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 || resource.getType() == 2) {
                IPath resourcePath = resource.getFullPath();
                if (resourcePath.equals((Object)this.mSourcePath)) {
                    return true;
                }
                IPath target = this.mTargetPath.append(resourcePath.lastSegment());
                if (!this.mTargetWorkspace.getRoot().exists(target)) {
                    resource.copy(target, false, this.mMonitor);
                }
            }
            return false;
        }
    }
}

