/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder;

import com.sap.ide.metamodel.core.services.MultilineTextDialog;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.tssap.tools.archive.ArchiveBuildException;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IMutablePattern;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class PARBuilder {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String NAME_PORTALAPP_XML = "portalapp.xml";
    private static final String NAME_SDM_DESCRIPTOR = "wd.xml";
    private static final String NAME_SDM_MANIFEST = "MANIFEST.MF";
    private static final String NAME_SDM_SAP_MANIFEST = "SAP_MANIFEST.MF";
    private static final String NAME_APPLICATION_XML = "application.xml";
    private static final String NAME_APPLICATION_J2EE_ENGINE_XML = "application-j2ee-engine.xml";
    private static final String NAME_LOG_CONFIGURATION = "log-configuration.xml";
    private static final String NAME_GRMG_CONFIGURATION = "grmg-customizing.xml";
    private static final String FOLDER_META_INF = "META-INF";
    private static final String FOLDER_PORTALINF = "PORTAL-INF";
    private static final String FOLDER_PORTALINF_CLASSES = "PORTAL-INF/classes";
    private static final String FOLDER_PORTALINF_SRCLIB = "PORTAL-INF/srclib";
    private static final String FOLDER_PORTALINF_LIB = "PORTAL-INF/lib";
    private static final String FOLDER_PORTALINF_PRIVATE_LIB = "PORTAL-INF/private/lib";
    private static final String FOLDER_PORTALINF_WEBDYNPRO = "PORTAL-INF/webdynpro";
    private static final String FOLDER_PRIVATE_CLASSES = "private/classes";
    private static final String FOLDER_PRIVATE_SRCLIB = "private/srclib";
    private static final String FOLDER_PRIVATE_LIB = "private/lib";
    private static final String FOLDER_PRIVATE_WEBDYNPRO = "private/webdynpro";
    private static final String FOLDER_SCR_CONFIG = "src/configuration";
    private static final String FOLDER_PUBLIC = "public";
    private static final String EXTENSION_SOURCE_ARCHIVE = ".src.jar";
    private static final String EXTENSION_CLASSES_ARCHIVE = ".jar";
    private static final String NAME_CLASSES_JAR = "app.jar";
    private static final String[] RUNTIME_FILES_EXCEPTION_LIST = new String[]{".wdcomponent", ".wdwindow", ".wdnavigation", ".wdcontroller", ".wdview", ".wdcomponentinterface", ".wdinterfaceview", ".wdmessagepool", ".xlf", ".wdproperties", ".wdapplication", ".wdcompinterfacedef", ".wdmodel", ".wdmodelclass", ".dtsimpletype", ".dtstructure", ".dtlogicalddic"};
    private IProject mProject = null;
    private IProgressMonitor mMonitor = null;

    public PARBuilder(IProject project, IProgressMonitor monitor) {
        this.mProject = project;
        this.mMonitor = monitor;
    }

    public boolean run() {
        String earName;
        IFile file;
        this.mMonitor.beginTask(mTextPool.getText(3), 100);
        this.mMonitor.setTaskName(mTextPool.getText(3));
        boolean classesAsArchive = ArchiveBuilderPlugin.getDefault().getPluginPreferences().getBoolean("classes_as_archive");
        boolean isDCProject = ServicesEclipse.projectHasComponentNature((String)this.mProject.getName());
        String earPath = "/";
        IContainer earFolder = PARService.getArchiveFolder(this.mProject, this.mMonitor);
        if (isDCProject) {
            earPath = earFolder.getFullPath().removeFirstSegments(1).toString() + "/";
        }
        if ((file = earFolder.getFile((IPath)new Path(earName = PARService.getEARFileName(this.mProject)))).exists()) {
            try {
                file.delete(true, this.mMonitor);
            }
            catch (CoreException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                return false;
            }
        }
        IArchiveDescriptor earDescriptor = ArchiveDescriptionManager.newArchiveDescription();
        earDescriptor.setDestPath(this.mProject, earPath + earName);
        earDescriptor.setCompressed(true);
        IProjectFileSet earFiles = ArchiveDescriptionManager.getProjectFileSet();
        earFiles.addProjectFiles((IContainer)this.mProject.getFolder(PARService.getWebDynproGenerationFolder()), this.getEarPattern(), FOLDER_META_INF);
        earFiles.addProjectFiles((IContainer)this.mProject.getFolder(FOLDER_META_INF), this.getAdditionalEarPattern());
        earFiles.addProjectFiles((IContainer)this.mProject.getFolder(FOLDER_META_INF), this.getAdditionalEarMetaInfPattern(), FOLDER_META_INF);
        earDescriptor.addFileSet((IFileSet)earFiles);
        String parName = PARService.getWDAFileName(this.mProject);
        IArchiveDescriptor wdaDescriptor = ArchiveDescriptionManager.newArchiveDescription();
        wdaDescriptor.setDestPath(this.mProject, "/" + parName);
        wdaDescriptor.setCompressed(true);
        this.mMonitor.worked(5);
        IProjectFileSet publicFiles = ArchiveDescriptionManager.getProjectFileSet();
        publicFiles.addProjectFiles((IContainer)this.mProject.getFolder("src/mimes"), this.getPublicFolderPattern());
        wdaDescriptor.addFileSet((IFileSet)publicFiles);
        this.mMonitor.worked(10);
        if (!classesAsArchive) {
            IProjectFileSet additionalClassesFiles = ArchiveDescriptionManager.getProjectFileSet();
            additionalClassesFiles.addRelativeFile(this.mProject, RelativePath.CLASSES, this.getAdditionalClassesFolderPattern(), FOLDER_PORTALINF_CLASSES);
            wdaDescriptor.addFileSet((IFileSet)additionalClassesFiles);
        } else {
            IArchiveDescriptor classesLibDescriptor = ArchiveDescriptionManager.newArchiveDescription();
            classesLibDescriptor.setDestPath(this.mProject, "/app.jar");
            classesLibDescriptor.setCompressed(true);
            IProjectFileSet additionalClassesFiles = ArchiveDescriptionManager.getProjectFileSet();
            additionalClassesFiles.addRelativeFile(this.mProject, RelativePath.CLASSES, this.getAdditionalClassesFolderPattern());
            classesLibDescriptor.addFileSet((IFileSet)additionalClassesFiles);
            wdaDescriptor.addNestedArchive((IArchive)classesLibDescriptor, true, "PORTAL-INF/lib/app.jar");
        }
        this.mMonitor.worked(30);
        IProjectFileSet configFiles = ArchiveDescriptionManager.getProjectFileSet();
        configFiles.addProjectFiles((IContainer)this.mProject.getFolder(PARService.getConfigurationFolder()), this.getConfigFolderPattern630(), FOLDER_PORTALINF_WEBDYNPRO);
        wdaDescriptor.addFileSet((IFileSet)configFiles);
        IProjectFileSet srcConfigFiles = ArchiveDescriptionManager.getProjectFileSet();
        srcConfigFiles.addProjectFiles((IContainer)this.mProject.getFolder(FOLDER_SCR_CONFIG), this.getConfigFolderPattern630(), FOLDER_PORTALINF_WEBDYNPRO);
        wdaDescriptor.addFileSet((IFileSet)srcConfigFiles);
        IProjectFileSet portalappFile = ArchiveDescriptionManager.getProjectFileSet();
        portalappFile.addProjectFiles((IContainer)this.mProject.getFolder(PARService.getWebDynproGenerationFolder()), this.getPortalAppPattern(), FOLDER_PORTALINF);
        wdaDescriptor.addFileSet((IFileSet)portalappFile);
        this.mMonitor.worked(40);
        if (!isDCProject) {
            IProjectFileSet libFiles = ArchiveDescriptionManager.getProjectFileSet();
            libFiles.addProjectFiles((IContainer)this.mProject.getFolder("lib"), this.getLibFolderPattern(classesAsArchive), FOLDER_PORTALINF_LIB);
            wdaDescriptor.addFileSet((IFileSet)libFiles);
        }
        this.mMonitor.worked(50);
        IProjectFileSet wdaFiles = ArchiveDescriptionManager.getProjectFileSet();
        wdaFiles.addProjectFiles((IContainer)this.mProject.getFolder(PARService.getWebDynproGenerationFolder()), this.getWdaPattern(), FOLDER_META_INF);
        wdaDescriptor.addFileSet((IFileSet)wdaFiles);
        earDescriptor.addNestedArchive((IArchive)wdaDescriptor, true, PARService.getWDAFileName(this.mProject));
        this.mMonitor.worked(60);
        try {
            earDescriptor.performBuild();
        }
        catch (ArchiveBuildException e) {
            MultilineTextDialog dialog = new MultilineTextDialog(mTextPool.getText(504), e.getMessage());
            dialog.open();
            dialog.close();
            return false;
        }
        file = earFolder.getFile((IPath)new Path(earName));
        try {
            file.refreshLocal(1, this.mMonitor);
            file.setDerived(true);
        }
        catch (CoreException e) {
            ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
        }
        this.mMonitor.worked(100);
        this.mMonitor.done();
        return true;
    }

    private IPattern getEarPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern(NAME_SDM_DESCRIPTOR);
        pattern.addIncludePattern(NAME_SDM_MANIFEST);
        pattern.addIncludePattern(NAME_SDM_SAP_MANIFEST);
        pattern.addIncludePattern(NAME_APPLICATION_XML);
        pattern.addIncludePattern(NAME_APPLICATION_J2EE_ENGINE_XML);
        return pattern;
    }

    private IPattern getAdditionalEarPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern(NAME_LOG_CONFIGURATION);
        return pattern;
    }

    private IPattern getAdditionalEarMetaInfPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern("**");
        pattern.addExcludePattern(this.getEarPattern().getIncludePatterns());
        pattern.addExcludePattern(this.getAdditionalEarPattern().getIncludePatterns());
        return pattern;
    }

    private IPattern getPublicFolderPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern("*/**");
        return pattern;
    }

    private IPattern getConfigFolderPattern620() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern("*/**");
        return pattern;
    }

    private IPattern getConfigFolderPattern630() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern("*/**");
        pattern.addExcludePattern("directory.properties");
        return pattern;
    }

    private IPattern getPortalAppPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern(NAME_PORTALAPP_XML);
        return pattern;
    }

    private IArchiveDescriptor createSrcArchive() {
        IArchiveDescriptor archiveDescriptor = ArchiveDescriptionManager.newArchiveDescription();
        archiveDescriptor.setDestPath(this.mProject, this.getSrcJarName());
        archiveDescriptor.setCompressed(true);
        IProjectFileSet srcFiles = ArchiveDescriptionManager.getProjectFileSet();
        srcFiles.addRelativeFile(this.mProject, RelativePath.SOURCE, this.getSrcArchivePattern());
        archiveDescriptor.addFileSet((IFileSet)srcFiles);
        return archiveDescriptor;
    }

    private IPattern getSrcArchivePattern() {
        IMutablePattern pattern = Pattern.getPattern((IPattern)Pattern.getPattern((int)3));
        pattern.addExcludePattern("*.class");
        return pattern;
    }

    private String getSrcJarName() {
        return this.getFileName() + EXTENSION_SOURCE_ARCHIVE;
    }

    private String getFileName() {
        return "/" + PARService.getArchiveName(this.mProject);
    }

    private IPattern getClassesFolderPattern() {
        IMutablePattern pattern = Pattern.getPattern((IPattern)Pattern.getPattern((int)1));
        return pattern;
    }

    private IPattern getAdditionalClassesFolderPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        int i = 0;
        while (i < RUNTIME_FILES_EXCEPTION_LIST.length) {
            pattern.addExcludePattern("**/*" + RUNTIME_FILES_EXCEPTION_LIST[i]);
            ++i;
        }
        return pattern;
    }

    private IPattern getLibFolderPattern(boolean classesAsArchive) {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern("*.jar");
        if (classesAsArchive) {
            pattern.addExcludePattern(NAME_CLASSES_JAR);
        }
        return pattern;
    }

    private IPattern getWdaPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern(NAME_SDM_MANIFEST);
        return pattern;
    }
}

