/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.help.ui.browser.LaunchURL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ActionTestApplication
extends Action {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String PROTOCOL = "http";
    private static final String SERVER_PATH_PREFIX = "/webdynpro/dispatcher/";
    private Application mApplication = null;
    private IPreferenceStore mStore = null;
    private Vector mAdditionalParameters = null;
    private String mDebugExtension = null;
    private static int msTestId = 0;

    public ActionTestApplication(Application application) {
        this.mApplication = application;
        this.mStore = ArchiveBuilderPlugin.getDefault().getPreferenceStore();
        this.mAdditionalParameters = new Vector();
        String standardParameters = this.getParameters();
        if (standardParameters != null) {
            this.mAdditionalParameters.add(standardParameters);
        }
        this.mAdditionalParameters.add("SAPtestId=" + Integer.toString(msTestId));
        ++msTestId;
    }

    public void addAdditionalParameter(String parameter) {
        this.mAdditionalParameters.add(parameter);
    }

    public void run() {
        Display.getDefault().syncExec((Runnable)new TestRunnable());
    }

    private void start(String url) {
        if (url == null || url.length() == 0) {
            this.showConfigurationErrorPopup();
            return;
        }
        LaunchURL launcher = new LaunchURL();
        try {
            launcher.setInitializationData((IConfigurationElement)new UrlConfigurationElement(url), null, null);
        }
        catch (CoreException e) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "start()", e.getMessage(), e, false);
            return;
        }
        launcher.run(null);
    }

    public String getApplicationUrl() {
        return this.getApplicationUrl(false);
    }

    private String getApplicationUrl(boolean addParameters) {
        EnginePlugin enginePlugin = EnginePlugin.getDefault();
        if (enginePlugin == null) {
            ArchiveBuilderPlugin.internalError(((Object)((Object)this)).getClass(), "constructApplicationUrl(String)", "Could not get engine plugin", new Exception(), false);
            return null;
        }
        String extension = null;
        String dcName = null;
        IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)this.mApplication);
        IDCExtendedProject componentProject = ServicesEclipse.getComponentProject((String)project.getName());
        if (componentProject != null) {
            extension = componentProject.getDCVendor();
            dcName = componentProject.getDCName().replace('/', '~');
        } else {
            extension = "local";
            dcName = ServicesEclipse.getEclipseProject((DevelopmentObject)this.mApplication).getName();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(PROTOCOL);
        buffer.append("://");
        String host = enginePlugin.getHttpHost();
        String port = enginePlugin.getHttpPort();
        if (host == null || port == null || host.length() < 1 || port.length() < 1) {
            return null;
        }
        buffer.append(host);
        buffer.append(":");
        buffer.append(port);
        if (this.mDebugExtension != null) {
            buffer.append(this.mDebugExtension);
        }
        buffer.append(SERVER_PATH_PREFIX);
        buffer.append(extension);
        buffer.append("/");
        buffer.append(dcName);
        buffer.append("/");
        buffer.append(this.mApplication.getName());
        if (addParameters) {
            String parameter;
            Enumeration enumeration = this.mAdditionalParameters.elements();
            if (enumeration.hasMoreElements()) {
                parameter = (String)enumeration.nextElement();
                buffer.append("?");
                buffer.append(parameter);
            }
            while (enumeration.hasMoreElements()) {
                parameter = (String)enumeration.nextElement();
                buffer.append("&");
                buffer.append(parameter);
            }
        }
        return buffer.toString();
    }

    private String getParameters() {
        String para = this.mStore.getString("parameters");
        if (para.length() > 0) {
            return para;
        }
        return null;
    }

    public void setDebugExtension(String extension) {
        this.mDebugExtension = extension;
    }

    private void showConfigurationErrorPopup() {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText(12), (String)mTextPool.getText(13));
    }

    private class TestRunnable
    implements Runnable {
        private TestRunnable() {
        }

        public void run() {
            String url = ActionTestApplication.this.getApplicationUrl(true);
            ActionTestApplication.this.start(url);
        }
    }

    private class UrlConfigurationElement
    implements IConfigurationElement {
        private String mUrl = null;

        public UrlConfigurationElement(String url) {
            this.mUrl = url;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            return null;
        }

        public String getAttribute(String name) {
            return this.mUrl;
        }

        public String getAttributeAsIs(String name) {
            return null;
        }

        public String[] getAttributeNames() {
            return null;
        }

        public IConfigurationElement[] getChildren() {
            return null;
        }

        public IConfigurationElement[] getChildren(String name) {
            return null;
        }

        public IExtension getDeclaringExtension() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getValue() {
            return null;
        }

        public String getValueAsIs() {
            return null;
        }
    }
}

