/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager;
import com.sap.ide.metamodel.webdynpro.project.ProjectProperties;
import com.sap.ide.webdynpro.archivebuilder.ArchiveBuilderPlugin;
import com.sap.ide.webdynpro.archivebuilder.PARBuilder;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.archivebuilder.project.ProjectService;
import com.sap.ide.webdynpro.generation.Generation;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ActionGeneratePAR {
    private static final TextPool mTextPool = TextPool.getInstance();
    private IProject mProject = null;
    private boolean mError = false;
    private boolean mAutobuildFlagChanged = false;
    private ProgressMonitorDialog mDialog = null;

    public ActionGeneratePAR(IProject project) {
        this.mProject = project;
    }

    public void run() {
        this.run(false);
    }

    public void run(boolean omitArchiveCreation) {
        final boolean lOmitArchiveCreation = omitArchiveCreation;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ActionGeneratePAR.this.mError = false;
                Display.getDefault().syncExec((Runnable)new AskUserToContinueInsteadOfAutobuildOffRunnable());
                if (ActionGeneratePAR.this.mError) {
                    return;
                }
                ActionGeneratePAR.this.mError = false;
                boolean projectIsOk = ProjectService.checkForProjectErrors(ActionGeneratePAR.this.mProject);
                if (!projectIsOk) {
                    Display.getDefault().syncExec((Runnable)new AskUserToContinueInsteadOfErrorsRunnable());
                    if (ActionGeneratePAR.this.mError) {
                        return;
                    }
                }
                try {
                    Display.getDefault().syncExec((Runnable)new OpenDialogRunnable());
                    Display.getDefault().syncExec((Runnable)new SaveRunnable());
                    ResourcesPlugin.getWorkspace().checkpoint(true);
                    Display.getDefault().syncExec((Runnable)new GenerationRunnable());
                    ResourcesPlugin.getWorkspace().checkpoint(true);
                    if (!lOmitArchiveCreation) {
                        Display.getDefault().syncExec((Runnable)new BuildRunnable());
                        ResourcesPlugin.getWorkspace().checkpoint(true);
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Display.getDefault().syncExec((Runnable)new CloseDialogRunnable());
                    throw throwable;
                }
                Display.getDefault().syncExec((Runnable)new CloseDialogRunnable());
                if (ActionGeneratePAR.this.mAutobuildFlagChanged) {
                    Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
                    preferences.setValue("description.autobuilding", false);
                    ActionGeneratePAR.this.mAutobuildFlagChanged = false;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
        }
    }

    private ArrayList removeNonLocalObjects(MainDevelopmentObject[] objects) {
        ArrayList<MainDevelopmentObject> list = new ArrayList<MainDevelopmentObject>();
        int i = 0;
        while (i < objects.length) {
            if (!objects[i].originatesInArchive()) {
                list.add(objects[i]);
            }
            ++i;
        }
        return list;
    }

    public boolean isError() {
        return this.mError;
    }

    private class AskUserToContinueInsteadOfErrorsRunnable
    implements Runnable {
        private AskUserToContinueInsteadOfErrorsRunnable() {
        }

        public void run() {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.TaskList");
            }
            catch (Exception e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, true);
            }
            String message = mTextPool.getText(33, ActionGeneratePAR.this.mProject.getName());
            if (!ServicesUI.askUserToConfirm((String)mTextPool.getText(34), (String)message, (int)1)) {
                ActionGeneratePAR.this.mError = true;
            }
        }
    }

    private class AskUserToContinueInsteadOfAutobuildOffRunnable
    implements Runnable {
        private AskUserToContinueInsteadOfAutobuildOffRunnable() {
        }

        public void run() {
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                String title = mTextPool.getText(28);
                String message = mTextPool.getText(29);
                String[] buttons = new String[]{mTextPool.getText(40), IDialogConstants.CANCEL_LABEL};
                MessageDialog dialog = ServicesUI.createMessageDialog((String)title, (String)message, (String[])buttons, (int)3, null, (int)1);
                if (dialog.open() != 0) {
                    ActionGeneratePAR.this.mError = true;
                } else {
                    Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
                    preferences.setValue("description.autobuilding", true);
                    ActionGeneratePAR.this.mAutobuildFlagChanged = true;
                    ResourcesPlugin.getWorkspace().checkpoint(true);
                }
            }
        }
    }

    private class CloseDialogRunnable
    implements Runnable {
        private CloseDialogRunnable() {
        }

        public void run() {
            ActionGeneratePAR.this.mDialog.close();
        }
    }

    private class BuildRunnable
    implements Runnable {
        private BuildRunnable() {
        }

        public void run() {
            try {
                PARBuilder builder = new PARBuilder(ActionGeneratePAR.this.mProject, ActionGeneratePAR.this.mDialog.getProgressMonitor());
                if (!builder.run()) {
                    ActionGeneratePAR.this.mError = true;
                }
            }
            catch (Exception e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
            }
        }
    }

    private class GenerationRunnable
    implements Runnable {
        private GenerationRunnable() {
        }

        public void run() {
            PARService.createFolderStructure(ActionGeneratePAR.this.mProject);
            Metamodel metamodel = MetamodelManager.getMetamodel((String)ActionGeneratePAR.this.mProject.getName());
            if (metamodel == null) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", "Could not get metamodel for project", new Exception(), false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            DtDictionaryRoot ddicRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)metamodel);
            DtLogicalDictionary[] logicalDictionaries = null;
            try {
                logicalDictionaries = ddicRoot.getLogicalDictionaries();
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            DtSimpleType[] simpleTypes = null;
            try {
                simpleTypes = ddicRoot.getSimpleTypes();
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            DtGeneralStructure[] structures = null;
            try {
                structures = ddicRoot.getStructures();
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            DtDbTable[] dbTables = null;
            try {
                dbTables = ddicRoot.getTables();
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            WebDynproRoot webDynproRoot = WebDynproRootManager.getWebDynproRoot((Metamodel)metamodel);
            Application[] applications = null;
            try {
                applications = webDynproRoot.getApplications();
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            Model[] models = null;
            try {
                models = webDynproRoot.getModels();
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            Component[] components = null;
            try {
                components = webDynproRoot.getComponents();
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            ComponentInterfaceDefinition[] componentInterfaceDefinitions = null;
            try {
                componentInterfaceDefinitions = webDynproRoot.getComponentInterfaceDefinitions();
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                return;
            }
            IDCExtendedProject componentProject = ServicesEclipse.getComponentProject((String)ActionGeneratePAR.this.mProject.getName());
            String vendor = null;
            String dcName = null;
            if (componentProject != null) {
                vendor = componentProject.getDCVendor();
                dcName = componentProject.getDCName();
            } else {
                vendor = "local";
                dcName = ActionGeneratePAR.this.mProject.getName();
            }
            ProjectProperties projectProperties = null;
            try {
                ProjectProperties[] allProperties = webDynproRoot.getAllProjectProperties();
                if (allProperties != null && allProperties.length > 0) {
                    projectProperties = allProperties[0];
                }
            }
            catch (LoadException e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
            }
            try {
                ActionGeneratePAR.this.mDialog.getProgressMonitor().setTaskName(mTextPool.getText(2));
                com.sap.dictionary.tools.generation.eclipse.GenerationEclipse dictionaryGeneration = new com.sap.dictionary.tools.generation.eclipse.GenerationEclipse(ActionGeneratePAR.this.mDialog.getProgressMonitor());
                dictionaryGeneration.setTargetPath(ActionGeneratePAR.this.mProject.getLocation().toFile().getAbsolutePath());
                dictionaryGeneration.setIncremental(false);
                dictionaryGeneration.refreshConfiguration();
                dictionaryGeneration.generatePersistentArchive(PARService.getArchiveName(ActionGeneratePAR.this.mProject), vendor, dcName, logicalDictionaries, simpleTypes, structures, dbTables, true, true, true);
                if (com.sap.dictionary.tools.generation.Generation.isErrorIndicator()) {
                    ActionGeneratePAR.this.mError = true;
                }
                dictionaryGeneration.cleanup();
                GenerationEclipse generation = new GenerationEclipse(ActionGeneratePAR.this.mDialog.getProgressMonitor());
                generation.setTargetPath(ActionGeneratePAR.this.mProject.getLocation().toFile().getAbsolutePath());
                generation.setIncremental(false);
                generation.refreshConfiguration();
                generation.generatePersistentArchive(PARService.getArchiveName(ActionGeneratePAR.this.mProject), vendor, dcName, projectProperties, applications, models, components, componentInterfaceDefinitions, simpleTypes, structures, true, true, true);
                if (Generation.isErrorIndicator()) {
                    ActionGeneratePAR.this.mError = true;
                }
                generation.cleanup();
            }
            catch (Exception e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                ActionGeneratePAR.this.mDialog.close();
            }
        }
    }

    private class SaveRunnable
    implements Runnable {
        private SaveRunnable() {
        }

        public void run() {
            try {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int j = 0;
                    while (j < pages.length) {
                        IEditorReference[] editors = pages[j].getEditorReferences();
                        int k = 0;
                        while (k < editors.length) {
                            IFile file;
                            IEditorInput input;
                            IEditorPart part = editors[k].getEditor(false);
                            if (part != null && part.isDirty() && (input = part.getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null && ActionGeneratePAR.this.mProject.equals((Object)file.getProject())) {
                                part.doSave(ActionGeneratePAR.this.mDialog.getProgressMonitor());
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ArchiveBuilderPlugin.internalError(this.getClass(), "run()", e.getMessage(), e, false);
                ActionGeneratePAR.this.mError = true;
                ActionGeneratePAR.this.mDialog.close();
            }
        }
    }

    private class OpenDialogRunnable
    implements Runnable {
        private OpenDialogRunnable() {
        }

        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ActionGeneratePAR.this.mDialog = new ProgressMonitorDialog(shell);
            ActionGeneratePAR.this.mDialog.open();
        }
    }
}

