/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder;

import com.sap.ide.eclipse.sdm.ISDMManagerListener;
import com.sap.ide.eclipse.sdm.SDMManager;
import com.sap.ide.webdynpro.archivebuilder.ActionGeneratePAR;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.archivebuilder.TextPool;
import com.sap.ide.webdynpro.ui.service.ServicesUI;
import com.sap.tc.logging.Location;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;

public class ActionDeployPAR {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static TracerI mTracer = TracingManager.getTracer((Class)(class$com$sap$ide$webdynpro$archivebuilder$ActionDeployPAR == null ? (class$com$sap$ide$webdynpro$archivebuilder$ActionDeployPAR = ActionDeployPAR.class$("com.sap.ide.webdynpro.archivebuilder.ActionDeployPAR")) : class$com$sap$ide$webdynpro$archivebuilder$ActionDeployPAR));
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$webdynpro$archivebuilder$ActionDeployPAR == null ? (class$com$sap$ide$webdynpro$archivebuilder$ActionDeployPAR = ActionDeployPAR.class$("com.sap.ide.webdynpro.archivebuilder.ActionDeployPAR")) : class$com$sap$ide$webdynpro$archivebuilder$ActionDeployPAR).getName());
    private IProject mProject = null;
    private boolean mError = false;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$archivebuilder$ActionDeployPAR;

    public ActionDeployPAR(IProject project) {
        this.mProject = project;
    }

    public void run() {
        IFile file;
        TRACE_LOCATION.entering();
        IContainer earFolder = PARService.getArchiveFolder(this.mProject, null);
        if (TRACE_LOCATION.beInfo() && earFolder != null) {
            TRACE_LOCATION.infoT("Looking for archive in folder " + earFolder.getLocation().toOSString());
        }
        if (!(file = earFolder.getFile((IPath)new Path(PARService.getEARFileName(this.mProject)))).isAccessible()) {
            TRACE_LOCATION.infoT("Archive file does not exist -> trying to generate it...");
            ActionGeneratePAR generatePARAction = new ActionGeneratePAR(this.mProject);
            generatePARAction.run();
            TRACE_LOCATION.infoT("Generation done");
            file = this.mProject.getFile(PARService.getEARFileName(this.mProject));
            if (!file.isAccessible()) {
                String errorText = "Archive file " + file.getLocation().toOSString() + " not found. Check tasts for error messages.";
                TRACE_LOCATION.errorT(errorText);
                this.mError = true;
                Display.getDefault().asyncExec((Runnable)new ShowErrorRunner(errorText));
                return;
            }
        }
        if (TRACE_LOCATION.beInfo() && file != null) {
            TRACE_LOCATION.infoT("Found archive " + file.getLocation().toOSString());
        }
        SDMManager manager = SDMManager.getInstance();
        TRACE_LOCATION.infoT("SDMManager instance retrieved");
        try {
            manager.deployArchiveAsync(file, mTracer);
        }
        catch (DeploymentException e) {
            TRACE_LOCATION.errorT(e.getMessage());
            this.mError = true;
            Display.getDefault().asyncExec((Runnable)new ShowErrorRunner(e.getMessage()));
            return;
        }
        TRACE_LOCATION.exiting();
    }

    public boolean isError() {
        return this.mError;
    }

    public void addDeploymentListener(ISDMManagerListener listener) {
        SDMManager.getInstance().addListener(listener);
    }

    public void removeDeploymentListener(ISDMManagerListener listener) {
        SDMManager.getInstance().removeListener(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShowErrorRunner
    implements Runnable {
        private String mError = null;

        public ShowErrorRunner(String error) {
            this.mError = error;
        }

        public void run() {
            ServicesUI.displayErrorMessage((String)mTextPool.getText(500), (String)this.mError);
        }
    }
}

