/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.archivebuilder;

import com.sap.ide.eclipse.sdm.ISDMManagerListener;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.archivebuilder.ActionDeployPAR;
import com.sap.ide.webdynpro.archivebuilder.ActionGeneratePAR;
import com.sap.ide.webdynpro.archivebuilder.ActionTestApplication;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;

public class ActionDeployAndTestApplication
extends Action {
    private Application mApplication = null;
    private ActionTestApplication mTestApplication = null;

    public ActionDeployAndTestApplication(Application application) {
        this.mApplication = application;
        this.mTestApplication = new ActionTestApplication(this.mApplication);
    }

    public void run() {
        String projectName = this.mApplication.getRoot().getMetamodel().getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ActionGeneratePAR parAction = new ActionGeneratePAR(project);
        parAction.run();
        if (parAction.isError()) {
            return;
        }
        ActionDeployPAR deployAction = new ActionDeployPAR(project);
        deployAction.addDeploymentListener(new DeploymentListener(deployAction));
        deployAction.run();
    }

    public void addAdditionalParameter(String parameter) {
        this.mTestApplication.addAdditionalParameter(parameter);
    }

    public void setDebugExtension(String extension) {
        this.mTestApplication.setDebugExtension(extension);
    }

    private class DeploymentListener
    implements ISDMManagerListener {
        private ActionDeployPAR mDeployAction = null;

        public DeploymentListener(ActionDeployPAR actionDeployPAR) {
            this.mDeployAction = actionDeployPAR;
        }

        public void deploymentFinished(File arg0, DeploymentException e) {
            this.mDeployAction.removeDeploymentListener(this);
            if (this.mDeployAction.isError() || e != null) {
                return;
            }
            ActionDeployAndTestApplication.this.mTestApplication.run();
        }

        public void deploymentStarted(File arg0) {
        }
    }
}

