/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.shell;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.persist.MonitoringInfoWriter;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PersistMonitoringDataCommand
implements Command {
    private ServiceContext serviceContext;
    private MonitoringInfoWriter writer;
    private static final Location location = Location.getLocation((String)"com.sap.engine.services.monitor.persist.PersistMonitoringDataCommand");
    private static String CLUSTER_ELEMENT_ID = "ID000";
    private ThreadSystem threadSystem = null;

    public PersistMonitoringDataCommand(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        ClusterElement clusterElem = null;
        if (serviceContext instanceof ApplicationServiceContext) {
            clusterElem = ((ApplicationServiceContext)serviceContext).getClusterContext().getClusterMonitor().getCurrentParticipant();
            this.threadSystem = ((ApplicationServiceContext)serviceContext).getCoreContext().getThreadSystem();
        } else if (serviceContext instanceof CommunicationServiceContext) {
            clusterElem = ((CommunicationServiceContext)serviceContext).getClusterContext().getClusterMonitor().getCurrentParticipant();
            this.threadSystem = ((CommunicationServiceContext)serviceContext).getCoreContext().getThreadSystem();
        }
        if (clusterElem != null) {
            CLUSTER_ELEMENT_ID = "ID" + clusterElem.getClusterId();
        }
    }

    public void exec(Environment e, InputStream in, OutputStream out, String[] params) {
        block45: {
            try {
                if (params.length != 1 && params.length != 8 && params.length != 6) {
                    out.write(("Invalid number of arguments " + params.length + ".").getBytes());
                    out.write((this.getHelpMessage() + "\n").getBytes());
                    return;
                }
                if (params.length == 1) {
                    if (params[0].equals("-status")) {
                        if (this.writer != null && this.writer.enabled()) {
                            out.write("Started.\n".getBytes());
                        } else {
                            out.write("Stopped.\n".getBytes());
                        }
                        return;
                    }
                    if (params[0].equals("-stop")) {
                        if (this.writer != null && this.writer.enabled()) {
                            try {
                                try {
                                    this.writer.hold();
                                }
                                catch (Exception r) {
                                    location.errorT(Util.getStackTraceAsString(r));
                                    Object var7_6 = null;
                                    this.writer = null;
                                }
                                Object var7_5 = null;
                                this.writer = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_7 = null;
                                this.writer = null;
                                throw throwable;
                            }
                        }
                        return;
                    }
                    if (params[0].equals("-default")) {
                        int period = 480;
                        int jarm_interval = 600;
                        int j2ee_interval = 120;
                        int weeks_to_keep = 12;
                        try {
                            if (this.writer == null || this.writer != null && !this.writer.enabled()) {
                                boolean res = this.activateMonitorInfoWriter(period, j2ee_interval, jarm_interval, weeks_to_keep);
                                if (res) {
                                    out.write(("Activated!\nPeriod=" + period + " min, j2ee_interval=" + j2ee_interval + " sec, jarm_interval=" + jarm_interval + " sec, wkeep=" + weeks_to_keep + ".\n").getBytes());
                                } else {
                                    out.write("Not activated.\n".getBytes());
                                }
                            }
                        }
                        catch (Throwable r) {
                            out.write(("The command could not be executed because " + r.getMessage() + "\n").getBytes());
                        }
                        return;
                    }
                    out.write(this.getHelpMessage().getBytes());
                    return;
                }
                if (params.length != 8 && params.length != 6) break block45;
                int period = -1;
                int j2ee_interval = -1;
                int jarm_interval = -1;
                int weeks_to_keep = -1;
                int p = 0;
                while (p < params.length - 1) {
                    if (params[p].equals("-period")) {
                        try {
                            if (period != -1) {
                                out.write("Duplicate parameter 'period'.\n".getBytes());
                                return;
                            }
                            period = Integer.parseInt(params[p + 1]);
                        }
                        catch (Throwable r) {
                            out.write((r.getMessage() + "\n").getBytes());
                            return;
                        }
                    }
                    if (params[p].equals("-jarm")) {
                        try {
                            if (jarm_interval != -1) {
                                out.write("Duplicate parameter 'jarm_interval'.\n".getBytes());
                                return;
                            }
                            jarm_interval = Integer.parseInt(params[p + 1]);
                        }
                        catch (Throwable r) {
                            out.write((r.getMessage() + "\n").getBytes());
                            return;
                        }
                    }
                    if (params[p].equals("-j2ee")) {
                        try {
                            if (j2ee_interval != -1) {
                                out.write("Duplicate parameter 'j2ee_interval'.\n".getBytes());
                                return;
                            }
                            j2ee_interval = Integer.parseInt(params[p + 1]);
                        }
                        catch (Throwable r) {
                            out.write((r.getMessage() + "\n").getBytes());
                            return;
                        }
                    }
                    if (params[p].equals("-wkeep")) {
                        try {
                            if (weeks_to_keep != -1) {
                                out.write("Duplicate parameter 'wkeep'.\n".getBytes());
                                return;
                            }
                            weeks_to_keep = Integer.parseInt(params[p + 1]);
                        }
                        catch (Throwable r) {
                            out.write((r.getMessage() + "\n").getBytes());
                            return;
                        }
                    }
                    p += 2;
                }
                if (this.writer == null || this.writer != null && !this.writer.enabled()) {
                    try {
                        boolean res;
                        if (period < 5) {
                            period = 5;
                        }
                        if (j2ee_interval < 5) {
                            j2ee_interval = 5;
                        }
                        if (jarm_interval < 60) {
                            jarm_interval = 60;
                        }
                        if (res = this.activateMonitorInfoWriter(period, j2ee_interval, jarm_interval, weeks_to_keep)) {
                            out.write(("Activated!\nPeriod=" + period + " min, j2ee_interval=" + j2ee_interval + " sec, jarm_interval=" + jarm_interval + " sec, wkeep=" + weeks_to_keep + ".\n").getBytes());
                        } else {
                            out.write("Not activated.\n".getBytes());
                        }
                    }
                    catch (Throwable r) {
                        this.writer = null;
                        out.write(("The command could not be executed because " + r.getMessage() + "\n").getBytes());
                    }
                }
                return;
            }
            catch (IOException ioe) {
                this.writer = null;
                location.errorT(Util.getStackTraceAsString(ioe));
            }
        }
    }

    private boolean activateMonitorInfoWriter(int period, int j2ee_interval, int jarm_interval, int weeks_to_keep) throws Exception {
        this.writer = new MonitoringInfoWriter(CLUSTER_ELEMENT_ID, period, j2ee_interval, jarm_interval, weeks_to_keep);
        if (this.writer != null) {
            if (this.threadSystem != null) {
                this.threadSystem.startThread((Runnable)this.writer, true);
            } else {
                this.writer.start();
            }
            return true;
        }
        return false;
    }

    public String getHelpMessage() {
        return "\n\nPersist the data from the monitoring tree and, if available, JARM data\n  for applications performance.\n\nUsage: PERSIST_MONITORING_DATA \n  parameters:\n    [-period] - The time in minutes for which the collected data will be \n                stored in one physical file. Minimum value 5.\n      [-jarm] - The time in seconds between each sequential jarm data \n                collection. Minimum value 60.\n      [-j2ee] - The time in seconds between each sequential j2ee counters \n                collection. Minimum value 5.\n     [-wkeep] - Number of weeks to keep old monitoring data before deletion. \n                Minimum value 2.\n   [-default] - Starts data collections with default settings: period is \n                8 hours, jarm collections are done every 10 minutes and \n                collections of j2ee counters every 2 minutes. History is kept\n                for last 12 weeks.\n      [-stop] - Forces stop of writing in files for all kind of data.\n\n    [-status] - Checks the status of persistence (Started/Stopped).\n\nExamples: \n   persist_monitoring_data -default  \n          Starts reporting in default mode. Suitable for use in production.\n\n   persist_monitoring_data -stop  \n          Immediatelly stops reporting.\n\n   persist_monitoring_data -period 60 -jarm 120 -j2ee 60 -wkeep 3\n          Opens new files and starts reporting data there. In this example \n          the data will be writen each 2 minutes for jarm, each 1 minute for \n          j2ee and the file will contain all data from 1 hour collection.\n          History data will be kept forthe last 3 weeks.\n\n";
    }

    public String getName() {
        return "PERSIST_MONITORING_DATA";
    }

    public String getGroup() {
        return "MONITOR";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

