/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.library.monitor.IAvailabilityMonitorNode;
import com.sap.engine.library.monitor.IBooleanMonitorNode;
import com.sap.engine.library.monitor.IDurationMonitorNode;
import com.sap.engine.library.monitor.IFrequencyMonitorNode;
import com.sap.engine.library.monitor.IIntegerMonitorNode;
import com.sap.engine.library.monitor.ILongMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IPropertiesMonitorNode;
import com.sap.engine.library.monitor.IQualityRateMonitorNode;
import com.sap.engine.library.monitor.IStateMonitorNode;
import com.sap.engine.library.monitor.IStringMonitorNode;
import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.impl0.DurationMonitorNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MonitorInfoCommand
implements Command {
    private ServiceContext serviceContext;
    private static final Location location = Location.getLocation((String)"com.sap.engine.services.monitor.shell.MonitorInfoCommand");

    public MonitorInfoCommand(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void exec(Environment e, InputStream in, OutputStream out, String[] params) {
        String separator = this.serviceContext.getServiceState().getProperties().getProperty("shell.cmd.separator");
        try {
            if (params.length != 1) {
                out.write(this.getHelpMessage().getBytes());
                return;
            }
            MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
            MappingTreeNode node = m_tree.getMappingTreeNode(params[0], separator);
            if (node == null) {
                out.write("Monitor node does not exist! Chenge separator if needed.\n\n".getBytes());
            }
            out.write(this.getMonitorInfos(node.getMonitorObject()).getBytes());
        }
        catch (IOException ioe) {
            location.errorT(Util.getStackTraceAsString(ioe));
        }
    }

    private String getMonitorInfos(IMonitorNode node) {
        String info = "\n   name: " + node.getName() + "\n" + "   configuration group: " + node.getConfigurationGroup() + "\n" + "   description: " + node.getDescription() + "\n" + "   creation time: " + node.getCreationTime().toString() + "\n" + "   last change date: " + node.getLastChangeDate().toString() + "\n";
        info = node.getHasReportedValue() ? info + this.getMonitorValue(node) : info + "No value has been reported yet\n\n";
        return info;
    }

    private String getMonitorValue(IMonitorNode node) {
        String info = "";
        switch (node.getTyp()) {
            case 0: {
                break;
            }
            case 1: {
                info = info + "   type: Integer monitor\n\n   value: " + ((IIntegerMonitorNode)node).getValue() + "\n" + "   maximum: " + ((IIntegerMonitorNode)node).getMaxValue().getExtremum() + "\n" + "   minimum: " + ((IIntegerMonitorNode)node).getMinValue().getExtremum() + "\n\n";
                break;
            }
            case 2: {
                info = info + "   type: Long monitor\n\n   value: " + ((ILongMonitorNode)node).getValue() + "\n" + "   maximum: " + ((ILongMonitorNode)node).getMaxValue() + "\n" + "   minimum: " + ((ILongMonitorNode)node).getMinValue() + "\n\n";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                info = info + "   type: Boolean monitor\n\n   value: " + ((IBooleanMonitorNode)node).getValue() + "\n" + "   time on true in ms: " + ((IBooleanMonitorNode)node).getTimeOnTrueInMilliseconds() + "\n" + "   time on false in ms: " + ((IBooleanMonitorNode)node).getTimeOnFalseInMilliseconds() + "\n\n";
                break;
            }
            case 6: {
                info = info + "   type: Integer monitor\n\n   value: " + ((IStringMonitorNode)node).getText() + "\n\n";
                break;
            }
            case 7: {
                String[] header = (String[])((ITableMonitorNode)node).getHeader();
                String[][] values = Util.arrayToString(((ITableMonitorNode)node).getEntries());
                int spaces = 100 / header.length;
                info = info + "   type: Table monitor\n\n     ";
                int i = 0;
                while (i < header.length) {
                    info = info + header[i] + this.spaces(spaces - header[i].length());
                    ++i;
                }
                info = info + "\n";
                int i2 = 0;
                while (i2 < values.length) {
                    int j = 0;
                    while (j < values[i2].length) {
                        info = info + "   " + values[i2][j] + this.spaces(spaces - values[i2][j].length());
                        ++j;
                    }
                    info = info + "\n";
                    ++i2;
                }
                info = info + "\n";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                info = info + "   type: State monitor\n\n   value: " + ((IStateMonitorNode)node).getState() + "\n\n";
                break;
            }
            case 10: {
                info = info + "   v_state: " + node + "\n\n";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                info = info + "   type: Frequency monitor\n\n   frequency: " + Util.formatDouble(((IFrequencyMonitorNode)node).getFrequency()) + "\n" + "   maximal frequency: " + Util.formatDouble(((IFrequencyMonitorNode)node).getMaxFreqency()) + "\n" + "   minimal frequency: " + Util.formatDouble(((IFrequencyMonitorNode)node).getMinFrequency()) + "\n\n";
                break;
            }
            case 14: {
                info = info + "   type: Quality-rate monitor\n\n   current hit rate: " + ((IQualityRateMonitorNode)node).getCurrentQualityRate() + "\n" + "   average hit rate since startup: " + ((IQualityRateMonitorNode)node).getAverageQualityRate() + "\n" + "   total tries: " + ((IQualityRateMonitorNode)node).getTotalTries() + "\n" + "   total hits: " + ((IQualityRateMonitorNode)node).getSuccessfulTries() + "\n\n";
                break;
            }
            case 15: {
                info = info + "   type: Availability monitor\n\n   availability in percent:: " + ((IAvailabilityMonitorNode)node).getAvailability() + "\n" + "   last reported value: " + ((IAvailabilityMonitorNode)node).getValue() + "\n" + "   available time in sec: " + ((IAvailabilityMonitorNode)node).getTimeOnTrueInMilliseconds() / 60L + "  sec\n" + "   non available time in sec: " + ((IAvailabilityMonitorNode)node).getTimeOnFalseInMilliseconds() / 60L + " sec\n\n";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                info = info + "   type: Duration monitor\n\n   current average time: " + Util.round(((IDurationMonitorNode)node).getCurrentDuration()) + " " + ((DurationMonitorNode)node).getUnit() + "\n" + "   average time since startup: " + Util.round(((IDurationMonitorNode)node).getAverageDuration()) + " " + ((DurationMonitorNode)node).getUnit() + "\n" + "   total number: " + ((IDurationMonitorNode)node).getTotalNumber() + "\n" + "   total time: " + ((IDurationMonitorNode)node).getTotalTime() + "\n\n";
                break;
            }
            case 18: 
            case 19: {
                String[][] props = ((IPropertiesMonitorNode)node).getProperties();
                info = info + "   type: Version monitor\n\n      property " + this.spaces(30 - "proprty".length()) + " value\n";
                int i = 0;
                while (i < props.length) {
                    info = info + "   " + props[i][0] + this.spaces(30 - props[i][0].length()) + props[i][1] + "\n";
                    ++i;
                }
                info = info + "\n";
                break;
            }
        }
        return info;
    }

    private String spaces(int number) {
        String str = "";
        int i = 0;
        while (i < number) {
            str = str + " ";
            ++i;
        }
        return str;
    }

    public String getName() {
        return "MONITOR_INFO";
    }

    public String getGroup() {
        return "MONITOR";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    public String getHelpMessage() {
        return "\nDisplays detailed information for a monitor node.\n\n  Usage: MONITOR_INFO <monitor node>\n  parameters:\n    <monitor node> - the full path from Root to the node\nExamples: \n   monitor_info /Root/Services/Timeout/EstimatedFrequencyPerMinute:\nNote: to change the separator char use the SETSP command from admin group\n";
    }
}

