/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ListMonitorTreeCommand
implements Command {
    private ServiceContext serviceContext;
    private static final String TEXT_VIEW = "-text";
    private static final Location location = Location.getLocation((String)"com.sap.engine.services.monitor.shell.ListMonitorTreeCommand");

    public ListMonitorTreeCommand(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void exec(Environment e, InputStream in, OutputStream out, String[] params) {
        String separator = this.serviceContext.getServiceState().getProperties().getProperty("shell.cmd.separator");
        try {
            boolean isTreeView = true;
            MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
            MappingTreeNode root = null;
            if (params.length > 0 && (params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
                out.write((this.getHelpMessage() + "\n").getBytes());
                return;
            }
            if (params.length > 2) {
                out.write((this.getHelpMessage() + "\n").getBytes());
                return;
            }
            if (params.length == 2) {
                if (params[0].equalsIgnoreCase(TEXT_VIEW)) {
                    isTreeView = false;
                    root = m_tree.getMappingTreeNode(params[1], separator);
                } else if (params[1].equalsIgnoreCase(TEXT_VIEW)) {
                    isTreeView = false;
                    root = m_tree.getMappingTreeNode(params[0], separator);
                }
            }
            if (params.length == 1 && params[0].equalsIgnoreCase(TEXT_VIEW)) {
                isTreeView = false;
                root = m_tree.getRootNode();
            }
            if (params.length == 1 && !params[0].equalsIgnoreCase(TEXT_VIEW)) {
                isTreeView = true;
                root = m_tree.getMappingTreeNode(params[0], separator);
            }
            if (params.length == 0) {
                isTreeView = true;
                root = m_tree.getRootNode();
            }
            if (root == null) {
                out.write("MonitorNode does not exist! Change separator if needed.\n\n".getBytes());
                return;
            }
            StringBuffer str = new StringBuffer();
            if (!isTreeView) {
                this.getTree(separator, str, "", root);
            } else {
                this.getTree(str, 2, root);
            }
            out.write((str + "\n").getBytes());
        }
        catch (IOException ioe) {
            location.errorT(Util.getStackTraceAsString(ioe));
        }
    }

    public String getHelpMessage() {
        return "\nLists the whole monitoring tree.\n\n  Usage: LIST_MONITOR_TREE [monitor node] [-text]\n  parameters:\n    [monitor node] - the full path from Root to a particular node, which sub-tree will be listed.\n    [-text]        - dispays the tree without the tree structure formatting\nExamples: \n   list_monitor_tree /Root/Services -text  : dispays the sub tree /Root/Services without formatting\n   list_monitor_tree -text                   : displays whole tree without formatting\n   list_monitor_tree /Root/Applications      : dispays the sub tree /Root/Applications in a tree format\nNote: to change the separator char use the SETSP command from admin group\n";
    }

    public String getName() {
        return "LIST_MONITOR_TREE";
    }

    public String getGroup() {
        return "MONITOR";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    private void getTree(String separator, StringBuffer str, String nodeStr, MappingTreeNode node) {
        nodeStr = nodeStr + separator + node.getName();
        if (node.getChildCount() == 0) {
            str.append(nodeStr + "\n");
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.getTree(separator, str, nodeStr, (MappingTreeNode)node.getChildAt(i));
            ++i;
        }
        nodeStr = nodeStr.substring(0, nodeStr.lastIndexOf(separator));
    }

    private void getTree(StringBuffer str, int spaces, MappingTreeNode node) {
        str.append(this.spaces(spaces) + node.getName() + "\n");
        int i = 0;
        while (i < node.getChildCount()) {
            this.getTree(str, spaces + 2, (MappingTreeNode)node.getChildAt(i));
            ++i;
        }
        spaces -= 2;
    }

    private String spaces(int spaces) {
        String str = "";
        int i = 0;
        while (i < spaces) {
            str = str + " ";
            ++i;
        }
        return str;
    }
}

