/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.library.monitor.IPerformanceMonitorNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ChangeThresholdsCommand
implements Command {
    private static String G2Y = "GreenToYellow";
    private static String Y2R = "YellowToRed";
    private static String R2Y = "RedToYellow";
    private static String Y2G = "YellowToGreen";
    private ServiceContext serviceContext;
    private String separator = "/";
    private ObjectName configurationServiceObjectName;
    private MBeanServer mbs;
    private Location location = Location.getLocation((String)"com.sap.engine.services.monitor.shell.ChangeThresholdsCommand");

    public ChangeThresholdsCommand(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        try {
            this.configurationServiceObjectName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"MonitorConfigurationService", null, null);
            this.mbs = MonitorServiceRuntime.getMBeanServer();
        }
        catch (MalformedObjectNameException mone) {
            this.location.errorT("Could not acces MBeanServer or error in creating ObjectName of MonitorConfigurationService");
            this.location.infoT(Util.getStackTraceAsString(mone));
        }
    }

    public void exec(Environment e, InputStream in, OutputStream out, String[] params) {
        this.separator = this.serviceContext.getServiceState().getProperties().getProperty("shell.cmd.separator");
        try {
            if (params.length < 3 || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                out.write((this.getHelpMessage() + "\n").getBytes());
                return;
            }
            MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
            MappingTreeNode i_node = m_tree.getMappingTreeNode(params[0], this.separator);
            if (i_node == null) {
                out.write("Monitor node not found. Check name or change separator property.\n\n".getBytes());
                return;
            }
            IPerformanceMonitorNode node = null;
            try {
                node = (IPerformanceMonitorNode)i_node.getMonitorObject();
            }
            catch (ClassCastException cce) {
                this.location.warningT("Could not change thresholds for monitor node [" + i_node.getName() + "]. Not a Performance monitor node.");
                out.write(("Could not change thresholds for monitor node [" + i_node.getName() + "]. Not a Performance monitor node.\n\n").getBytes());
                return;
            }
            if (params.length == 3) {
                if (params[1].equalsIgnoreCase(G2Y)) {
                    out.write(this.updateGreenToYellow(node, params[2]).getBytes());
                } else if (params[1].equalsIgnoreCase(Y2R)) {
                    out.write(this.updateYellowToRed(node, params[2]).getBytes());
                } else if (params[1].equalsIgnoreCase(R2Y)) {
                    out.write(this.updateRedToYellow(node, params[2]).getBytes());
                } else if (params[1].equalsIgnoreCase(Y2G)) {
                    out.write(this.updateYellowToGreen(node, params[2]).getBytes());
                } else {
                    out.write((this.getHelpMessage() + "\n").getBytes());
                }
            } else if (params.length == 5) {
                out.write(this.updateThresholds(node, params[1], params[2], params[3], params[4]).getBytes());
            } else {
                out.write((this.getHelpMessage() + "\n").getBytes());
            }
        }
        catch (IOException ioe) {
            this.location.errorT(Util.getStackTraceAsString(ioe));
        }
    }

    private String updateGreenToYellow(IPerformanceMonitorNode node, String newValue) {
        String configurationGroup = node.getConfigurationGroup();
        int oldValue = node.getThresholds().getThresholdFromGreenToYellow();
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setThresholdsGreenToYellow", new Object[]{configurationGroup, new Integer(newValue)}, new String[]{"java.lang.String", "int"});
        }
        catch (Exception e) {
            this.location.warningT("Could not change thresholds! Reason: " + e.getMessage());
            return "Could not change thresholds! Possible reason: Not consistent thresholds.\n\n";
        }
        return "\nChanged Threshold GreenToYellow:\n     old value: " + oldValue + "\n" + "     new value: " + newValue + "\n\n";
    }

    private String updateYellowToRed(IPerformanceMonitorNode node, String newValue) {
        String configurationGroup = node.getConfigurationGroup();
        int oldValue = node.getThresholds().getThresholdFromYellowToRed();
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setThresholdsYellowToRed", new Object[]{configurationGroup, new Integer(newValue)}, new String[]{"java.lang.String", "int"});
        }
        catch (Exception e) {
            this.location.warningT("Could not change thresholds! Reason: " + e.getMessage());
            return "Could not change thresholds! Possible reason: Not consistent thresholds.\n\n";
        }
        return "\nChanged Threshold YellowToRed\n     old value: " + oldValue + "\n" + "     new value: " + newValue + "\n\n";
    }

    private String updateRedToYellow(IPerformanceMonitorNode node, String newValue) {
        String configurationGroup = node.getConfigurationGroup();
        int oldValue = node.getThresholds().getThresholdFromRedToYellow();
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setThresholdsRedToYellow", new Object[]{configurationGroup, new Integer(newValue)}, new String[]{"java.lang.String", "int"});
        }
        catch (Exception e) {
            this.location.warningT("Could not change thresholds! Reason: " + e.getMessage());
            return "Could not change thresholds! Possible reason: Not consistent thresholds.\n\n";
        }
        return "\nChanged Threshold RedToYellow\n     old value: " + oldValue + "\n" + "     new value: " + newValue + "\n\n";
    }

    private String updateYellowToGreen(IPerformanceMonitorNode node, String newValue) {
        String configurationGroup = node.getConfigurationGroup();
        int oldValue = node.getThresholds().getThresholdFromYellowToGreen();
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setThresholdsYellowToGreen", new Object[]{configurationGroup, new Integer(newValue)}, new String[]{"java.lang.String", "int"});
        }
        catch (Exception e) {
            this.location.warningT("Could not change thresholds! Reason: " + e.getMessage());
            return "Could not change thresholds! Possible reason: Not consistent thresholds.\n\n";
        }
        return "\nChanged Threshold YellowToGreen\n     old value: " + oldValue + "\n" + "     new value: " + newValue + "\n\n";
    }

    private String updateThresholds(IPerformanceMonitorNode node, String g2y, String y2r, String r2y, String y2g) {
        String configurationGroup = node.getConfigurationGroup();
        int oldG2Y = node.getThresholds().getThresholdFromGreenToYellow();
        int oldY2R = node.getThresholds().getThresholdFromYellowToRed();
        int oldR2Y = node.getThresholds().getThresholdFromRedToYellow();
        int oldY2G = node.getThresholds().getThresholdFromYellowToGreen();
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setThresholds", new Object[]{configurationGroup, new Integer(g2y), new Integer(y2r), new Integer(r2y), new Integer(y2g)}, new String[]{"java.lang.String", "int", "int", "int", "int"});
        }
        catch (Exception e) {
            this.location.warningT("Could not change thresholds! Reason: " + e.getMessage());
            return "Could not change thresholds! Possible reason: Not consistent thresholds.\n\n";
        }
        return "\nChanged Thresholds \n     GreenToYellow old value: " + oldG2Y + "    " + "     new value: " + g2y + "\n" + "      YellowToRed  old value: " + oldY2R + "    " + "     new value: " + y2r + "\n" + "      RedToYellow  old value: " + oldR2Y + "    " + "     new value: " + r2y + "\n" + "     YellowToGreen old value: " + oldY2G + "    " + "     new value: " + y2g + "\n\n";
    }

    public String getHelpMessage() {
        return "\nChanges monitor thresholds. You can either change all thresholds at once, \n                              or only a particular one.\n  Usage: CHANGE_THRESHOLDS <monitor node> <green to yellow> <yellow to red> <red to yellow> <yellow to green>\n         CHANGE_THRESHOLDS <monitor node> <threshold> <new value>  parameters:\n    <monitor node>     - the full path from Root to the node\n     <green to yellow> - new value for 'green to yellow' threshold\n     <yellow to red>   - new value for 'yellow to red' threshold\n     <red to yellow>   - new value for 'red to yellow' threshold\n     <yellow to green> - new value for 'yellow to green' threshold\n\n     <threshold>       - change one threshold: GreenToYellow, YellowToRed, RedToYellow, YellowToGreen     <new value>       - the new value for the threshold\nExamples: \n   change_thresholds list_monitor_tree /Root/Services/Timeout/EstimatedFrequencyPerMinute 10 20 20 10\n                               changes all thresholds   change_thresholds list_monitor_tree /Root/Services/Timeout/EstimatedFrequencyPerMinute GreeenToYellow 20:\n                               changes green_to_yellow threshold\nNote: to change the separator char use the SETSP command from admin group\n";
    }

    public String getName() {
        return "CHANGE_THRESHOLDS";
    }

    public String getGroup() {
        return "MONITOR";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

