/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.library.monitor.impl0.StateMonitorNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ChangeStatesCommand
implements Command {
    private static String GREEN_STATES = "GreenStates";
    private static String ADD_GREEN_STATES = "AddGreenStates";
    private static String YELLOW_STATES = "YellowStates";
    private static String ADD_YELLOW_STATES = "AddYellowStates";
    private static String RED_STATES = "RedStates";
    private static String ADD_RED_STATES = "AddRedStates";
    private ServiceContext serviceContext;
    private String separator = "/";
    private ObjectName configurationServiceObjectName;
    private MBeanServer mbs;
    private static final Location location = Location.getLocation((String)"com.sap.engine.services.monitor.shell.ChangeStatesCommand");
    static /* synthetic */ Class array$Ljava$lang$String;

    public ChangeStatesCommand(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        try {
            this.configurationServiceObjectName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"MonitorConfigurationService", null, null);
            this.mbs = MonitorServiceRuntime.getMBeanServer();
        }
        catch (MalformedObjectNameException mone) {
            location.errorT("Could not acces MBeanServer or error in creating ObjectName of MonitorConfigurationService");
            location.infoT(Util.getStackTraceAsString(mone));
        }
    }

    public void exec(Environment e, InputStream in, OutputStream out, String[] params) {
        this.separator = this.serviceContext.getServiceState().getProperties().getProperty("shell.cmd.separator");
        try {
            StateMonitorNode root;
            if (params.length < 3 || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                out.write((this.getHelpMessage() + "\n").getBytes());
                return;
            }
            MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
            MappingTreeNode m_root = m_tree.getMappingTreeNode(params[0], this.separator);
            if (m_root == null) {
                out.write("Monitor node not found! Change separator if needed.\n\n".getBytes());
                return;
            }
            try {
                root = (StateMonitorNode)m_root.getMonitorObject();
            }
            catch (ClassCastException cce) {
                location.infoT("Could not change states for monitor node [" + m_root.getName() + "]. Not a state monitor.");
                out.write(("Could not change states for monitor node [" + m_root.getName() + "]. Not a state monitor.").getBytes());
                return;
            }
            String[] array = new String[params.length - 2];
            int i = 0;
            while (i < array.length) {
                array[i] = params[i + 2];
                ++i;
            }
            if (params[1].equalsIgnoreCase(GREEN_STATES)) {
                out.write(this.setGreenStates(root, array).getBytes());
            } else if (params[1].equalsIgnoreCase(YELLOW_STATES)) {
                out.write(this.setYellowStates(root, array).getBytes());
            } else if (params[1].equalsIgnoreCase(RED_STATES)) {
                out.write(this.setRedStates(root, array).getBytes());
            } else if (params[1].equalsIgnoreCase(ADD_GREEN_STATES)) {
                out.write(this.setGreenStates(root, this.accumulateArrays(array, root.getGreenStates())).getBytes());
            } else if (params[1].equalsIgnoreCase(ADD_YELLOW_STATES)) {
                out.write(this.setYellowStates(root, this.accumulateArrays(array, root.getYellowStates())).getBytes());
            } else if (params[1].equalsIgnoreCase(ADD_RED_STATES)) {
                out.write(this.setRedStates(root, this.accumulateArrays(array, root.getRedStates())).getBytes());
            } else {
                out.write((this.getHelpMessage() + "\n\n").getBytes());
            }
        }
        catch (IOException ioe) {
            location.errorT(Util.getStackTraceAsString(ioe));
        }
    }

    private String setGreenStates(StateMonitorNode node, String[] states) {
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setGreenStates", new Object[]{node.getConfigurationGroup(), states}, new String[]{"java.lang.String", (array$Ljava$lang$String == null ? (array$Ljava$lang$String = ChangeStatesCommand.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).getName()});
        }
        catch (Exception e) {
            location.warningT("Could not change period! Reason: " + e.getMessage());
            return "Could not change period! Reason: " + e.getMessage() + "\n\n";
        }
        String str = "States updated:\n    new states: \n";
        int i = 0;
        while (i < states.length) {
            str = str + states[i] + "   ";
            ++i;
        }
        return str + "\n\n";
    }

    private String setYellowStates(StateMonitorNode node, String[] states) {
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setYellowStates", new Object[]{node.getConfigurationGroup(), states}, new String[]{"java.lang.String", (array$Ljava$lang$String == null ? (array$Ljava$lang$String = ChangeStatesCommand.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).getName()});
        }
        catch (Exception e) {
            location.warningT("Could not change period! Reason: " + e.getMessage());
            return "Could not change period! Reason: " + e.getMessage() + "\n\n";
        }
        String str = "States updated:\n   new states: \n        ";
        int i = 0;
        while (i < states.length) {
            str = str + states[i] + "   ";
            ++i;
        }
        return str + "\n\n";
    }

    private String setRedStates(StateMonitorNode node, String[] states) {
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setRedStates", new Object[]{node.getConfigurationGroup(), states}, new String[]{"java.lang.String", (array$Ljava$lang$String == null ? (array$Ljava$lang$String = ChangeStatesCommand.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).getName()});
        }
        catch (Exception e) {
            location.warningT("Could not change period! Reason: " + e.getMessage());
            return "Could not change period! Reason: " + e.getMessage() + "\n\n";
        }
        String str = "States updated:\n   new states: \n        ";
        int i = 0;
        while (i < states.length) {
            str = str + states[i] + "   ";
            ++i;
        }
        return str + "\n\n";
    }

    public String getHelpMessage() {
        return "\nChanges the states of a state monitor node.\n\n  Usage: CHANGE_STATES <monitor node> <state group> <states>\n  parameters:\n    <monitor node>   - the full path from Root to the node\n    <state group>    - defines the state group, which will be modified\n       to change existing states, use: GreenStates, YellowStates, RedStates\n       to add new states, use: AddGreenStates, AddYellowStates, AddRedStates\n    <states>         - states to update/addExamples: \n   change_states \"/Root/Services/SSL Provider/Expiration of Certificates\" greenstate1 greenstate2:\n                              removes the old green states and adds the new states.\n   change_states \"/Root/Services/SSL Provider/Expiration of Certificates\" AddYellowState greenstateN:\n                              adds new states to existing yellow states.\nNote: to change the separator char use the SETSP command from admin group\n";
    }

    public String getName() {
        return "CHANGE_STATES";
    }

    public String getGroup() {
        return "MONITOR";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    private String[] accumulateArrays(String[] array1, String[] array2) {
        String[] array = new String[array1.length + array2.length];
        int i = 0;
        while (i < array1.length) {
            array[i] = array1[i];
            ++i;
        }
        int j = 0;
        while (j < array2.length) {
            array[i++] = array2[j];
            ++j;
        }
        return array;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

