/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ChangeReactOnFailureCommand
implements Command {
    private static String UNREGISTER_MONITOR = "unregister_monitor";
    private static final int UNREGISTER_MONITOR_VALUE = 3;
    private static String IGNORE = "ignore";
    private static final int IGNORE_VALUE = 4;
    private ServiceContext serviceContext;
    private String separator = "/";
    private ObjectName configurationServiceObjectName;
    private MBeanServer mbs;
    private static final Location location = Location.getLocation((String)"com.sap.engine.services.monitor.shell.ChangeReactOnFailureCommand");

    public ChangeReactOnFailureCommand(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        try {
            this.configurationServiceObjectName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"MonitorConfigurationService", null, null);
            this.mbs = MonitorServiceRuntime.getMBeanServer();
        }
        catch (MalformedObjectNameException mone) {
            location.errorT("Could not acces MBeanServer or error in creating ObjectName of MonitorConfigurationService");
            location.infoT(Util.getStackTraceAsString(mone));
        }
    }

    public void exec(Environment e, InputStream in, OutputStream out, String[] params) {
        this.separator = this.serviceContext.getServiceState().getProperties().getProperty("shell.cmd.separator");
        try {
            if (params.length != 2 || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                out.write((this.getHelpMessage() + "\n\n").getBytes());
                return;
            }
            MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
            MappingTreeNode root = m_tree.getMappingTreeNode(params[0], this.separator);
            if (root == null) {
                out.write("Monitor node not found! Change separator if needed.\n\n".getBytes());
                return;
            }
            out.write(this.setReactOnCollectionFailure(root, params[1]).getBytes());
        }
        catch (IOException ioe) {
            location.errorT(Util.getStackTraceAsString(ioe));
        }
    }

    private String setReactOnCollectionFailure(MappingTreeNode node, String value) {
        int newValue;
        int oldValue = node.getMonitorObject().getReactOnCollectionFailure();
        if (value.equalsIgnoreCase(UNREGISTER_MONITOR)) {
            newValue = 3;
        } else if (value.equalsIgnoreCase(IGNORE)) {
            newValue = 4;
        } else {
            return "Could not change react-on-failure! Check parameters.\n\n";
        }
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setReactOnCollectionFailure", new Object[]{node.getMonitorObject().getConfigurationGroup(), new Integer(newValue)}, new String[]{"java.lang.String", "int"});
        }
        catch (Exception e) {
            location.warningT("Could not change period! Reason: " + e.getMessage());
            return "Could not change period! Reason: " + e.getMessage() + "\n\n";
        }
        String oldValueStr = this.getValue(oldValue);
        return "Changed react on collection failure:\n  old value: " + oldValueStr + "\n" + "  new value: " + value + "\n\n";
    }

    public String getHelpMessage() {
        return "\nChanges the way the monitor reacts on resource failure.\n\n  Usage: CHANGE_REACT_ON_FAILURE <monitor node> <new value>\n  parameters:\n    <monitor node> - the full path from Root to the node\n    <new value>    - the new value for react-on-failure\n                     the possible values are: unregister_monitor/ignore\nExamples: \n   change_react_on_failure /Root/Services/Timeout/EstimatedFrequencyPerMinute unregister_monitor:\n                              changes react-on-failure to unregister_monitor\n   change_react_on_failure /Root/Services/Timeout/EstimatedFrequencyPerMinute ignore:\n                              changes react-on-failure to ignore\nNote: to change the separator char use the SETSP command from admin group\n";
    }

    public String getName() {
        return "CHANGE_REACT_ON_FAILURE";
    }

    public String getGroup() {
        return "MONITOR";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    private String getValue(int value) {
        switch (value) {
            case 3: {
                return UNREGISTER_MONITOR;
            }
            case 4: {
                return IGNORE;
            }
        }
        return null;
    }
}

