/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ChangePeriodCommand
implements Command {
    private static String MINUTE = "minute";
    private static final int MINUTE_VALUE = 0;
    private static String HOUR = "hour";
    private static final int HOUR_VALUE = 1;
    private static String DAY = "day";
    private static final int DAY_VALUE = 2;
    private ServiceContext serviceContext;
    private String separator = "/";
    private ObjectName configurationServiceObjectName;
    private MBeanServer mbs;
    private static final Location location = Location.getLocation((String)"com.sap.engine.services.monitor.shell.ChangePeriodCommand");

    public ChangePeriodCommand(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        try {
            this.configurationServiceObjectName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"MonitorConfigurationService", null, null);
            this.mbs = MonitorServiceRuntime.getMBeanServer();
        }
        catch (MalformedObjectNameException mone) {
            location.errorT("Could not acces MBeanServer or error in creating ObjectName of MonitorConfigurationService");
            location.infoT(Util.getStackTraceAsString(mone));
        }
    }

    public void exec(Environment e, InputStream in, OutputStream out, String[] params) {
        this.separator = this.serviceContext.getServiceState().getProperties().getProperty("shell.cmd.separator");
        try {
            if (params.length != 3 || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                out.write((this.getHelpMessage() + "\n").getBytes());
                return;
            }
            MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
            MappingTreeNode root = m_tree.getMappingTreeNode(params[0], this.separator);
            if (root == null) {
                out.write("Monitor node not found! Change separator if needed.\n\n".getBytes());
                return;
            }
            out.write(this.setPeriod(root, params[1], params[2]).getBytes());
        }
        catch (IOException ioe) {
            location.errorT(Util.getStackTraceAsString(ioe));
        }
    }

    private String setPeriod(MappingTreeNode node, String value, String unit) {
        int unitValue;
        int oldValue = node.getMonitorObject().getPeriodValue();
        int oldUnitValue = node.getMonitorObject().getPeriodUnit();
        if (unit.equalsIgnoreCase(MINUTE)) {
            unitValue = 0;
        } else if (unit.equalsIgnoreCase(HOUR)) {
            unitValue = 1;
        } else if (unit.equalsIgnoreCase(DAY)) {
            unitValue = 2;
        } else {
            return "Could not change period! Not correct value.\n\n";
        }
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setPeriod", new Object[]{node.getMonitorObject().getConfigurationGroup(), new Integer(value), new Integer(unitValue)}, new String[]{"java.lang.String", "int", "int"});
        }
        catch (Exception e) {
            location.warningT("Could not change period! Reason: " + e.getMessage());
            return "Could not change period! Reason: " + e.getMessage() + "\n\n";
        }
        String oldUnit = this.getUnit(oldUnitValue);
        return "Changed period:\n  old value: " + oldValue + " " + oldUnit + "\n" + "  new value: " + value + " " + unit + "\n\n";
    }

    public String getHelpMessage() {
        return "\nChanges the period, through which the data is pulled by monitor resource.\n\n  Usage: CHANGE_PERIOD <monitor node> <new period>\n  parameters:\n    <monitor node> - the full path from Root to the node\n    <new period>   - the new period\nExamples: \n   change_period /Root/Services/Timeout/EstimatedFrequencyPerMinute 1 minute :\n                                           changes the period to 1 minute\n   change_period /Root/Services/Timeout/EstimatedFrequencyPerMinute 2 hour   :\n                                           changes the period to 2 hour\n   change_period /Root/Services/Timeout/EstimatedFrequencyPerMinute 3 day          :\n                                           changes the period to 3 day\nNote: to change the separator char use the SETSP command from admin group\n";
    }

    public String getName() {
        return "CHANGE_PERIOD";
    }

    public String getGroup() {
        return "MONITOR";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    private String getUnit(int value) {
        switch (value) {
            case 0: {
                return MINUTE;
            }
            case 1: {
                return HOUR;
            }
            case 2: {
                return DAY;
            }
        }
        return null;
    }
}

