/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ChangeDescriptionCommand
implements Command {
    private ServiceContext serviceContext;
    private String separator = "/";
    private ObjectName configurationServiceObjectName;
    private MBeanServer mbs;
    private static final Location location = Location.getLocation((String)"com.sap.engine.services.monitor.shell.ChangeDescriptionCommand");

    public ChangeDescriptionCommand(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        try {
            this.configurationServiceObjectName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"MonitorConfigurationService", null, null);
            this.mbs = MonitorServiceRuntime.getMBeanServer();
        }
        catch (MalformedObjectNameException mone) {
            location.errorT("Could not acces MBeanServer or error in creating ObjectName of MonitorConfigurationService");
            location.infoT(Util.getStackTraceAsString(mone));
        }
    }

    public void exec(Environment e, InputStream in, OutputStream out, String[] params) {
        this.separator = this.serviceContext.getServiceState().getProperties().getProperty("shell.cmd.separator");
        try {
            if (params.length != 2 || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                out.write((this.getHelpMessage() + "\n").getBytes());
                return;
            }
            MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
            MappingTreeNode root = m_tree.getMappingTreeNode(params[0], this.separator);
            if (root == null) {
                location.errorT("Monitor node not found! Change separator if needed.");
                out.write("Monitor node not found! Change separator if needed.\n\n".getBytes());
                return;
            }
            out.write(this.setDescription(root, params[1]).getBytes());
        }
        catch (IOException ioe) {
            location.errorT(Util.getStackTraceAsString(ioe));
        }
    }

    private String setDescription(MappingTreeNode root, String description) {
        String oldDescr = root.getMonitorObject().getDescription();
        try {
            this.mbs.invoke(this.configurationServiceObjectName, "setDescription", new Object[]{root.getMonitorObject().getConfigurationGroup(), description}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (Exception e) {
            location.warningT("Could not change description! Reason: " + e.getMessage());
            return "Could not change description! Reason: " + e.getMessage() + "\n\n";
        }
        return "Changed description:\n  old description: " + oldDescr + "\n" + "  new description: " + description + "\n\n";
    }

    public String getHelpMessage() {
        return "\nChanges the description of a monitor node.\n\n  Usage: CHANGE_DESCRIPTION <monitor node> <new description>\n  parameters:\n    <monitor node>    - the full path from Root to the node\n    <new description> - the new description\nExamples: \n   change_description /Root/Services/Timeout \"new description\":\n                   displays the sub tree /Root/Services/Timeout as text\nNote: to change the separator char use the SETSP command from admin group\n";
    }

    public String getName() {
        return "CHANGE_DESCRIPTION";
    }

    public String getGroup() {
        return "MONITOR";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

