/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.server;

import com.sap.engine.frame.ApplicationFrameAdaptor;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.frame.state.ServiceState;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.library.monitor.MonitorFactory;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.ContainerManagement;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.monitor.common.MonitorRuntimeControlImpl;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.deployment.MonitorDeploymentContainer;
import com.sap.engine.services.monitor.install.MonitorContextImpl;
import com.sap.engine.services.monitor.server.ApplicationLifeCycleImpl;
import com.sap.engine.services.monitor.server.MonitorServiceServerRuntime;
import com.sap.engine.services.monitor.shell.ChangeDescriptionCommand;
import com.sap.engine.services.monitor.shell.ChangePeriodCommand;
import com.sap.engine.services.monitor.shell.ChangeReactOnFailureCommand;
import com.sap.engine.services.monitor.shell.ChangeStatesCommand;
import com.sap.engine.services.monitor.shell.ChangeThresholdsCommand;
import com.sap.engine.services.monitor.shell.ListMonitorTreeCommand;
import com.sap.engine.services.monitor.shell.MonitorInfoCommand;
import com.sap.engine.services.monitor.shell.PersistMonitoringDataCommand;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public class MonitorServerFrame
extends ApplicationFrameAdaptor
implements ContainerEventListener {
    private ThreadSystem threadContext = null;
    private boolean running = false;
    private IMonitorObjectFactory factory = MonitorFactory.createMonitorObjectFactory();
    private IMonitorNode tree = null;
    private String xmlStr = null;
    private File parentDir = null;
    private MonitorServiceRuntime m_serviceRuntime;
    private Properties properties = null;
    private ServiceState serviceState = null;
    private ContainerManagement containerInterface = null;
    private DeployCommunicator deployCommunicator = null;
    private MonitorDeploymentContainer deploymentContainer = null;
    private ApplicationServiceContext serviceContext = null;
    private int shellCommandId = 0;

    public void start() throws ServiceException {
        try {
            this.serviceContext = this.getServiceContext();
            ApplicationContainerContext appCtx = this.serviceContext.getContainerContext();
            this.serviceState = this.serviceContext.getServiceState();
            int nodeId = this.serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            this.m_serviceRuntime = MonitorServiceServerRuntime.createInstance(this, this.serviceContext.getServiceState(), this.serviceContext.getContainerContext().getSystemMonitor(), nodeId);
            this.serviceState.registerManagementInterface((ManagementInterface)new MonitorRuntimeControlImpl(this.m_serviceRuntime));
            this.m_serviceRuntime.installCcmsConnector();
            this.m_serviceRuntime.installTopNodes();
            ObjectRegistry registry = this.serviceContext.getContainerContext().getObjectRegistry();
            MonitorContextImpl monitorContext = new MonitorContextImpl(this.m_serviceRuntime);
            registry.registerInterfaceProvider("tc~monitoring~api", (Object)monitorContext);
            int mask = 65;
            HashSet<String> names = new HashSet<String>(1);
            names.add("shell");
            this.serviceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(" Unable to start monitor service due to " + e.toString(), (Throwable)e);
        }
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        if (this.m_serviceRuntime != null) {
            return this.m_serviceRuntime.changeProperties(properties);
        }
        return true;
    }

    public void stop() {
        ShellInterface shellInterface;
        if (this.m_serviceRuntime != null) {
            this.m_serviceRuntime.stop();
        }
        if (this.containerInterface != null) {
            this.containerInterface.unregisterContainer(this.deploymentContainer.getContainerInfo().getName());
            this.deployCommunicator = null;
            this.deploymentContainer = null;
            this.containerInterface = null;
        }
        this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("tc~monitoring~api");
        this.serviceState.unregisterManagementInterface();
        this.serviceState.unregisterContainerEventListener();
        MonitorServiceServerRuntime.deleteInstance();
        this.m_serviceRuntime = null;
        if (this.serviceContext.getContainerContext().getSystemMonitor().getInterface("shell").getStatus() == 11 && (shellInterface = (ShellInterface)this.serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("shell")) != null) {
            shellInterface.unregisterCommands(this.shellCommandId);
        }
    }

    public void containerStarted() {
        try {
            this.properties = this.serviceState.getProperties();
            this.m_serviceRuntime.init(this.properties);
            this.m_serviceRuntime.run();
            this.processApplications();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        try {
            if (interfaceName.equals("container")) {
                this.containerInterface = (ContainerManagement)interfaceImpl;
                this.deploymentContainer = new MonitorDeploymentContainer(this.serviceContext, new ApplicationLifeCycleImpl());
                this.deployCommunicator = this.containerInterface.registerContainer(this.deploymentContainer.getContainerInfo().getName(), (ContainerInterface)this.deploymentContainer);
            } else if (interfaceName.equals("shell")) {
                ShellInterface shellInterface = (ShellInterface)interfaceImpl;
                this.shellCommandId = shellInterface.registerCommands(this.getMonitorCommands());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("container")) {
            this.deployCommunicator = null;
            this.containerInterface = null;
            this.deploymentContainer = null;
        }
    }

    public void markForShutdown(long timeout) {
    }

    public boolean setServiceProperties(Properties properties) {
        return this.changeProperties(properties);
    }

    public boolean setServiceProperty(String key, String value) {
        Properties currentProperties = this.getServiceContext().getServiceState().getProperties();
        Properties properties = (Properties)((Hashtable)currentProperties).clone();
        ((Hashtable)properties).put(key, value);
        return this.changeProperties(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processApplications() {
        String[] apps;
        if (this.deployCommunicator != null && this.serviceContext != null && this.deploymentContainer != null && this.serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getState() == 3 && (apps = this.deployCommunicator.getMyApplications()) != null) {
            int i = 0;
            while (i < apps.length) {
                block7: {
                    if (this.deployCommunicator.getStatus(apps[i]) == 1) {
                        Object var6_6;
                        try {
                            try {
                                this.deployCommunicator.startModification(apps[i]);
                                String configPath = this.deployCommunicator.getAppConfigPath(apps[i]);
                                Configuration configuration = this.getConfigurationHandler().openConfiguration(configPath, 0);
                                this.deploymentContainer.prepareStart(apps[i], configuration);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                var6_6 = null;
                                this.deployCommunicator.modificationDone(apps[i]);
                                break block7;
                            }
                            var6_6 = null;
                        }
                        catch (Throwable throwable) {
                            var6_6 = null;
                            this.deployCommunicator.modificationDone(apps[i]);
                            throw throwable;
                        }
                        this.deployCommunicator.modificationDone(apps[i]);
                    }
                }
                ++i;
            }
        }
    }

    private Command[] getMonitorCommands() {
        return new Command[]{new ListMonitorTreeCommand((ServiceContext)this.serviceContext), new MonitorInfoCommand((ServiceContext)this.serviceContext), new ChangeThresholdsCommand((ServiceContext)this.serviceContext), new ChangeDescriptionCommand((ServiceContext)this.serviceContext), new ChangePeriodCommand((ServiceContext)this.serviceContext), new ChangeReactOnFailureCommand((ServiceContext)this.serviceContext), new ChangeStatesCommand((ServiceContext)this.serviceContext), new PersistMonitoringDataCommand((ServiceContext)this.serviceContext)};
    }

    public ConfigurationHandler getConfigurationHandler() throws ConfigurationException {
        ConfigurationContext configurationContext = (ConfigurationContext)this.getServiceContext().getCoreContext().getConfigurationHandlerFactory();
        return configurationContext.getConfigurationHandler();
    }
}

