/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.server;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GrmgTreeNode
extends DefaultMutableTreeNode {
    public static final int GRMG_CUSTOMIZING = 0;
    public static final int GRMG_CONTROL = 1;
    public static final int GRMG_RUNS = 2;
    public static final int GRMG_RUNLOG = 3;
    public static final int GRMG_ERRORLOG = 4;
    public static final int GRMG_SCENARIOS = 5;
    public static final int GRMG_SCENARIO = 6;
    public static final int GRMG_SCEN_NAME = 7;
    public static final int GRMG_SCEN_VERSION = 8;
    public static final int GRMG_SCEN_INST = 9;
    public static final int GRMG_SCEN_TYPE = 10;
    public static final int GRMG_SCEN_START_URL = 11;
    public static final int GRMG_SCEN_START_MOD = 12;
    public static final int GRMG_SCEN_TEXTS = 13;
    public static final int GRMG_SCEN_TEXT = 14;
    public static final int GRMG_SCEN_LANGU = 15;
    public static final int GRMG_SCEN_DESC = 16;
    public static final int GRMG_COMPONENTS = 17;
    public static final int GRMG_COMPONENT = 18;
    public static final int GRMG_COMP_NAME = 19;
    public static final int GRMG_COMP_VERSION = 20;
    public static final int GRMG_COMP_TYPE = 21;
    public static final int GRMG_COMP_TEXTS = 22;
    public static final int GRMG_COMP_TEXT = 23;
    public static final int GRMG_COMP_LANGU = 24;
    public static final int GRMG_COMP_DESC = 25;
    public static final int GRMG_PROPERTIES = 26;
    public static final int GRMG_PROPERTY = 27;
    public static final int GRMG_PROP_NAME = 28;
    public static final int GRMG_PROP_TYPE = 29;
    public static final int GRMG_PROP_VALUE = 30;
    public static final int GRMG_LEAF = 40;
    public static int GRMG_RUNS_LENGTH = 1;
    public static int GRMG_RUNLOG_LENGTH = 1;
    public static int GRMG_ERRORLOG_LENGTH = 1;
    public static int GRMG_SCEN_NAME_LENGTH = 8;
    public static int GRMG_SCEN_VERSION_LENGTH = 3;
    public static int GRMG_SCEN_INST_LENGTH = 3;
    public static int GRMG_SCEN_TYPE_LENGTH = 10;
    public static int GRMG_SCEN_START_URL_LENGTH = 250;
    public static int GRMG_SCEN_START_MOD_LENGTH = 50;
    public static int GRMG_SCEN_LANGU_LENGTH = 1;
    public static int GRMG_SCEN_DESC_LENGTH = 40;
    public static int GRMG_COMP_NAME_LENGTH = 8;
    public static int GRMG_COMP_VERSION_LENGTH = 3;
    public static int GRMG_COMP_TYPE_LENGTH = 10;
    public static int GRMG_COMP_LANGU_LENGTH = 1;
    public static int GRMG_COMP_DESC_LENGTH = 20;
    public static int GRMG_PROP_NAME_LENGTH = 40;
    public static int GRMG_PROP_TYPE_LENGTH = 3;
    public static int GRMG_PROP_VALUE_LENGTH = 250;
    public static String GRMG_CUSTOMIZING_STR = "customizing";
    public static String GRMG_CONTROL_STR = "control";
    public static String GRMG_RUNS_STR = "grmgruns";
    public static String GRMG_RUNLOG_STR = "runlog";
    public static String GRMG_ERRORLOG_STR = "errorlog";
    public static String GRMG_SCENARIOS_STR = "scenarios";
    public static String GRMG_SCENARIO_STR = "scenario";
    public static String GRMG_SCEN_NAME_STR = "scenname";
    public static String GRMG_SCEN_VERSION_STR = "scenversion";
    public static String GRMG_SCEN_INST_STR = "sceninst";
    public static String GRMG_SCEN_TYPE_STR = "scentype";
    public static String GRMG_SCEN_START_URL_STR = "scenstarturl";
    public static String GRMG_SCEN_START_MOD_STR = "scenstartmod";
    public static String GRMG_SCEN_TEXTS_STR = "scentexts";
    public static String GRMG_SCEN_TEXT_STR = "scentext";
    public static String GRMG_SCEN_LANGU_STR = "scenlangu";
    public static String GRMG_SCEN_DESC_STR = "scendesc";
    public static String GRMG_COMPONENTS_STR = "components";
    public static String GRMG_COMPONENT_STR = "component";
    public static String GRMG_COMP_NAME_STR = "compname";
    public static String GRMG_COMP_VERSION_STR = "compversion";
    public static String GRMG_COMP_TYPE_STR = "comptype";
    public static String GRMG_COMP_TEXTS_STR = "comptexts";
    public static String GRMG_COMP_TEXT_STR = "comptext";
    public static String GRMG_COMP_LANGU_STR = "complangu";
    public static String GRMG_COMP_DESC_STR = "compdesc";
    public static String GRMG_PROPERTIES_STR = "properties";
    public static String GRMG_PROPERTY_STR = "property";
    public static String GRMG_PROP_NAME_STR = "propname";
    public static String GRMG_PROP_TYPE_STR = "proptype";
    public static String GRMG_PROP_VALUE_STR = "propvalue";
    public static String GRMG_DEFAULT_STR = "";
    public static String GRMG_DTD = "<!DOCTYPE customizing [<!ELEMENT customizing (control, scenarios)><!ELEMENT control (grmgruns, runlog, errorlog)><!ELEMENT grmgruns (#PCDATA)><!ELEMENT runlog (#PCDATA)><!ELEMENT errorlog (#PCDATA)><!ELEMENT scenarios (scenario+)><!ELEMENT scenario (scenname, scenversion, sceninst, scentype, scenstarturl, scenstartmod, scentexts, components)><!ELEMENT scenname (#PCDATA)><!ELEMENT scenversion (#PCDATA)><!ELEMENT sceninst (#PCDATA)><!ELEMENT scentype (#PCDATA)><!ELEMENT scenstarturl (#PCDATA)><!ELEMENT scenstartmod (#PCDATA)><!ELEMENT scentexts (scentext)><!ELEMENT scentext (scenlangu, scendesc)><!ELEMENT scenlangu (#PCDATA)><!ELEMENT scendesc (#PCDATA)><!ELEMENT components (component+)><!ELEMENT component (compname, compversion, comptype, comptexts, properties)><!ELEMENT compname (#PCDATA)><!ELEMENT compversion (#PCDATA)><!ELEMENT comptype (#PCDATA)><!ELEMENT comptexts (comptext)><!ELEMENT comptext (complangu, compdesc)><!ELEMENT complangu (#PCDATA)><!ELEMENT compdesc (#PCDATA)><!ELEMENT properties (property+)><!ELEMENT property (propname, proptype, propvalue)><!ELEMENT propname (#PCDATA)><!ELEMENT proptype (#PCDATA)><!ELEMENT propvalue (#PCDATA)>]>";
    private int type;
    private String comment = null;

    public GrmgTreeNode(int type, String name) {
        super(name);
        this.type = type;
    }

    public GrmgTreeNode(int type, String name, String comment) {
        super(name);
        this.type = type;
        if (comment != null) {
            this.comment = comment.replace('\n', ' ').replace('\r', ' ');
        }
    }

    public int getNodeType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isLeaf() {
        return this.type == 40;
    }

    public static GrmgTreeNode buildGrmgTree(String file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(file.getBytes()));
        Element tempElement = document.getDocumentElement();
        if (tempElement == null || !tempElement.getTagName().trim().equals(GRMG_CUSTOMIZING_STR)) {
            throw new Exception();
        }
        GrmgTreeNode treeRoot = new GrmgTreeNode(0, GRMG_CUSTOMIZING_STR);
        NodeList customizingNodeList = tempElement.getChildNodes();
        GrmgTreeNode controlTreeNode = null;
        GrmgTreeNode scenariosTreeNode = null;
        HashMap<String, String> scenarioNamesDuplication = new HashMap<String, String>();
        int custIndx = 0;
        while (custIndx < customizingNodeList.getLength()) {
            String comment;
            Node customizingNode = customizingNodeList.item(custIndx);
            if (customizingNode.getNodeName().trim().equals(GRMG_CONTROL_STR)) {
                if (controlTreeNode != null) {
                    throw new Exception("Control tag more than once");
                }
                comment = GrmgTreeNode.getComment(customizingNodeList, custIndx);
                controlTreeNode = new GrmgTreeNode(1, GRMG_CONTROL_STR, comment);
                GrmgTreeNode runsTreeNode = null;
                GrmgTreeNode logTreeNode = null;
                GrmgTreeNode errorTreeNode = null;
                NodeList controlNodeList = customizingNode.getChildNodes();
                int controlIndx = 0;
                while (controlIndx < controlNodeList.getLength()) {
                    Node controlNode = controlNodeList.item(controlIndx);
                    if (controlNode.getNodeName().trim().equals(GRMG_RUNS_STR)) {
                        if (runsTreeNode != null) {
                            throw new Exception("Tag runs is repeating");
                        }
                        comment = GrmgTreeNode.getComment(controlNodeList, controlIndx);
                        runsTreeNode = new GrmgTreeNode(2, GRMG_RUNS_STR, comment);
                        runsTreeNode.add(GrmgTreeNode.getLeafNode(controlNode));
                    } else if (controlNode.getNodeName().trim().equals(GRMG_RUNLOG_STR)) {
                        if (logTreeNode != null) {
                            throw new Exception("Tag runslog is repeating");
                        }
                        comment = GrmgTreeNode.getComment(controlNodeList, controlIndx);
                        logTreeNode = new GrmgTreeNode(3, GRMG_RUNLOG_STR, comment);
                        logTreeNode.add(GrmgTreeNode.getLeafNode(controlNode));
                    } else if (controlNode.getNodeName().trim().equals(GRMG_ERRORLOG_STR)) {
                        if (errorTreeNode != null) {
                            throw new Exception("Tag errorlog is repeating");
                        }
                        comment = GrmgTreeNode.getComment(controlNodeList, controlIndx);
                        errorTreeNode = new GrmgTreeNode(4, GRMG_ERRORLOG_STR, comment);
                        errorTreeNode.add(GrmgTreeNode.getLeafNode(controlNode));
                    }
                    ++controlIndx;
                }
                if (runsTreeNode == null) {
                    runsTreeNode = new GrmgTreeNode(2, GRMG_RUNS_STR, null);
                    runsTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                }
                if (logTreeNode == null) {
                    logTreeNode = new GrmgTreeNode(3, GRMG_RUNLOG_STR, null);
                    logTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                }
                if (errorTreeNode == null) {
                    errorTreeNode = new GrmgTreeNode(4, GRMG_ERRORLOG_STR, null);
                    errorTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                }
                controlTreeNode.add(runsTreeNode);
                controlTreeNode.add(logTreeNode);
                controlTreeNode.add(errorTreeNode);
            } else if (customizingNode.getNodeName().trim().equals(GRMG_SCENARIOS_STR)) {
                if (scenariosTreeNode != null) {
                    throw new Exception("Scenarios tag is repeating");
                }
                comment = GrmgTreeNode.getComment(customizingNodeList, custIndx);
                scenariosTreeNode = new GrmgTreeNode(5, GRMG_SCENARIOS_STR, comment);
                NodeList scenariosNodeList = customizingNode.getChildNodes();
                int scenariosIndx = 0;
                while (scenariosIndx < scenariosNodeList.getLength()) {
                    Node scenariosNode = scenariosNodeList.item(scenariosIndx);
                    if (scenariosNode.getNodeName().trim().equals(GRMG_SCENARIO_STR)) {
                        comment = GrmgTreeNode.getComment(scenariosNodeList, scenariosIndx);
                        GrmgTreeNode scenarioTreeNode = new GrmgTreeNode(6, GRMG_SCENARIO_STR, comment);
                        NodeList scenarioNodeList = scenariosNode.getChildNodes();
                        GrmgTreeNode scenenameTreeNode = null;
                        GrmgTreeNode sceneversionTreeNode = null;
                        GrmgTreeNode sceneinstTreeNode = null;
                        GrmgTreeNode scenetypeTreeNode = null;
                        GrmgTreeNode sceneurlTreeNode = null;
                        GrmgTreeNode scenemodTreeNode = null;
                        GrmgTreeNode scenetextsTreeNode = null;
                        GrmgTreeNode scenetextTreeNode = null;
                        GrmgTreeNode scenelanguTreeNode = null;
                        GrmgTreeNode scenedescTreeNode = null;
                        GrmgTreeNode componentsTreeNode = null;
                        int scenarioIndx = 0;
                        while (scenarioIndx < scenarioNodeList.getLength()) {
                            Node scenarioNode = scenarioNodeList.item(scenarioIndx);
                            String scenarioNodeName = scenarioNode.getNodeName().trim();
                            if (scenarioNodeName.equals(GRMG_SCEN_NAME_STR)) {
                                if (scenenameTreeNode != null) {
                                    throw new Exception("scenname tag is repeating");
                                }
                                comment = GrmgTreeNode.getComment(scenarioNodeList, scenarioIndx);
                                scenenameTreeNode = new GrmgTreeNode(7, GRMG_SCEN_NAME_STR, comment);
                                GrmgTreeNode scenarioName = GrmgTreeNode.getLeafNode(scenarioNode);
                                String scenarioNameString = (String)scenarioName.getUserObject();
                                if (scenarioNameString.length() == 0) {
                                    throw new Exception("grmg-customizing.xml have atlest one scenario with nothing in it scenname tag.");
                                }
                                if (scenarioNamesDuplication.containsKey(scenarioNameString)) {
                                    throw new Exception("There is atleast one pair of scenarios with same name.");
                                }
                                scenarioNamesDuplication.put(scenarioNameString, scenarioNameString);
                                scenenameTreeNode.add(scenarioName);
                            } else if (scenarioNodeName.equals(GRMG_SCEN_VERSION_STR)) {
                                if (sceneversionTreeNode != null) {
                                    throw new Exception("scenversion tag is repeating");
                                }
                                comment = GrmgTreeNode.getComment(scenarioNodeList, scenarioIndx);
                                sceneversionTreeNode = new GrmgTreeNode(8, GRMG_SCEN_VERSION_STR, comment);
                                sceneversionTreeNode.add(GrmgTreeNode.getLeafNode(scenarioNode));
                            } else if (scenarioNodeName.equals(GRMG_SCEN_INST_STR)) {
                                if (sceneinstTreeNode != null) {
                                    throw new Exception("sceninst tag is repeating");
                                }
                                comment = GrmgTreeNode.getComment(scenarioNodeList, scenarioIndx);
                                sceneinstTreeNode = new GrmgTreeNode(9, GRMG_SCEN_INST_STR, comment);
                                sceneinstTreeNode.add(GrmgTreeNode.getLeafNode(scenarioNode));
                            } else if (scenarioNodeName.equals(GRMG_SCEN_TYPE_STR)) {
                                if (scenetypeTreeNode != null) {
                                    throw new Exception("sceninst tag is repeating");
                                }
                                comment = GrmgTreeNode.getComment(scenarioNodeList, scenarioIndx);
                                scenetypeTreeNode = new GrmgTreeNode(10, GRMG_SCEN_TYPE_STR, comment);
                                scenetypeTreeNode.add(GrmgTreeNode.getLeafNode(scenarioNode));
                            } else if (scenarioNodeName.equals(GRMG_SCEN_START_URL_STR)) {
                                if (sceneurlTreeNode != null) {
                                    throw new Exception("sceninst tag is repeating");
                                }
                                comment = GrmgTreeNode.getComment(scenarioNodeList, scenarioIndx);
                                sceneurlTreeNode = new GrmgTreeNode(11, GRMG_SCEN_START_URL_STR, comment);
                                sceneurlTreeNode.add(GrmgTreeNode.getLeafNode(scenarioNode));
                            } else if (scenarioNodeName.equals(GRMG_SCEN_START_MOD_STR)) {
                                if (scenemodTreeNode != null) {
                                    throw new Exception("sceninst tag is repeating");
                                }
                                comment = GrmgTreeNode.getComment(scenarioNodeList, scenarioIndx);
                                scenemodTreeNode = new GrmgTreeNode(12, GRMG_SCEN_START_MOD_STR, comment);
                                scenemodTreeNode.add(GrmgTreeNode.getLeafNode(scenarioNode));
                            } else if (scenarioNodeName.equals(GRMG_SCEN_TEXTS_STR)) {
                                if (scenetextsTreeNode != null) {
                                    throw new Exception("scentexts tag is repeating");
                                }
                                comment = GrmgTreeNode.getComment(scenarioNodeList, scenarioIndx);
                                scenetextsTreeNode = new GrmgTreeNode(13, GRMG_SCEN_TEXTS_STR, comment);
                                NodeList scenetextsNodeList = scenarioNode.getChildNodes();
                                int scenetextsIndx = 0;
                                while (scenetextsIndx < scenetextsNodeList.getLength()) {
                                    Node scenetextsNode = scenetextsNodeList.item(scenetextsIndx);
                                    if (scenetextsNode.getNodeName().trim().equals(GRMG_SCEN_TEXT_STR)) {
                                        if (scenetextTreeNode != null) {
                                            throw new Exception("scenetext tag is repeating");
                                        }
                                        comment = GrmgTreeNode.getComment(scenetextsNodeList, scenetextsIndx);
                                        scenetextTreeNode = new GrmgTreeNode(14, GRMG_SCEN_TEXT_STR, comment);
                                        NodeList scenetextNodeList = scenetextsNode.getChildNodes();
                                        int scenetextIndx = 0;
                                        while (scenetextIndx < scenetextNodeList.getLength()) {
                                            Node scenetextNode = scenetextNodeList.item(scenetextIndx);
                                            if (scenetextNode.getNodeName().trim().equals(GRMG_SCEN_LANGU_STR)) {
                                                if (scenelanguTreeNode != null) {
                                                    throw new Exception("scenlangu tag is repeating");
                                                }
                                                comment = GrmgTreeNode.getComment(scenetextNodeList, scenetextIndx);
                                                scenelanguTreeNode = new GrmgTreeNode(15, GRMG_SCEN_LANGU_STR, comment);
                                                scenelanguTreeNode.add(GrmgTreeNode.getLeafNode(scenetextNode));
                                            } else if (scenetextNode.getNodeName().trim().equals(GRMG_SCEN_DESC_STR)) {
                                                if (scenedescTreeNode != null) {
                                                    throw new Exception("scentexts tag is repeating");
                                                }
                                                comment = GrmgTreeNode.getComment(scenetextNodeList, scenetextIndx);
                                                scenedescTreeNode = new GrmgTreeNode(16, GRMG_SCEN_DESC_STR, comment);
                                                scenedescTreeNode.add(GrmgTreeNode.getLeafNode(scenetextNode));
                                            }
                                            ++scenetextIndx;
                                        }
                                        if (scenelanguTreeNode == null) {
                                            scenelanguTreeNode = new GrmgTreeNode(15, GRMG_SCEN_LANGU_STR, null);
                                            scenelanguTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                        }
                                        if (scenedescTreeNode == null) {
                                            scenedescTreeNode = new GrmgTreeNode(16, GRMG_SCEN_DESC_STR, null);
                                            scenedescTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                        }
                                        scenetextTreeNode.add(scenelanguTreeNode);
                                        scenetextTreeNode.add(scenedescTreeNode);
                                        scenetextsTreeNode.add(scenetextTreeNode);
                                    }
                                    ++scenetextsIndx;
                                }
                                if (scenetextTreeNode == null) {
                                    scenelanguTreeNode = new GrmgTreeNode(15, GRMG_SCEN_LANGU_STR, null);
                                    scenelanguTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                    scenedescTreeNode = new GrmgTreeNode(16, GRMG_SCEN_DESC_STR, null);
                                    scenedescTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                    scenetextTreeNode = new GrmgTreeNode(14, GRMG_SCEN_TEXT_STR, null);
                                    scenetextTreeNode.add(scenelanguTreeNode);
                                    scenetextTreeNode.add(scenedescTreeNode);
                                    scenetextsTreeNode.add(scenetextTreeNode);
                                }
                            } else if (scenarioNodeName.equals(GRMG_COMPONENTS_STR)) {
                                if (componentsTreeNode != null) {
                                    throw new Exception("components tag is repeating");
                                }
                                comment = GrmgTreeNode.getComment(scenarioNodeList, scenarioIndx);
                                componentsTreeNode = new GrmgTreeNode(17, GRMG_COMPONENTS_STR, comment);
                                NodeList componentsNodeList = scenarioNode.getChildNodes();
                                int componenetsIndx = 0;
                                while (componenetsIndx < componentsNodeList.getLength()) {
                                    Node componentsNode = componentsNodeList.item(componenetsIndx);
                                    if (componentsNode.getNodeName().trim().equals(GRMG_COMPONENT_STR)) {
                                        comment = GrmgTreeNode.getComment(componentsNodeList, componenetsIndx);
                                        GrmgTreeNode componentTreeNode = new GrmgTreeNode(18, GRMG_COMPONENT_STR, comment);
                                        NodeList componentNodeList = componentsNode.getChildNodes();
                                        GrmgTreeNode compnameTreeNode = null;
                                        GrmgTreeNode compversionTreeNode = null;
                                        GrmgTreeNode comptypeTreeNode = null;
                                        GrmgTreeNode comptextsTreeNode = null;
                                        GrmgTreeNode comptextTreeNode = null;
                                        GrmgTreeNode complanguTreeNode = null;
                                        GrmgTreeNode compdescTreeNode = null;
                                        GrmgTreeNode comppropsTreeNode = null;
                                        int componentIndx = 0;
                                        while (componentIndx < componentNodeList.getLength()) {
                                            Node componentNode = componentNodeList.item(componentIndx);
                                            String componentNodeName = componentNode.getNodeName().trim();
                                            if (componentNodeName.equals(GRMG_COMP_NAME_STR)) {
                                                if (compnameTreeNode != null) {
                                                    throw new Exception("compname tag is repeating");
                                                }
                                                comment = GrmgTreeNode.getComment(componentNodeList, componentIndx);
                                                compnameTreeNode = new GrmgTreeNode(19, GRMG_COMP_NAME_STR, comment);
                                                compnameTreeNode.add(GrmgTreeNode.getLeafNode(componentNode));
                                            } else if (componentNodeName.equals(GRMG_COMP_VERSION_STR)) {
                                                if (compversionTreeNode != null) {
                                                    throw new Exception("compversion tag is repeating");
                                                }
                                                comment = GrmgTreeNode.getComment(componentNodeList, componentIndx);
                                                compversionTreeNode = new GrmgTreeNode(20, GRMG_COMP_VERSION_STR, comment);
                                                compversionTreeNode.add(GrmgTreeNode.getLeafNode(componentNode));
                                            } else if (componentNodeName.equals(GRMG_COMP_TYPE_STR)) {
                                                if (comptypeTreeNode != null) {
                                                    throw new Exception("comptype tag is repeating");
                                                }
                                                comment = GrmgTreeNode.getComment(componentNodeList, componentIndx);
                                                comptypeTreeNode = new GrmgTreeNode(21, GRMG_COMP_TYPE_STR, comment);
                                                comptypeTreeNode.add(GrmgTreeNode.getLeafNode(componentNode));
                                            } else if (componentNodeName.equals(GRMG_COMP_TEXTS_STR)) {
                                                if (comptextsTreeNode != null) {
                                                    throw new Exception("comptexts tag is repeating");
                                                }
                                                comment = GrmgTreeNode.getComment(componentNodeList, componentIndx);
                                                comptextsTreeNode = new GrmgTreeNode(22, GRMG_COMP_TEXTS_STR, comment);
                                                NodeList comptextsNodeList = componentNode.getChildNodes();
                                                int comptextsIndx = 0;
                                                while (comptextsIndx < comptextsNodeList.getLength()) {
                                                    Node comptextsNode = comptextsNodeList.item(comptextsIndx);
                                                    if (comptextsNode.getNodeName().trim().equals(GRMG_COMP_TEXT_STR)) {
                                                        if (comptextTreeNode != null) {
                                                            throw new Exception("comptext tag is repeating");
                                                        }
                                                        NodeList comptextNodeList = comptextsNode.getChildNodes();
                                                        int comptextIndx = 0;
                                                        while (comptextIndx < comptextNodeList.getLength()) {
                                                            Node comptextNode = comptextNodeList.item(comptextIndx);
                                                            if (comptextNode.getNodeName().trim().equals(GRMG_COMP_LANGU_STR)) {
                                                                if (complanguTreeNode != null) {
                                                                    throw new Exception("complangu tag is repeating");
                                                                }
                                                                comment = GrmgTreeNode.getComment(comptextNodeList, comptextIndx);
                                                                complanguTreeNode = new GrmgTreeNode(24, GRMG_COMP_LANGU_STR, comment);
                                                                complanguTreeNode.add(GrmgTreeNode.getLeafNode(comptextNode));
                                                            } else if (comptextNode.getNodeName().trim().equals(GRMG_COMP_DESC_STR)) {
                                                                if (compdescTreeNode != null) {
                                                                    throw new Exception("compdesc tag is repeating");
                                                                }
                                                                comment = GrmgTreeNode.getComment(comptextNodeList, comptextIndx);
                                                                compdescTreeNode = new GrmgTreeNode(25, GRMG_COMP_DESC_STR, comment);
                                                                compdescTreeNode.add(GrmgTreeNode.getLeafNode(comptextNode));
                                                            }
                                                            ++comptextIndx;
                                                        }
                                                        if (complanguTreeNode == null) {
                                                            complanguTreeNode = new GrmgTreeNode(24, GRMG_COMP_LANGU_STR, null);
                                                            complanguTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                                        }
                                                        if (compdescTreeNode == null) {
                                                            compdescTreeNode = new GrmgTreeNode(25, GRMG_COMP_DESC_STR, null);
                                                            compdescTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                                        }
                                                        comment = GrmgTreeNode.getComment(comptextsNodeList, comptextsIndx);
                                                        comptextTreeNode = new GrmgTreeNode(23, GRMG_COMP_TEXT_STR, comment);
                                                        comptextTreeNode.add(complanguTreeNode);
                                                        comptextTreeNode.add(compdescTreeNode);
                                                        comptextsTreeNode.add(comptextTreeNode);
                                                    }
                                                    ++comptextsIndx;
                                                }
                                                if (comptextTreeNode == null) {
                                                    complanguTreeNode = new GrmgTreeNode(24, GRMG_COMP_LANGU_STR, null);
                                                    complanguTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                                    compdescTreeNode = new GrmgTreeNode(25, GRMG_COMP_DESC_STR, null);
                                                    compdescTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                                    comptextTreeNode = new GrmgTreeNode(23, GRMG_COMP_TEXT_STR, null);
                                                    comptextTreeNode.add(complanguTreeNode);
                                                    comptextTreeNode.add(compdescTreeNode);
                                                    comptextsTreeNode.add(comptextTreeNode);
                                                }
                                            } else if (componentNodeName.equals(GRMG_PROPERTIES_STR)) {
                                                if (comppropsTreeNode != null) {
                                                    throw new Exception("properties tag is repeating");
                                                }
                                                comment = GrmgTreeNode.getComment(componentNodeList, componentIndx);
                                                comppropsTreeNode = new GrmgTreeNode(26, GRMG_PROPERTIES_STR, comment);
                                                NodeList comppropsNodeList = componentNode.getChildNodes();
                                                int comppropsIndx = 0;
                                                while (comppropsIndx < comppropsNodeList.getLength()) {
                                                    Node comppropsNode = comppropsNodeList.item(comppropsIndx);
                                                    if (comppropsNode.getNodeName().trim().equals(GRMG_PROPERTY_STR)) {
                                                        GrmgTreeNode propnameTreeNode = null;
                                                        GrmgTreeNode propvalueTreeNode = null;
                                                        GrmgTreeNode proptypeTreeNode = null;
                                                        NodeList comppropNodeList = comppropsNode.getChildNodes();
                                                        int comppropIndx = 0;
                                                        while (comppropIndx < comppropNodeList.getLength()) {
                                                            Node comppropNode = comppropNodeList.item(comppropIndx);
                                                            if (comppropNode.getNodeName().trim().equals(GRMG_PROP_NAME_STR)) {
                                                                if (propnameTreeNode != null) {
                                                                    throw new Exception("propname tag is repeating");
                                                                }
                                                                comment = GrmgTreeNode.getComment(comppropNodeList, comppropIndx);
                                                                propnameTreeNode = new GrmgTreeNode(28, GRMG_PROP_NAME_STR, comment);
                                                                propnameTreeNode.add(GrmgTreeNode.getLeafNode(comppropNode));
                                                            } else if (comppropNode.getNodeName().trim().equals(GRMG_PROP_TYPE_STR)) {
                                                                if (proptypeTreeNode != null) {
                                                                    throw new Exception("proptype tag is repeating");
                                                                }
                                                                comment = GrmgTreeNode.getComment(comppropNodeList, comppropIndx);
                                                                proptypeTreeNode = new GrmgTreeNode(29, GRMG_PROP_TYPE_STR, comment);
                                                                proptypeTreeNode.add(GrmgTreeNode.getLeafNode(comppropNode));
                                                            } else if (comppropNode.getNodeName().trim().equals(GRMG_PROP_VALUE_STR)) {
                                                                if (propvalueTreeNode != null) {
                                                                    throw new Exception("propvalue tag is repeating");
                                                                }
                                                                comment = GrmgTreeNode.getComment(comppropNodeList, comppropIndx);
                                                                propvalueTreeNode = new GrmgTreeNode(30, GRMG_PROP_VALUE_STR, comment);
                                                                propvalueTreeNode.add(GrmgTreeNode.getLeafNode(comppropNode));
                                                            }
                                                            ++comppropIndx;
                                                        }
                                                        if (propnameTreeNode == null) {
                                                            propnameTreeNode = new GrmgTreeNode(28, GRMG_PROP_NAME_STR, null);
                                                            propnameTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                                        }
                                                        if (proptypeTreeNode == null) {
                                                            proptypeTreeNode = new GrmgTreeNode(29, GRMG_PROP_TYPE_STR, null);
                                                            proptypeTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                                        }
                                                        if (propvalueTreeNode == null) {
                                                            propvalueTreeNode = new GrmgTreeNode(30, GRMG_PROP_VALUE_STR, null);
                                                            propvalueTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                                        }
                                                        comment = GrmgTreeNode.getComment(comppropsNodeList, comppropsIndx);
                                                        GrmgTreeNode comppropTreeNode = new GrmgTreeNode(27, GRMG_PROPERTY_STR, comment);
                                                        comppropTreeNode.add(propnameTreeNode);
                                                        comppropTreeNode.add(proptypeTreeNode);
                                                        comppropTreeNode.add(propvalueTreeNode);
                                                        comppropsTreeNode.add(comppropTreeNode);
                                                    }
                                                    ++comppropsIndx;
                                                }
                                            }
                                            ++componentIndx;
                                        }
                                        if (compnameTreeNode == null) {
                                            compnameTreeNode = new GrmgTreeNode(19, GRMG_COMP_NAME_STR, null);
                                            compnameTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                        }
                                        if (compversionTreeNode == null) {
                                            compversionTreeNode = new GrmgTreeNode(20, GRMG_COMP_VERSION_STR, null);
                                            compversionTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                        }
                                        if (comptypeTreeNode == null) {
                                            comptypeTreeNode = new GrmgTreeNode(21, GRMG_COMP_TYPE_STR, null);
                                            comptypeTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                        }
                                        if (comptextsTreeNode == null) {
                                            comptextsTreeNode = new GrmgTreeNode(22, GRMG_COMP_TEXTS_STR, null);
                                            complanguTreeNode = new GrmgTreeNode(24, GRMG_COMP_LANGU_STR, null);
                                            complanguTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                            compdescTreeNode = new GrmgTreeNode(25, GRMG_COMP_DESC_STR, null);
                                            compdescTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                                            comptextTreeNode = new GrmgTreeNode(23, GRMG_COMP_TEXT_STR, null);
                                            comptextTreeNode.add(complanguTreeNode);
                                            comptextTreeNode.add(compdescTreeNode);
                                            comptextsTreeNode.add(comptextTreeNode);
                                        }
                                        if (comppropsTreeNode == null) {
                                            comppropsTreeNode = new GrmgTreeNode(26, GRMG_PROPERTIES_STR, null);
                                        }
                                        componentTreeNode.add(compnameTreeNode);
                                        componentTreeNode.add(compversionTreeNode);
                                        componentTreeNode.add(comptypeTreeNode);
                                        componentTreeNode.add(comptextsTreeNode);
                                        componentTreeNode.add(comppropsTreeNode);
                                        componentsTreeNode.add(componentTreeNode);
                                    }
                                    ++componenetsIndx;
                                }
                            }
                            ++scenarioIndx;
                        }
                        if (scenenameTreeNode == null) {
                            throw new Exception("grmg-customizing.xml have atleast one scenarion without scenname tag.");
                        }
                        if (sceneversionTreeNode == null) {
                            sceneversionTreeNode = new GrmgTreeNode(8, GRMG_SCEN_VERSION_STR, null);
                            sceneversionTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                        }
                        if (sceneinstTreeNode == null) {
                            sceneinstTreeNode = new GrmgTreeNode(9, GRMG_SCEN_INST_STR, null);
                            sceneinstTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                        }
                        if (scenetypeTreeNode == null) {
                            scenetypeTreeNode = new GrmgTreeNode(10, GRMG_SCEN_TYPE_STR, null);
                            scenetypeTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                        }
                        if (sceneurlTreeNode == null) {
                            sceneurlTreeNode = new GrmgTreeNode(11, GRMG_SCEN_START_URL_STR, null);
                            sceneurlTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                        }
                        if (scenemodTreeNode == null) {
                            scenemodTreeNode = new GrmgTreeNode(12, GRMG_SCEN_START_MOD_STR, null);
                            scenemodTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                        }
                        if (scenetextsTreeNode == null) {
                            scenetextsTreeNode = new GrmgTreeNode(13, GRMG_SCEN_TEXTS_STR, null);
                            scenelanguTreeNode = new GrmgTreeNode(15, GRMG_SCEN_LANGU_STR, null);
                            scenelanguTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                            scenedescTreeNode = new GrmgTreeNode(16, GRMG_SCEN_DESC_STR, null);
                            scenedescTreeNode.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
                            scenetextTreeNode = new GrmgTreeNode(14, GRMG_SCEN_TEXT_STR, null);
                            scenetextTreeNode.add(scenelanguTreeNode);
                            scenetextTreeNode.add(scenedescTreeNode);
                            scenetextsTreeNode.add(scenetextTreeNode);
                        }
                        if (componentsTreeNode == null) {
                            componentsTreeNode = new GrmgTreeNode(17, GRMG_COMPONENTS_STR, null);
                        }
                        scenarioTreeNode.add(scenenameTreeNode);
                        scenarioTreeNode.add(sceneversionTreeNode);
                        scenarioTreeNode.add(sceneinstTreeNode);
                        scenarioTreeNode.add(scenetypeTreeNode);
                        scenarioTreeNode.add(sceneurlTreeNode);
                        scenarioTreeNode.add(scenemodTreeNode);
                        scenarioTreeNode.add(scenetextsTreeNode);
                        scenarioTreeNode.add(componentsTreeNode);
                        scenariosTreeNode.add(scenarioTreeNode);
                    }
                    ++scenariosIndx;
                }
            }
            ++custIndx;
        }
        if (controlTreeNode == null) {
            controlTreeNode = new GrmgTreeNode(1, GRMG_CONTROL_STR, null);
            GrmgTreeNode runsTreeNodeTmp = new GrmgTreeNode(2, GRMG_RUNS_STR, null);
            GrmgTreeNode logTreeNodeTmp = new GrmgTreeNode(3, GRMG_RUNLOG_STR, null);
            GrmgTreeNode errorTreeNodeTmp = new GrmgTreeNode(4, GRMG_ERRORLOG_STR, null);
            runsTreeNodeTmp.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
            logTreeNodeTmp.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
            errorTreeNodeTmp.add(new GrmgTreeNode(40, GRMG_DEFAULT_STR));
            controlTreeNode.add(runsTreeNodeTmp);
            controlTreeNode.add(logTreeNodeTmp);
            controlTreeNode.add(errorTreeNodeTmp);
        }
        if (scenariosTreeNode == null) {
            scenariosTreeNode = new GrmgTreeNode(5, GRMG_SCENARIOS_STR, null);
        }
        treeRoot.add(controlTreeNode);
        treeRoot.add(scenariosTreeNode);
        GrmgTreeNode.removeOverLimitTagsContent(treeRoot);
        return treeRoot;
    }

    public static String[] buildGrmgFile(GrmgTreeNode root, boolean toValidate) {
        String customization = null;
        String withDTD = null;
        String temp = GrmgTreeNode.buildFile(root);
        customization = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + temp;
        if (toValidate) {
            withDTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + GRMG_DTD + temp;
        }
        return new String[]{customization, withDTD};
    }

    private static GrmgTreeNode getLeafNode(Node parent) throws Exception {
        String txt = new String(GRMG_DEFAULT_STR);
        Node tempNode = parent.getFirstChild();
        if (tempNode != null) {
            if (tempNode.getNodeType() == 3 && tempNode.getNodeValue() != null) {
                txt = tempNode.getNodeValue().trim();
            } else {
                throw new Exception("Error in some node of customizing file.");
            }
        }
        return new GrmgTreeNode(40, txt);
    }

    private static String buildFile(GrmgTreeNode node) {
        if (node.isLeaf()) {
            return GrmgTreeNode.formatXMLEntityReferences((String)node.getUserObject()) + "\n";
        }
        String tmp = "";
        if (node.getComment() != null && !node.getComment().equals("")) {
            tmp = "<!--" + node.getComment() + "-->\n";
        }
        tmp = tmp + "<" + (String)node.getUserObject() + ">" + "\n";
        int i = 0;
        while (i < node.getChildCount()) {
            tmp = tmp + GrmgTreeNode.buildFile((GrmgTreeNode)node.getChildAt(i));
            ++i;
        }
        tmp = tmp + "</" + (String)node.getUserObject() + ">" + "\n";
        return tmp;
    }

    private static void removeOverLimitTagsContent(GrmgTreeNode node) {
        if (node.isLeaf()) {
            String tag = (String)node.getUserObject();
            int maxLength = GrmgTreeNode.maxLength(((GrmgTreeNode)node.getParent()).getNodeType());
            if (tag.length() > maxLength) {
                node.setUserObject(tag.substring(0, maxLength));
            }
            return;
        }
        int i = 0;
        while (i < node.getChildCount()) {
            GrmgTreeNode.removeOverLimitTagsContent((GrmgTreeNode)node.getChildAt(i));
            ++i;
        }
    }

    private static String getComment(NodeList nodeList, int index) {
        String comment = null;
        if (index == 0) {
            comment = null;
        } else if (nodeList.item(index - 1).getNodeType() == 8) {
            comment = nodeList.item(index - 1).getNodeValue().trim();
        } else if (index > 1 && nodeList.item(index - 1).getNodeType() == 3 && nodeList.item(index - 2).getNodeType() == 8) {
            comment = nodeList.item(index - 2).getNodeValue().trim();
        }
        return comment;
    }

    public static int maxLength(int node) {
        switch (node) {
            case 2: {
                return GRMG_RUNS_LENGTH;
            }
            case 3: {
                return GRMG_RUNLOG_LENGTH;
            }
            case 4: {
                return GRMG_ERRORLOG_LENGTH;
            }
            case 7: {
                return GRMG_SCEN_NAME_LENGTH;
            }
            case 8: {
                return GRMG_SCEN_VERSION_LENGTH;
            }
            case 9: {
                return GRMG_SCEN_INST_LENGTH;
            }
            case 10: {
                return GRMG_SCEN_TYPE_LENGTH;
            }
            case 11: {
                return GRMG_SCEN_START_URL_LENGTH;
            }
            case 12: {
                return GRMG_SCEN_START_MOD_LENGTH;
            }
            case 15: {
                return GRMG_SCEN_LANGU_LENGTH;
            }
            case 16: {
                return GRMG_SCEN_DESC_LENGTH;
            }
            case 19: {
                return GRMG_COMP_NAME_LENGTH;
            }
            case 20: {
                return GRMG_COMP_VERSION_LENGTH;
            }
            case 21: {
                return GRMG_COMP_TYPE_LENGTH;
            }
            case 24: {
                return GRMG_COMP_LANGU_LENGTH;
            }
            case 25: {
                return GRMG_COMP_DESC_LENGTH;
            }
            case 28: {
                return GRMG_PROP_NAME_LENGTH;
            }
            case 29: {
                return GRMG_PROP_TYPE_LENGTH;
            }
            case 30: {
                return GRMG_PROP_VALUE_LENGTH;
            }
        }
        return 0;
    }

    public static String formatXMLEntityReferences(String value) {
        String result = "";
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            result = c == '<' ? result + "&lt;" : (c == '&' ? result + "&amp;" : (c == '>' ? result + "&gt;" : (c == '\"' ? result + "&quot;" : (c == '\'' ? result + "&apos;" : result + c))));
            ++i;
        }
        return result;
    }
}

