/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.server;

import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.common.MonitorXMLParser;
import com.sap.engine.services.monitor.deployment.ApplicationLifeCycle;
import com.sap.engine.services.monitor.deployment.MonitorDeploymentException;
import com.sap.engine.services.monitor.install.MonitorInstaller;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.InputStream;

public class ApplicationLifeCycleImpl
implements ApplicationLifeCycle {
    private MonitorXMLParser monitorXMLParser = new MonitorXMLParser();
    private static Location location = Location.getLocation((String)"com.sap.engine.services.monitor.server.ApplicationLifeCycleImpl");

    public ApplicationLifeCycleImpl() {
        this.monitorXMLParser.configureParser();
    }

    public void applicationDeployed(String applicationName, File configurationFile) throws MonitorDeploymentException {
    }

    public void applicationStarted(String applicationName, InputStream configurationFileStream) throws MonitorDeploymentException {
        location.infoT("--> Application [" + applicationName + "] is started");
        MonitorServiceRuntime msr = MonitorServiceRuntime.getMSRInstance();
        msr.treatConfigFile(configurationFileStream, "application " + applicationName);
        location.infoT("--> Application [" + applicationName + "] is processed from monitor service.");
    }

    public void applicationModified(String applicationName, InputStream configurationFileStream) throws MonitorDeploymentException {
    }

    public void applicationStopped(String applicationName) throws MonitorDeploymentException {
        location.infoT("--> Application [" + applicationName + "] stopped....");
        MonitorInstaller.uninstallMonitors("application " + applicationName, null);
        location.infoT("--> Application [" + applicationName + "] is stoped and all related monitors and monitor nodes are uninstalled.");
    }

    public void applicationRemoved(String applicationName) throws MonitorDeploymentException {
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.removeApplication("application " + applicationName);
        }
    }

    public boolean isMonitoringConfigurationChanged(InputStream oldConfiguration, InputStream newConfiguration) throws MonitorDeploymentException {
        return false;
    }
}

